/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.authorizer;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;

public class AuthorizerConfig {
    public static final int DEFAULT_MAX_ACLS_PER_TENANT_PROP = 1000;
    private Optional<Integer> tenantDefaultMaxAcls = Optional.empty();
    private int defaultMaxAcls = 1000;
    private Map<String, Integer> tenantIdToMaxAcls = new ConcurrentHashMap<String, Integer>();
    private Map<String, Integer> tenantIdToAclCount = new ConcurrentHashMap<String, Integer>();
    private Metrics metrics;
    public static final String TENANT = "tenant";
    public static final String MAX_ACLS = "max-acls";
    public static final String CREATED_ACLS_COUNT_PER_TENANT = "created-acls-count-per-tenant";
    public static final String AUTHORIZER_METRICS_GROUP_NAME = "confluent-authorizer-metrics";

    public void setTenantMaxAcls(Optional<String> tenantIdOpt, Optional<Integer> maxAcls) {
        if (tenantIdOpt.isPresent()) {
            this.deleteAclCountMetric(tenantIdOpt.get());
            if (maxAcls.isPresent()) {
                this.tenantIdToMaxAcls.put(tenantIdOpt.get(), maxAcls.get());
            } else {
                this.tenantIdToMaxAcls.remove(tenantIdOpt.get());
            }
            this.addAclCountMetric(tenantIdOpt.get());
        } else {
            this.tenantDefaultMaxAcls = maxAcls;
        }
    }

    public void addAclCountMetric(String tenantId) {
        if (this.metrics != null) {
            MetricName metricName = this.buildMetricName(tenantId);
            this.metrics.addMetricIfAbsent(metricName, null, (config, now) -> this.getTenantAclCount(tenantId));
        }
    }

    public void deleteAclCountMetric(String tenantId) {
        if (this.metrics != null) {
            MetricName metricName = this.buildMetricName(tenantId);
            this.metrics.removeMetric(metricName);
        }
    }

    private MetricName buildMetricName(String tenantId) {
        return this.metrics.metricName(CREATED_ACLS_COUNT_PER_TENANT, AUTHORIZER_METRICS_GROUP_NAME, "Number of ACLs created per tenant", this.buildAclTags(tenantId));
    }

    public Map<String, String> buildAclTags(String tenantId) {
        LinkedHashMap<String, String> metricsTags = new LinkedHashMap<String, String>();
        metricsTags.put(TENANT, tenantId);
        metricsTags.put(MAX_ACLS, String.valueOf(this.maxAcls(tenantId)));
        return Collections.unmodifiableMap(metricsTags);
    }

    public void incrementTenantAclCount(String tenantId) {
        this.tenantIdToAclCount.merge(tenantId, 1, Integer::sum);
    }

    public void decrementTenantAclCount(String tenantId) {
        if (this.tenantIdToAclCount.containsKey(tenantId)) {
            this.tenantIdToAclCount.merge(tenantId, -1, Integer::sum);
        }
    }

    public void setDefaultMaxAcls(Integer maxAcls) {
        this.defaultMaxAcls = maxAcls == null ? 1000 : maxAcls;
    }

    public int defaultMaxAcls() {
        return this.defaultMaxAcls;
    }

    public int maxAcls(String tenantId) {
        if (tenantId == null) {
            return this.defaultMaxAcls;
        }
        return this.tenantIdToMaxAcls.getOrDefault(tenantId, this.tenantDefaultMaxAcls.orElse(this.defaultMaxAcls));
    }

    public void loadNewTenantIdToAclCount(Map<String, Integer> newTenantIdToAclCount) {
        Set<String> keysToRemove = this.tenantIdToAclCount.keySet().stream().filter(key -> !newTenantIdToAclCount.containsKey(key)).collect(Collectors.toSet());
        this.tenantIdToAclCount.keySet().removeIf(keysToRemove::contains);
        this.tenantIdToAclCount.putAll(newTenantIdToAclCount);
        newTenantIdToAclCount.keySet().forEach(this::addAclCountMetric);
        keysToRemove.forEach(this::addAclCountMetric);
    }

    public int getTenantAclCount(String tenantId) {
        return this.tenantIdToAclCount.getOrDefault(tenantId, 0);
    }

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }
}

