/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.zip.Checksum;

final class Crc32CUtil {
    private static final int[] CRC32C_TABLE = new int[]{0, -227835133, -516198153, 324072436, -946170081, 904991772, 648144872, -724933397, -1965467441, 2024987596, 1809983544, -1719030981, 1296289744, -1087877933, -1401372889, 1578318884, 274646895, -499825556, -244992104, 51262619, -675000208, 632279923, 922689671, -996891772, -1702387808, 1760304291, 2075979607, -1982370732, 1562183871, -1351185476, -1138329528, 1313733451, 549293790, -757723683, -1048117719, 871202090, -416867903, 357341890, 102525238, -193467851, -1436232175, 1477399826, 1264559846, -1187764763, 1845379342, -1617575411, -1933233671, 2125378298, 820201905, -1031222606, -774358714, 598981189, -143008082, 85089709, 373468761, -467063462, -1170599554, 1213305469, 1526817161, -1452612982, 2107672161, -1882520222, -1667500394, 1861252501, 1098587580, -1290756417, -1606390453, 1378610760, -2032039261, 1955203488, 1742404180, -1783531177, -878557837, 969524848, 714683780, -655182201, 205050476, -28094097, -318528869, 526918040, 1361435347, -1555146288, -1340167644, 1114974503, -1765847604, 1691668175, 2005155131, -2047885768, -604208612, 697762079, 986182379, -928222744, 476452099, -301099520, -44210700, 255256311, 1640403810, -1817374623, -2130844779, 1922457750, -1503918979, 1412925310, 1197962378, -1257441399, -350237779, 427051182, 170179418, -129025959, 746937522, -554770511, -843174843, 1070968646, 1905808397, -2081171698, -1868356358, 1657317369, -1241332974, 1147748369, 1463399397, -1521340186, -79622974, 153784257, 444234805, -401473738, 1021025245, -827320098, -572462294, 797665321, -2097792136, 1889384571, 1674398607, -1851340660, 1164749927, -1224265884, -1537745776, 1446797203, 137323447, -96149324, -384560320, 461344835, -810158936, 1037989803, 781091935, -588970148, -1834419177, 1623424788, 1939049696, -2114449437, 1429367560, -1487280117, -1274471425, 1180866812, 410100952, -367384613, -112536529, 186734380, -538233913, 763408580, 1053836080, -860110797, -1572096602, 1344288421, 1131464017, -1323612590, 1708204729, -1749376582, -2065018290, 1988219213, 680717673, -621187478, -911630946, 1002577565, -284657034, 493091189, 238226049, -61306494, -1307217207, 1082061258, 1395524158, -1589280451, 1972364758, -2015074603, -1800104671, 1725896226, 952904198, -894981883, -638100751, 731699698, -11092711, 222117402, 510512622, -335130899, -1014159676, 837199303, 582374963, -790768336, 68661723, -159632680, -450051796, 390545967, 1230274059, -1153434360, -1469116676, 1510247935, -1899042540, 2091215383, 1878366691, -1650582816, -741088853, 565732008, 854102364, -1065151905, 340358836, -433916489, -177076669, 119113024, 1493875044, -1419691417, -1204696685, 1247431312, -1634718085, 1828433272, 2141937292, -1916740209, -483350502, 291187481, 34330861, -262120466, 615137029, -691946490, -980332558, 939183345, 1776939221, -1685949482, -1999470558, 2058945313, -1368168502, 1545135305, 1330124605, -1121741762, -210866315, 17165430, 307568514, -532767615, 888469610, -962626711, -707819363, 665062302, 2042050490, -1948470087, -1735637171, 1793573966, -1104306011, 1279665062, 1595330642, -1384295599};
    private static final int[] REVERSE_CRC32C_TABLE = new int[]{0, 241, 226, 19, 196, 53, 38, 215, 136, 121, 106, 155, 76, 189, 174, 95, 16, 225, 242, 3, 212, 37, 54, 199, 152, 105, 122, 139, 92, 173, 190, 79, 32, 209, 194, 51, 228, 21, 6, 247, 168, 89, 74, 187, 108, 157, 142, 127, 48, 193, 210, 35, 244, 5, 22, 231, 184, 73, 90, 171, 124, 141, 158, 111, 177, 64, 83, 162, 117, 132, 151, 102, 57, 200, 219, 42, 253, 12, 31, 238, 161, 80, 67, 178, 101, 148, 135, 118, 41, 216, 203, 58, 237, 28, 15, 254, 145, 96, 115, 130, 85, 164, 183, 70, 25, 232, 251, 10, 221, 44, 63, 206, 129, 112, 99, 146, 69, 180, 167, 86, 9, 248, 235, 26, 205, 60, 47, 222, 98, 147, 128, 113, 166, 87, 68, 181, 234, 27, 8, 249, 46, 223, 204, 61, 114, 131, 144, 97, 182, 71, 84, 165, 250, 11, 24, 233, 62, 207, 220, 45, 66, 179, 160, 81, 134, 119, 100, 149, 202, 59, 40, 217, 14, 255, 236, 29, 82, 163, 176, 65, 150, 103, 116, 133, 218, 43, 56, 201, 30, 239, 252, 13, 211, 34, 49, 192, 23, 230, 245, 4, 91, 170, 185, 72, 159, 110, 125, 140, 195, 50, 33, 208, 7, 246, 229, 20, 75, 186, 169, 88, 143, 126, 109, 156, 243, 2, 17, 224, 55, 198, 213, 36, 123, 138, 153, 104, 191, 78, 93, 172, 227, 18, 1, 240, 39, 214, 197, 52, 107, 154, 137, 120, 175, 94, 77, 188};

    Crc32CUtil() {
    }

    public static Checksum feedRegister(Checksum checksum, int desiredCrc) {
        int[] crcIdx = new int[4];
        byte[] feedBytes = new byte[4];
        for (int i = 3; i >= 0; --i) {
            crcIdx[i] = REVERSE_CRC32C_TABLE[desiredCrc >>> 24];
            desiredCrc = (desiredCrc ^ CRC32C_TABLE[crcIdx[i]]) << 8;
        }
        int initialCrc = -1;
        for (int i = 0; i < 4; ++i) {
            feedBytes[i] = (byte)((initialCrc ^ crcIdx[i]) & 0xFF);
            initialCrc = initialCrc >>> 8 ^ CRC32C_TABLE[feedBytes[i] & 0xFF ^ initialCrc & 0xFF];
        }
        checksum.update(feedBytes, 0, 4);
        return checksum;
    }
}

