/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractResponse;

public class ShareFetchResponse
extends AbstractResponse {
    private final ShareFetchResponseData data;

    private ShareFetchResponse(ShareFetchResponseData data) {
        super(ApiKeys.SHARE_FETCH);
        this.data = data;
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public ShareFetchResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> counts = new EnumMap<Errors, Integer>(Errors.class);
        ShareFetchResponse.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
        this.data.responses().forEach(topic -> topic.partitions().forEach(partition -> ShareFetchResponse.updateErrorCounts(counts, Errors.forCode(partition.errorCode()))));
        return counts;
    }

    public LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> responseData(Map<Uuid, String> topicNames) {
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> responseData = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        this.data.responses().forEach(topicResponse -> {
            String name = (String)topicNames.get(topicResponse.topicId());
            if (name != null) {
                topicResponse.partitions().forEach(partitionData -> responseData.put(new TopicIdPartition(topicResponse.topicId(), new TopicPartition(name, partitionData.partitionIndex())), (ShareFetchResponseData.PartitionData)partitionData));
            }
        });
        return responseData;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static ShareFetchResponse parse(Readable readable, short version, MessageContext context) {
        return new ShareFetchResponse(new ShareFetchResponseData(readable, version, context));
    }

    public static Records recordsOrFail(ShareFetchResponseData.PartitionData partition) {
        if (partition.records() == null) {
            return MemoryRecords.EMPTY;
        }
        if (partition.records() instanceof Records) {
            return (Records)partition.records();
        }
        throw new ClassCastException("The record type is " + partition.records().getClass().getSimpleName() + ", which is not a subtype of " + Records.class.getSimpleName() + ". This method is only safe to call if the `ShareFetchResponse` was deserialized from bytes.");
    }

    public static int sizeOf(short version, Iterator<Map.Entry<TopicIdPartition, ShareFetchResponseData.PartitionData>> partIterator) {
        ShareFetchResponseData data = ShareFetchResponse.toMessage(Errors.NONE, 0, partIterator, Collections.emptyList(), 0);
        ObjectSerializationCache cache = new ObjectSerializationCache();
        return 4 + data.size(cache, version);
    }

    public static int recordsSize(ShareFetchResponseData.PartitionData partition) {
        return partition.records() == null ? 0 : partition.records().sizeInBytes();
    }

    public static ShareFetchResponse of(Errors error, int throttleTimeMs, LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> responseData, List<Node> nodeEndpoints, int acquisitionLockTimeout) {
        return new ShareFetchResponse(ShareFetchResponse.toMessage(error, throttleTimeMs, responseData.entrySet().iterator(), nodeEndpoints, acquisitionLockTimeout));
    }

    private static ShareFetchResponseData toMessage(Errors error, int throttleTimeMs, Iterator<Map.Entry<TopicIdPartition, ShareFetchResponseData.PartitionData>> partIterator, List<Node> nodeEndpoints, int acquisitionLockTimeout) {
        ShareFetchResponseData.ShareFetchableTopicResponseCollection topicResponses = new ShareFetchResponseData.ShareFetchableTopicResponseCollection();
        while (partIterator.hasNext()) {
            ShareFetchResponseData.ShareFetchableTopicResponse topicResponse;
            Map.Entry<TopicIdPartition, ShareFetchResponseData.PartitionData> entry = partIterator.next();
            ShareFetchResponseData.PartitionData partitionData = entry.getValue();
            partitionData.setPartitionIndex(entry.getKey().topicPartition().partition());
            if (partitionData.records() == null) {
                partitionData.setRecords(MemoryRecords.EMPTY);
            }
            if ((topicResponse = topicResponses.find(entry.getKey().topicId())) == null) {
                topicResponse = new ShareFetchResponseData.ShareFetchableTopicResponse().setTopicId(entry.getKey().topicId()).setPartitions(new ArrayList<ShareFetchResponseData.PartitionData>());
                topicResponses.add(topicResponse);
            }
            topicResponse.partitions().add(partitionData);
        }
        ShareFetchResponseData data = new ShareFetchResponseData();
        nodeEndpoints.forEach(endpoint -> data.nodeEndpoints().add(new ShareFetchResponseData.NodeEndpoint().setNodeId(endpoint.id()).setHost(endpoint.host()).setPort(endpoint.port()).setRack(endpoint.rack())));
        return data.setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()).setAcquisitionLockTimeoutMs(acquisitionLockTimeout).setResponses(topicResponses);
    }

    public static ShareFetchResponseData.PartitionData partitionResponse(TopicIdPartition topicIdPartition, Errors error) {
        return ShareFetchResponse.partitionResponse(topicIdPartition.topicPartition().partition(), error);
    }

    private static ShareFetchResponseData.PartitionData partitionResponse(int partition, Errors error) {
        return new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(error.code()).setRecords(MemoryRecords.EMPTY);
    }
}

