/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.RemoveBrokersResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class RemoveBrokersResponse
extends AbstractResponse {
    private final RemoveBrokersResponseData data;

    public RemoveBrokersResponse(RemoveBrokersResponseData responseData) {
        super(ApiKeys.REMOVE_BROKERS);
        this.data = responseData;
    }

    @Override
    public RemoveBrokersResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        if (this.data.errorCode() != Errors.NONE.code()) {
            return Collections.singletonMap(Errors.forCode(this.data.errorCode()), this.data.brokersToRemove().size());
        }
        return RemoveBrokersResponse.errorCounts(this.data.brokersToRemove().stream().map(p -> Errors.forCode(p.errorCode())).collect(Collectors.toList()));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    public static RemoveBrokersResponse parse(Readable readable, short version, MessageContext context) {
        return new RemoveBrokersResponse(new RemoveBrokersResponseData(readable, version, context));
    }
}

