/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ReadShareGroupStateRequestData;
import org.apache.kafka.common.message.ReadShareGroupStateResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class ReadShareGroupStateResponse
extends AbstractResponse {
    private final ReadShareGroupStateResponseData data;

    public ReadShareGroupStateResponse(ReadShareGroupStateResponseData data) {
        super(ApiKeys.READ_SHARE_GROUP_STATE);
        this.data = data;
    }

    @Override
    public ReadShareGroupStateResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> counts = new EnumMap<Errors, Integer>(Errors.class);
        this.data.results().forEach(result -> result.partitions().forEach(partitionResult -> ReadShareGroupStateResponse.updateErrorCounts(counts, Errors.forCode(partitionResult.errorCode()))));
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
    }

    public static ReadShareGroupStateResponse parse(Readable readable, short version, MessageContext context) {
        return new ReadShareGroupStateResponse(new ReadShareGroupStateResponseData(readable, version, context));
    }

    public static ReadShareGroupStateResponseData toResponseData(Uuid topicId, int partition, long startOffset, int stateEpoch, List<ReadShareGroupStateResponseData.StateBatch> stateBatches) {
        return new ReadShareGroupStateResponseData().setResults(List.of(new ReadShareGroupStateResponseData.ReadStateResult().setTopicId(topicId).setPartitions(List.of(new ReadShareGroupStateResponseData.PartitionResult().setPartition(partition).setStartOffset(startOffset).setStateEpoch(stateEpoch).setStateBatches(stateBatches)))));
    }

    public static ReadShareGroupStateResponseData toErrorResponseData(Uuid topicId, int partitionId, Errors error, String errorMessage) {
        return new ReadShareGroupStateResponseData().setResults(List.of(new ReadShareGroupStateResponseData.ReadStateResult().setTopicId(topicId).setPartitions(List.of(new ReadShareGroupStateResponseData.PartitionResult().setPartition(partitionId).setErrorCode(error.code()).setErrorMessage(errorMessage)))));
    }

    public static ReadShareGroupStateResponseData.PartitionResult toErrorResponsePartitionResult(int partitionId, Errors error, String errorMessage) {
        return new ReadShareGroupStateResponseData.PartitionResult().setPartition(partitionId).setErrorCode(error.code()).setErrorMessage(errorMessage);
    }

    public static ReadShareGroupStateResponseData.ReadStateResult toResponseReadStateResult(Uuid topicId, List<ReadShareGroupStateResponseData.PartitionResult> partitionResults) {
        return new ReadShareGroupStateResponseData.ReadStateResult().setTopicId(topicId).setPartitions(partitionResults);
    }

    public static ReadShareGroupStateResponseData toGlobalErrorResponse(ReadShareGroupStateRequestData request, Errors error) {
        ArrayList<ReadShareGroupStateResponseData.ReadStateResult> readStateResults = new ArrayList<ReadShareGroupStateResponseData.ReadStateResult>();
        request.topics().forEach(topicData -> {
            ArrayList<ReadShareGroupStateResponseData.PartitionResult> partitionResults = new ArrayList<ReadShareGroupStateResponseData.PartitionResult>();
            topicData.partitions().forEach(partitionData -> partitionResults.add(ReadShareGroupStateResponse.toErrorResponsePartitionResult(partitionData.partition(), error, error.message())));
            readStateResults.add(ReadShareGroupStateResponse.toResponseReadStateResult(topicData.topicId(), partitionResults));
        });
        return new ReadShareGroupStateResponseData().setResults(readStateResults);
    }
}

