/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.message.PublishQuotaTargetResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class PublishQuotaTargetResponse
extends AbstractResponse {
    private final PublishQuotaTargetResponseData data;

    public PublishQuotaTargetResponse(PublishQuotaTargetResponseData data) {
        super(ApiKeys.PUBLISH_QUOTA_TARGET);
        this.data = data;
    }

    @Override
    public PublishQuotaTargetResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    public static PublishQuotaTargetResponse parse(Readable readable, short version, MessageContext context) {
        return new PublishQuotaTargetResponse(new PublishQuotaTargetResponseData(readable, version, context));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublishQuotaTargetResponse that = (PublishQuotaTargetResponse)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }
}

