/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Objects;
import org.apache.kafka.common.message.PublishQuotaTargetRequestData;
import org.apache.kafka.common.message.PublishQuotaTargetResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.PublishQuotaTargetResponse;

public class PublishQuotaTargetRequest
extends AbstractRequest {
    private final PublishQuotaTargetRequestData data;

    public PublishQuotaTargetRequest(short version) {
        this(new PublishQuotaTargetRequestData(), version);
    }

    public PublishQuotaTargetRequest(PublishQuotaTargetRequestData data, short version) {
        super(ApiKeys.PUBLISH_QUOTA_TARGET, version);
        this.data = data;
    }

    @Override
    public PublishQuotaTargetResponse getErrorResponse(int throttleTimeMs, Throwable throwable) {
        ApiError apiError = ApiError.fromThrowable(throwable);
        PublishQuotaTargetResponseData data = new PublishQuotaTargetResponseData().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setThrottleTimeMs(throttleTimeMs);
        return new PublishQuotaTargetResponse(data);
    }

    @Override
    public PublishQuotaTargetRequestData data() {
        return this.data;
    }

    public static PublishQuotaTargetRequest parse(Readable readable, short version, MessageContext context) {
        return new PublishQuotaTargetRequest(new PublishQuotaTargetRequestData(readable, version, context), version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublishQuotaTargetRequest that = (PublishQuotaTargetRequest)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public static class Builder
    extends AbstractRequest.Builder<PublishQuotaTargetRequest> {
        private final PublishQuotaTargetRequestData data;

        public Builder(PublishQuotaTargetRequestData data) {
            super(ApiKeys.PUBLISH_QUOTA_TARGET);
            this.data = data;
        }

        @Override
        public PublishQuotaTargetRequest build(short version) {
            return new PublishQuotaTargetRequest(this.data, version);
        }
    }
}

