/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class OffsetFetchResponse
extends AbstractResponse {
    public static final long INVALID_OFFSET = -1L;
    public static final String NO_METADATA = "";
    private static final List<Errors> PARTITION_ERRORS = Arrays.asList(Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.TOPIC_AUTHORIZATION_FAILED);
    private final short version;
    private final OffsetFetchResponseData data;
    private Map<String, OffsetFetchResponseData.OffsetFetchResponseGroup> groups = null;

    public OffsetFetchResponse(OffsetFetchResponseData data, short version) {
        super(ApiKeys.OFFSET_FETCH);
        this.data = data;
        this.version = version;
    }

    public OffsetFetchResponseData.OffsetFetchResponseGroup group(String groupId) {
        OffsetFetchResponseData.OffsetFetchResponseGroup group;
        if (this.version < 8) {
            short topLevelError;
            short s2 = topLevelError = this.version < 2 ? OffsetFetchResponse.topLevelError(this.data).code() : this.data.errorCode();
            if (topLevelError != Errors.NONE.code()) {
                return new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupId).setErrorCode(topLevelError);
            }
            return new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupId).setTopics(this.data.topics().stream().map(topic -> new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(topic.name()).setPartitions(topic.partitions().stream().map(partition -> new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(partition.partitionIndex()).setErrorCode(partition.errorCode()).setCommittedOffset(partition.committedOffset()).setMetadata(partition.metadata()).setCommittedLeaderEpoch(partition.committedLeaderEpoch())).collect(Collectors.toList()))).collect(Collectors.toList()));
        }
        if (this.groups == null) {
            this.groups = this.data.groups().stream().collect(Collectors.toMap(OffsetFetchResponseData.OffsetFetchResponseGroup::groupId, Function.identity()));
        }
        if ((group = this.groups.get(groupId)) == null) {
            throw new IllegalArgumentException("Group " + groupId + " not found in the response");
        }
        return group;
    }

    private static Errors topLevelError(OffsetFetchResponseData data) {
        for (OffsetFetchResponseData.OffsetFetchResponseTopic topic : data.topics()) {
            for (OffsetFetchResponseData.OffsetFetchResponsePartition partition : topic.partitions()) {
                Errors partitionError = Errors.forCode(partition.errorCode());
                if (partitionError == Errors.NONE || PARTITION_ERRORS.contains((Object)partitionError)) continue;
                return partitionError;
            }
        }
        return Errors.NONE;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> counts = new EnumMap<Errors, Integer>(Errors.class);
        if (this.version < 8) {
            if (this.version >= 2) {
                OffsetFetchResponse.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
            }
            this.data.topics().forEach(topic -> topic.partitions().forEach(partition -> OffsetFetchResponse.updateErrorCounts(counts, Errors.forCode(partition.errorCode()))));
        } else {
            this.data.groups().forEach(group -> {
                OffsetFetchResponse.updateErrorCounts(counts, Errors.forCode(group.errorCode()));
                group.topics().forEach(topic -> topic.partitions().forEach(partition -> OffsetFetchResponse.updateErrorCounts(counts, Errors.forCode(partition.errorCode()))));
            });
        }
        return counts;
    }

    public static OffsetFetchResponse parse(Readable readable, short version, MessageContext context) {
        return new OffsetFetchResponse(new OffsetFetchResponseData(readable, version, context), version);
    }

    @Override
    public OffsetFetchResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 4;
    }

    public static OffsetFetchResponseData.OffsetFetchResponseGroup groupError(OffsetFetchRequestData.OffsetFetchRequestGroup group, Errors error, int version) {
        if (version >= 2) {
            return new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(group.groupId()).setErrorCode(error.code());
        }
        return new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(group.groupId()).setTopics(group.topics().stream().map(topic -> new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(topic.name()).setPartitions(topic.partitionIndexes().stream().map(partition -> new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex((int)partition).setErrorCode(error.code()).setCommittedOffset(-1L).setMetadata(NO_METADATA).setCommittedLeaderEpoch(-1)).collect(Collectors.toList()))).collect(Collectors.toList()));
    }

    public static class Builder {
        private final List<OffsetFetchResponseData.OffsetFetchResponseGroup> groups;

        public Builder(OffsetFetchResponseData.OffsetFetchResponseGroup group) {
            this(List.of(group));
        }

        public Builder(List<OffsetFetchResponseData.OffsetFetchResponseGroup> groups) {
            this.groups = groups;
        }

        public OffsetFetchResponse build(short version) {
            OffsetFetchResponseData data = new OffsetFetchResponseData();
            if (version >= 8) {
                data.setGroups(this.groups);
            } else {
                if (this.groups.size() != 1) {
                    throw new UnsupportedVersionException("Version " + version + " of OffsetFetchResponse only supports one group.");
                }
                OffsetFetchResponseData.OffsetFetchResponseGroup group = this.groups.get(0);
                data.setErrorCode(group.errorCode());
                group.topics().forEach(topic -> {
                    OffsetFetchResponseData.OffsetFetchResponseTopic newTopic = new OffsetFetchResponseData.OffsetFetchResponseTopic().setName(topic.name());
                    data.topics().add(newTopic);
                    topic.partitions().forEach(partition -> newTopic.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(partition.partitionIndex()).setErrorCode(partition.errorCode()).setCommittedOffset(partition.committedOffset()).setMetadata(partition.metadata()).setCommittedLeaderEpoch(partition.committedLeaderEpoch())));
                });
            }
            return new OffsetFetchResponse(data, version);
        }
    }

    public static final class PartitionData {
        public final long offset;
        public final String metadata;
        public final Errors error;
        public final Optional<Integer> leaderEpoch;

        public PartitionData(long offset, Optional<Integer> leaderEpoch, String metadata, Errors error) {
            this.offset = offset;
            this.leaderEpoch = leaderEpoch;
            this.metadata = metadata;
            this.error = error;
        }

        public boolean hasError() {
            return this.error != Errors.NONE;
        }

        public boolean equals(Object other) {
            if (!(other instanceof PartitionData)) {
                return false;
            }
            PartitionData otherPartition = (PartitionData)other;
            return Objects.equals(this.offset, otherPartition.offset) && Objects.equals(this.leaderEpoch, otherPartition.leaderEpoch) && Objects.equals(this.metadata, otherPartition.metadata) && Objects.equals((Object)this.error, (Object)otherPartition.error);
        }

        public String toString() {
            return "PartitionData(offset=" + this.offset + ", leaderEpoch=" + String.valueOf(this.leaderEpoch.orElse(-1)) + ", metadata=" + this.metadata + ", error='" + this.error.toString() + ")";
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.offset, this.leaderEpoch, this.metadata, this.error});
        }
    }
}

