/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.ListMirrorsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class ListMirrorsResponse
extends AbstractResponse {
    private final ListMirrorsResponseData data;

    public ListMirrorsResponse(ListMirrorsResponseData data) {
        super(ApiKeys.LIST_MIRRORS);
        this.data = data;
    }

    public ListMirrorsResponse(Collection<String> topics, int throttleTimeMs) {
        this(new ListMirrorsResponseData().setThrottleTimeMs(throttleTimeMs).setTopics(new ArrayList<String>(topics)));
    }

    public ListMirrorsResponse(int throttleTimeMs, Throwable e) {
        this(new ListMirrorsResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e).code()).setErrorMessage(e.getMessage()));
    }

    public void complete(KafkaFutureImpl<Collection<String>> result) {
        Errors error = Errors.forCode(this.data.errorCode());
        if (error != Errors.NONE) {
            result.completeExceptionally(error.exception(this.data.errorMessage()));
            return;
        }
        result.complete(this.data.topics());
    }

    @Override
    public ListMirrorsResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    public static ListMirrorsResponse parse(Readable readable, short version, MessageContext context) {
        return new ListMirrorsResponse(new ListMirrorsResponseData(readable, version, context));
    }
}

