/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ListConfigResourcesRequestData;
import org.apache.kafka.common.message.ListConfigResourcesResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListConfigResourcesResponse;

public class ListConfigResourcesRequest
extends AbstractRequest {
    private final ListConfigResourcesRequestData data;

    private ListConfigResourcesRequest(ListConfigResourcesRequestData data, short version) {
        super(ApiKeys.LIST_CONFIG_RESOURCES, version);
        this.data = data;
    }

    @Override
    public ListConfigResourcesRequestData data() {
        return this.data;
    }

    @Override
    public ListConfigResourcesResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        ListConfigResourcesResponseData response = new ListConfigResourcesResponseData().setErrorCode(error.code()).setThrottleTimeMs(throttleTimeMs);
        return new ListConfigResourcesResponse(response);
    }

    public static ListConfigResourcesRequest parse(Readable readable, short version, MessageContext context) {
        return new ListConfigResourcesRequest(new ListConfigResourcesRequestData(readable, version, context), version);
    }

    @Override
    public String toString(boolean verbose) {
        return this.data.toString();
    }

    public Set<Byte> supportedResourceTypes() {
        return this.version() == 0 ? Set.of(Byte.valueOf(ConfigResource.Type.CLIENT_METRICS.id())) : Set.of(Byte.valueOf(ConfigResource.Type.TOPIC.id()), Byte.valueOf(ConfigResource.Type.BROKER.id()), Byte.valueOf(ConfigResource.Type.BROKER_LOGGER.id()), Byte.valueOf(ConfigResource.Type.CLIENT_METRICS.id()), Byte.valueOf(ConfigResource.Type.GROUP.id()));
    }

    public static class Builder
    extends AbstractRequest.Builder<ListConfigResourcesRequest> {
        public final ListConfigResourcesRequestData data;

        public Builder(ListConfigResourcesRequestData data) {
            super(ApiKeys.LIST_CONFIG_RESOURCES);
            this.data = data;
        }

        @Override
        public ListConfigResourcesRequest build(short version) {
            if (version == 0) {
                HashSet<Byte> resourceTypes = new HashSet<Byte>(this.data.resourceTypes());
                if (resourceTypes.size() != 1 || !resourceTypes.contains(ConfigResource.Type.CLIENT_METRICS.id())) {
                    throw new UnsupportedVersionException("The v0 ListConfigResources only supports CLIENT_METRICS");
                }
                return new ListConfigResourcesRequest(new ListConfigResourcesRequestData(), version);
            }
            return new ListConfigResourcesRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

