/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.kafka.common.requests.K2RequestContext;

public class K2RequestContextImpl
implements K2RequestContext {
    private volatile long batchEnqueue = -1L;
    private static final AtomicLongFieldUpdater<K2RequestContextImpl> batchEnqueueUpdater = AtomicLongFieldUpdater.newUpdater(K2RequestContextImpl.class, "batchEnqueue");
    private volatile long writeRecordsMs = -1L;
    private static final AtomicLongFieldUpdater<K2RequestContextImpl> writeRecordsMsUpdater = AtomicLongFieldUpdater.newUpdater(K2RequestContextImpl.class, "writeRecordsMs");
    private volatile long appendDataRefsMs = -1L;
    private static final AtomicLongFieldUpdater<K2RequestContextImpl> appendDataRefsMsUpdater = AtomicLongFieldUpdater.newUpdater(K2RequestContextImpl.class, "appendDataRefsMs");
    private volatile long timeInBatchMs = -1L;
    private static final AtomicLongFieldUpdater<K2RequestContextImpl> timeInBatchMsUpdater = AtomicLongFieldUpdater.newUpdater(K2RequestContextImpl.class, "timeInBatchMs");
    private volatile long fetchDataRefsMs = -1L;
    private static final AtomicLongFieldUpdater<K2RequestContextImpl> fetchDataRefsMsUpdater = AtomicLongFieldUpdater.newUpdater(K2RequestContextImpl.class, "fetchDataRefsMs");
    private volatile long fetchRecordsMs = -1L;
    private static final AtomicLongFieldUpdater<K2RequestContextImpl> fetchRecordsMsUpdater = AtomicLongFieldUpdater.newUpdater(K2RequestContextImpl.class, "fetchRecordsMs");
    private volatile int numDataRefsFetched = -1;
    private static final AtomicIntegerFieldUpdater<K2RequestContextImpl> numDataRefsFetchedUpdater = AtomicIntegerFieldUpdater.newUpdater(K2RequestContextImpl.class, "numDataRefsFetched");

    @Override
    public void setBatchEnqueueTime(long batchEnqueue) {
        boolean success = batchEnqueueUpdater.compareAndSet(this, -1L, batchEnqueue);
        if (!success && this.batchEnqueue != batchEnqueue) {
            throw new IllegalArgumentException("batchEnqueueTime can't be set more than once to a different value");
        }
    }

    @Override
    public long batchEnqueueTime() {
        return this.batchEnqueue;
    }

    @Override
    public long writeRecordsMs() {
        return this.writeRecordsMs;
    }

    @Override
    public void updateWriteRecordsMs(long writeRecordsMs) {
        writeRecordsMsUpdater.accumulateAndGet(this, writeRecordsMs, Math::max);
    }

    @Override
    public long timeInBatchMs() {
        return this.timeInBatchMs;
    }

    @Override
    public void updateTimeInBatchMs(long timeInBatchMs) {
        timeInBatchMsUpdater.accumulateAndGet(this, timeInBatchMs, Math::max);
    }

    @Override
    public long appendDataRefsMs() {
        return this.appendDataRefsMs;
    }

    @Override
    public void updateAppendDataRefsMs(long appendDataRefsMs) {
        appendDataRefsMsUpdater.accumulateAndGet(this, appendDataRefsMs, Math::max);
    }

    @Override
    public long fetchDataRefsMs() {
        return this.fetchDataRefsMs;
    }

    @Override
    public void updateFetchDataRefsMs(long fetchDataRefsMs) {
        fetchDataRefsMsUpdater.accumulateAndGet(this, fetchDataRefsMs, Math::max);
    }

    @Override
    public long fetchRecordsMs() {
        return this.fetchRecordsMs;
    }

    @Override
    public void updateFetchRecordsMs(long fetchRecordsMs) {
        fetchRecordsMsUpdater.accumulateAndGet(this, fetchRecordsMs, Math::max);
    }

    @Override
    public int numDataRefsFetched() {
        return this.numDataRefsFetched;
    }

    @Override
    public void setNumDataRefsFetched(int numDataRefsFetchedValue) {
        boolean success = numDataRefsFetchedUpdater.compareAndSet(this, -1, numDataRefsFetchedValue);
        if (!success && this.numDataRefsFetched != numDataRefsFetchedValue) {
            throw new IllegalArgumentException("numDataRefsFetched can't be set more than once to a different value");
        }
    }

    @Override
    public JsonNode toJsonNode() {
        int currentNumDataRefsFetched;
        long currentFetchRecordsMs;
        long currentFetchDataRefsMs;
        long currentAppendDataRefsMs;
        long currentTimeInBatchMs;
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        long currentWriteRecordsMs = this.writeRecordsMs;
        if (currentWriteRecordsMs != -1L) {
            node.set("writeRecordsMs", (JsonNode)new LongNode(currentWriteRecordsMs));
        }
        if ((currentTimeInBatchMs = this.timeInBatchMs) != -1L) {
            node.set("timeInBatchMs", (JsonNode)new LongNode(currentTimeInBatchMs));
        }
        if ((currentAppendDataRefsMs = this.appendDataRefsMs) != -1L) {
            node.set("appendDataRefsMs", (JsonNode)new LongNode(currentAppendDataRefsMs));
        }
        if ((currentFetchDataRefsMs = this.fetchDataRefsMs) != -1L) {
            node.set("fetchDataRefsMs", (JsonNode)new LongNode(currentFetchDataRefsMs));
        }
        if ((currentFetchRecordsMs = this.fetchRecordsMs) != -1L) {
            node.set("fetchRecordsMs", (JsonNode)new LongNode(currentFetchRecordsMs));
        }
        if ((currentNumDataRefsFetched = this.numDataRefsFetched) != -1) {
            node.set("numDataRefsFetched", (JsonNode)new IntNode(currentNumDataRefsFetched));
        }
        return node;
    }

    private String jsonNodeAsKeyValue(JsonNode node) {
        if (node == null || !node.isObject()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(", ");
        for (Map.Entry field : node.properties()) {
            String valueStr = ((JsonNode)field.getValue()).asText();
            joiner.add((String)field.getKey() + "=" + valueStr);
        }
        return joiner.toString();
    }

    public String toString() {
        return this.jsonNodeAsKeyValue(this.toJsonNode());
    }
}

