/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.InitializeShareGroupStateRequestData;
import org.apache.kafka.common.message.InitializeShareGroupStateResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.InitializeShareGroupStateResponse;

public class InitializeShareGroupStateRequest
extends AbstractRequest {
    private final InitializeShareGroupStateRequestData data;

    public InitializeShareGroupStateRequest(InitializeShareGroupStateRequestData data, short version) {
        super(ApiKeys.INITIALIZE_SHARE_GROUP_STATE, version);
        this.data = data;
    }

    @Override
    public InitializeShareGroupStateResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ArrayList<InitializeShareGroupStateResponseData.InitializeStateResult> results = new ArrayList<InitializeShareGroupStateResponseData.InitializeStateResult>();
        this.data.topics().forEach(topicResult -> results.add(new InitializeShareGroupStateResponseData.InitializeStateResult().setTopicId(topicResult.topicId()).setPartitions(topicResult.partitions().stream().map(partitionData -> new InitializeShareGroupStateResponseData.PartitionResult().setPartition(partitionData.partition()).setErrorCode(Errors.forException(e).code())).collect(Collectors.toList()))));
        return new InitializeShareGroupStateResponse(new InitializeShareGroupStateResponseData().setResults(results));
    }

    @Override
    public InitializeShareGroupStateRequestData data() {
        return this.data;
    }

    public static InitializeShareGroupStateRequest parse(Readable readable, short version, MessageContext context) {
        return new InitializeShareGroupStateRequest(new InitializeShareGroupStateRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<InitializeShareGroupStateRequest> {
        private final InitializeShareGroupStateRequestData data;

        public Builder(InitializeShareGroupStateRequestData data) {
            super(ApiKeys.INITIALIZE_SHARE_GROUP_STATE);
            this.data = data;
        }

        @Override
        public InitializeShareGroupStateRequest build(short version) {
            return new InitializeShareGroupStateRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

