/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.DescribeTenantsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeTenantsResponse
extends AbstractResponse {
    private final DescribeTenantsResponseData data;

    public DescribeTenantsResponse(DescribeTenantsResponseData data) {
        super(ApiKeys.DESCRIBE_TENANTS);
        this.data = data;
    }

    @Override
    public DescribeTenantsResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        DescribeTenantsResponse.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
        return counts;
    }

    public boolean hasError() {
        return this.error() != Errors.NONE;
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    public static DescribeTenantsResponse parse(Readable readable, short version, MessageContext context) {
        return new DescribeTenantsResponse(new DescribeTenantsResponseData(readable, version, context));
    }
}

