/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.List;
import org.apache.kafka.common.message.DeleteGroupsRequestData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DeleteGroupsResponse;

public class DeleteGroupsRequest
extends AbstractRequest {
    private final DeleteGroupsRequestData data;

    public DeleteGroupsRequest(DeleteGroupsRequestData data, short version) {
        super(ApiKeys.DELETE_GROUPS, version);
        this.data = data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(DeleteGroupsRequest.getErrorResultCollection(this.data.groupsNames(), Errors.forException(e))).setThrottleTimeMs(throttleTimeMs));
    }

    public static DeleteGroupsRequest parse(Readable readable, short version, MessageContext context) {
        return new DeleteGroupsRequest(new DeleteGroupsRequestData(readable, version, context), version);
    }

    @Override
    public DeleteGroupsRequestData data() {
        return this.data;
    }

    public static DeleteGroupsResponseData.DeletableGroupResultCollection getErrorResultCollection(List<String> groupIds, Errors error) {
        DeleteGroupsResponseData.DeletableGroupResultCollection resultCollection = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        groupIds.forEach(groupId -> resultCollection.add(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId((String)groupId).setErrorCode(error.code())));
        return resultCollection;
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteGroupsRequest> {
        private final DeleteGroupsRequestData data;

        public Builder(DeleteGroupsRequestData data) {
            super(ApiKeys.DELETE_GROUPS);
            this.data = data;
        }

        @Override
        public DeleteGroupsRequest build(short version) {
            return new DeleteGroupsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

