/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDomainSocketChannel;
import io.netty.channel.socket.nio.NioServerDomainSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiConsumer;
import javax.net.ssl.SSLSession;
import org.apache.kafka.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static EventLoopGroup createEventLoopGroup(int nrThreads, String threadNameSuffix) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("http2-client-" + threadNameSuffix + "-worker-%d").build();
        return Utils.createEventLoopGroup(nrThreads, threadFactory);
    }

    public static EventLoopGroup createEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup(nThreads, threadFactory);
        }
        LOGGER.warn("Epoll is not available, falling back to NIO. This may result in degraded performance.");
        return new NioEventLoopGroup(nThreads, threadFactory);
    }

    public static Class<? extends Channel> channelTypeForEventLoop(EventLoopGroup group) {
        return Utils.channelTypeForEventLoop(group, false);
    }

    public static Class<? extends ServerChannel> serverChannelTypeForEventLoop(EventLoopGroup group, boolean isUds) {
        return group instanceof EpollEventLoopGroup ? (isUds ? EpollServerDomainSocketChannel.class : EpollServerSocketChannel.class) : (isUds ? NioServerDomainSocketChannel.class : NioServerSocketChannel.class);
    }

    public static Class<? extends Channel> channelTypeForEventLoop(EventLoopGroup group, boolean isUds) {
        return group instanceof EpollEventLoopGroup ? (isUds ? EpollDomainSocketChannel.class : EpollSocketChannel.class) : (isUds ? NioDomainSocketChannel.class : NioSocketChannel.class);
    }

    public static <T, F> BiConsumer<? super T, ? super Throwable> exceptionSafe(CompletableFuture<F> future, BiConsumer<? super T, ? super Throwable> action) {
        return (result, throwable) -> {
            try {
                action.accept((Object)result, (Throwable)throwable);
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        };
    }

    public static <T, F> GenericFutureListener<? extends Future<? super T>> exceptionSafe(CompletableFuture<F> future, GenericFutureListener<Future<? super T>> listener) {
        return sourceFuture -> {
            try {
                listener.operationComplete(sourceFuture);
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        };
    }

    public static <T, F> GenericFutureListener<? extends Future<? super T>> exceptionSafe(Promise<F> promise, GenericFutureListener<Future<? super T>> listener) {
        return sourceFuture -> {
            try {
                listener.operationComplete(sourceFuture);
            }
            catch (Throwable t) {
                promise.setFailure(t);
            }
        };
    }

    public static int getInitialWindowSize(Http2Settings http2Settings) {
        return Optional.ofNullable(http2Settings.initialWindowSize()).orElse(153600);
    }

    public static int getMaxFrameSize(Http2Settings http2Settings) {
        return Optional.ofNullable(http2Settings.maxFrameSize()).orElse(16384);
    }

    public static Optional<SSLSession> sslSession(Channel channel) {
        SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
        if (sslHandler != null) {
            return Optional.ofNullable(sslHandler.engine().getSession());
        }
        return Optional.empty();
    }
}

