/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.netty.NettyHttp2Connection;
import org.apache.kafka.common.network.netty.NettyHttp2ConnectionInitializer;
import org.apache.kafka.common.network.netty.NettyHttp2Stream;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.network.netty.Utils;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class NettyClient {
    public static final int DEFAULT_CONNECTION_WINDOW_SIZE = Integer.MAX_VALUE;
    private final Logger log;
    private final LogContext logContext;
    private final Map<InetSocketAddress, NettyHttp2Connection> connections = new HashMap<InetSocketAddress, NettyHttp2Connection>();
    private final ReadWriteLock connectionMapLock = new ReentrantReadWriteLock();
    private final ChannelGroup trackedChannels;
    private final SslContext sslContext;
    private final EventLoopGroup eventLoopGroup;
    private final boolean flowControlEnabled;
    private final Http2Settings http2Settings;
    private final int connectionWindowSize;

    public NettyClient(SslContext sslContext, EventLoopGroup eventLoopGroup, LogContext logContext, boolean flowControlEnabled, Http2Settings http2Settings, int connectionWindowSize) {
        this.sslContext = sslContext;
        this.eventLoopGroup = eventLoopGroup;
        this.trackedChannels = new DefaultChannelGroup((EventExecutor)eventLoopGroup.next());
        this.log = logContext.logger(NettyClient.class);
        this.logContext = logContext;
        this.connectionWindowSize = connectionWindowSize;
        this.flowControlEnabled = flowControlEnabled;
        this.http2Settings = http2Settings;
    }

    public NettyClient(SslContext sslContext, EventLoopGroup eventLoopGroup, LogContext logContext, boolean flowControlEnabled, Http2Settings http2Settings) {
        this(sslContext, eventLoopGroup, logContext, flowControlEnabled, http2Settings, Integer.MAX_VALUE);
    }

    public NettyClient(SslContext sslContext, EventLoopGroup eventLoopGroup, LogContext logContext, boolean flowControlEnabled) {
        this(sslContext, eventLoopGroup, logContext, flowControlEnabled, new Http2Settings());
    }

    public NettyClient(SslContext sslContext, EventLoopGroup eventLoopGroup, LogContext logContext, int connectionWindowSize) {
        this(sslContext, eventLoopGroup, logContext, true, new Http2Settings(), connectionWindowSize);
    }

    public NettyClient(SslContext sslContext, EventLoopGroup eventLoopGroup, LogContext logContext) {
        this(sslContext, eventLoopGroup, logContext, true, new Http2Settings());
    }

    public CompletableFuture<Void> shutdown() {
        this.log.info("Stopping HTTP/2 client");
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.trackedChannels.close().addListener(Utils.exceptionSafe(future, listener -> {
            if (listener.isSuccess()) {
                future.complete(null);
                this.log.info("Stopped HTTP/2 client");
            } else {
                this.log.error("Unable to close HTTP/2 client channels", listener.cause());
                future.completeExceptionally(listener.cause());
            }
        }));
        this.connectionMapLock.writeLock().lock();
        try {
            this.connections.clear();
        }
        finally {
            this.connectionMapLock.writeLock().unlock();
        }
        return future;
    }

    public int connectionWindowSize() {
        return this.connectionWindowSize;
    }

    public ChannelGroup trackedChannels() {
        return this.trackedChannels;
    }

    public CompletableFuture<NettyStream> createStream(InetSocketAddress address, NettyStream.StreamHandler streamHandler, Http2Headers http2Headers) {
        return this.createStream(address, null, null, streamHandler, http2Headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<NettyStream> createStream(InetSocketAddress address, Integer sendBufferSize, Integer receiveBufferSize, NettyStream.StreamHandler streamHandler, Http2Headers http2Headers) {
        NettyHttp2Connection connection;
        this.connectionMapLock.readLock().lock();
        try {
            connection = this.connections.get(address);
        }
        finally {
            this.connectionMapLock.readLock().unlock();
        }
        CompletableFuture<NettyHttp2Connection> conFuture = connection == null ? this.createConnection(address, sendBufferSize, receiveBufferSize) : CompletableFuture.completedFuture(connection);
        CompletableFuture<NettyStream> futureToReturn = new CompletableFuture<NettyStream>();
        conFuture.whenComplete((BiConsumer)Utils.exceptionSafe(futureToReturn, (nettyConnection, throwable) -> {
            NettyHttp2Connection conn = nettyConnection;
            this.connectionMapLock.writeLock().lock();
            try {
                if (this.connections.containsKey(address)) {
                    conn = this.connections.get(address);
                    if (conn != nettyConnection) {
                        nettyConnection.close();
                    }
                } else {
                    if (throwable != null) {
                        this.log.error("Unable to create connection to endpoint {}", (Object)address, throwable);
                        futureToReturn.completeExceptionally((Throwable)throwable);
                        return;
                    }
                    this.connections.put(address, (NettyHttp2Connection)nettyConnection);
                }
            }
            finally {
                this.connectionMapLock.writeLock().unlock();
            }
            Future<NettyHttp2Stream> streamFuture = conn.createStream(http2Headers, streamHandler);
            streamFuture.addListener(Utils.exceptionSafe(futureToReturn, listener -> {
                if (listener.isSuccess()) {
                    futureToReturn.complete((NettyStream)streamFuture.get());
                } else {
                    this.log.error("Unable to create connection to endpoint {}", (Object)address, (Object)listener.cause());
                    futureToReturn.completeExceptionally(listener.cause());
                }
            }));
        }));
        return futureToReturn;
    }

    CompletableFuture<NettyHttp2Connection> createConnection(InetSocketAddress endPoint, Integer sendBufferSize, Integer receiveBufferSize) {
        Bootstrap b = new Bootstrap();
        b.group(this.eventLoopGroup);
        b.channel(Utils.channelTypeForEventLoop(this.eventLoopGroup));
        b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        if (sendBufferSize != null) {
            b.option(ChannelOption.SO_SNDBUF, (Object)sendBufferSize);
        }
        if (receiveBufferSize != null) {
            b.option(ChannelOption.SO_RCVBUF, (Object)receiveBufferSize);
        }
        NettyHttp2ConnectionInitializer channelHandler = new NettyHttp2ConnectionInitializer(ConnectionMode.CLIENT, this.trackedChannels, this.sslContext, this.http2Settings, (ChannelHandler)new SimpleChannelInboundHandler<Http2Frame>(){

            protected void channelRead0(ChannelHandlerContext ctx, Http2Frame msg) {
                NettyClient.this.log.warn("This should never happen. Received unexpected frame: {}", (Object)msg);
            }
        }, this.logContext, this.connectionWindowSize);
        b.handler((ChannelHandler)channelHandler);
        CompletableFuture<Void> firstSettingsFrameReceived = channelHandler.firstSettingsFrameReceived();
        CompletableFuture<NettyHttp2Connection> connectionFuture = new CompletableFuture<NettyHttp2Connection>();
        ChannelFuture connectFuture = b.connect(endPoint.getHostName(), endPoint.getPort());
        connectFuture.addListener(Utils.exceptionSafe(connectionFuture, future -> {
            if (future.isSuccess()) {
                Channel channel = connectFuture.channel();
                firstSettingsFrameReceived.whenComplete((BiConsumer)Utils.exceptionSafe(connectionFuture, (settings, throwable) -> {
                    if (throwable != null) {
                        this.log.error("Failed to create a new connection to endpoint {}", (Object)endPoint, throwable);
                        connectionFuture.completeExceptionally((Throwable)throwable);
                        return;
                    }
                    NettyHttp2Connection newConnection = new NettyHttp2Connection(channel, this.trackedChannels, this.logContext, this.flowControlEnabled);
                    this.log.info("Connected to http2 server [{}] on channel {}", (Object)endPoint, (Object)channel);
                    connectionFuture.complete(newConnection);
                }));
            } else {
                this.log.error("Failed to create a new connection to endpoint {}", (Object)endPoint);
                connectionFuture.completeExceptionally(future.cause());
            }
        }));
        return connectionFuture;
    }
}

