/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.SslClientAuth;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.PlaintextChannelBuilder;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.network.SaslChannelBuilder;
import org.apache.kafka.common.network.SslChannelBuilder;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.security.kerberos.KerberosShortNamer;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelBuilders {
    private static final Logger log = LoggerFactory.getLogger(ChannelBuilders.class);

    private ChannelBuilders() {
    }

    public static ChannelBuilder clientChannelBuilder(SecurityProtocol securityProtocol, JaasContext.Type contextType, AbstractConfig config, ListenerName listenerName, String clientSaslMechanism, Time time, LogContext logContext) {
        return ChannelBuilders.clientChannelBuilder(securityProtocol, contextType, config, listenerName, clientSaslMechanism, time, logContext, null);
    }

    public static ChannelBuilder clientChannelBuilder(SecurityProtocol securityProtocol, JaasContext.Type contextType, AbstractConfig config, ListenerName listenerName, String clientSaslMechanism, Time time, LogContext logContext, RequestCallback requestCallback) {
        return ChannelBuilders.clientChannelBuilder(securityProtocol, contextType, config, listenerName, clientSaslMechanism, time, logContext, requestCallback, null);
    }

    public static ChannelBuilder clientChannelBuilder(SecurityProtocol securityProtocol, JaasContext.Type contextType, AbstractConfig config, ListenerName listenerName, String clientSaslMechanism, Time time, LogContext logContext, RequestCallback requestCallback, ProxyProtocolEngineFactory proxyProtocolEngineFactory) {
        if (securityProtocol == SecurityProtocol.SASL_PLAINTEXT || securityProtocol == SecurityProtocol.SASL_SSL) {
            if (contextType == null) {
                throw new IllegalArgumentException("`contextType` must be non-null if `securityProtocol` is `" + String.valueOf((Object)securityProtocol) + "`");
            }
            if (clientSaslMechanism == null) {
                throw new IllegalArgumentException("`clientSaslMechanism` must be non-null in client mode if `securityProtocol` is `" + String.valueOf((Object)securityProtocol) + "`");
            }
        }
        return ChannelBuilders.create(securityProtocol, ConnectionMode.CLIENT, contextType, config, listenerName, false, clientSaslMechanism, null, null, time, logContext, null, requestCallback, proxyProtocolEngineFactory, null);
    }

    public static ChannelBuilder serverChannelBuilder(ListenerName listenerName, boolean isInterBrokerListener, SecurityProtocol securityProtocol, AbstractConfig config, CredentialCache credentialCache, DelegationTokenCache tokenCache, Time time, LogContext logContext, Function<Short, ApiVersionsResponse> apiVersionSupplier, RequestCallback requestCallbackManager, Metrics metrics) {
        return ChannelBuilders.serverChannelBuilder(listenerName, isInterBrokerListener, securityProtocol, config, credentialCache, tokenCache, time, logContext, apiVersionSupplier, requestCallbackManager, null, metrics);
    }

    public static ChannelBuilder serverChannelBuilder(ListenerName listenerName, boolean isInterBrokerListener, SecurityProtocol securityProtocol, AbstractConfig config, CredentialCache credentialCache, DelegationTokenCache tokenCache, Time time, LogContext logContext, Function<Short, ApiVersionsResponse> apiVersionSupplier, RequestCallback requestCallbackManager) {
        return ChannelBuilders.serverChannelBuilder(listenerName, isInterBrokerListener, securityProtocol, config, credentialCache, tokenCache, time, logContext, apiVersionSupplier, requestCallbackManager, null, null);
    }

    public static ChannelBuilder serverChannelBuilder(ListenerName listenerName, boolean isInterBrokerListener, SecurityProtocol securityProtocol, AbstractConfig config, CredentialCache credentialCache, DelegationTokenCache tokenCache, Time time, LogContext logContext, Function<Short, ApiVersionsResponse> apiVersionSupplier, RequestCallback requestCallbackManager, ProxyProtocolEngineFactory proxyProtocolEngineFactory) {
        return ChannelBuilders.create(securityProtocol, ConnectionMode.SERVER, JaasContext.Type.SERVER, config, listenerName, isInterBrokerListener, null, credentialCache, tokenCache, time, logContext, apiVersionSupplier, requestCallbackManager, proxyProtocolEngineFactory, null);
    }

    public static ChannelBuilder serverChannelBuilder(ListenerName listenerName, boolean isInterBrokerListener, SecurityProtocol securityProtocol, AbstractConfig config, CredentialCache credentialCache, DelegationTokenCache tokenCache, Time time, LogContext logContext, Function<Short, ApiVersionsResponse> apiVersionSupplier, RequestCallback requestCallbackManager, ProxyProtocolEngineFactory proxyProtocolEngineFactory, Metrics metrics) {
        return ChannelBuilders.create(securityProtocol, ConnectionMode.SERVER, JaasContext.Type.SERVER, config, listenerName, isInterBrokerListener, null, credentialCache, tokenCache, time, logContext, apiVersionSupplier, requestCallbackManager, proxyProtocolEngineFactory, metrics);
    }

    private static ChannelBuilder create(SecurityProtocol securityProtocol, ConnectionMode connectionMode, JaasContext.Type contextType, AbstractConfig config, ListenerName listenerName, boolean isInterBrokerListener, String clientSaslMechanism, CredentialCache credentialCache, DelegationTokenCache tokenCache, Time time, LogContext logContext, Function<Short, ApiVersionsResponse> apiVersionSupplier, RequestCallback requestCallbackManager, ProxyProtocolEngineFactory proxyProtocolEngineFactory, Metrics metrics) {
        ChannelBuilder channelBuilder;
        Map<String, Object> configs = ChannelBuilders.channelBuilderConfigs(config, listenerName);
        if (proxyProtocolEngineFactory == null) {
            proxyProtocolEngineFactory = ChannelBuilders.proxyProtocolEngineFactory(connectionMode, config, configs, logContext);
        }
        if (connectionMode == ConnectionMode.CLIENT) {
            configs.remove("confluent.multitenant.parse.sni.host.name.enable");
            configs.remove("confluent.multitenant.parse.lkc.id.enable");
            configs.remove("confluent.subdomain.prefix");
            configs.remove("confluent.proxy.mode.local.default");
            configs.remove("confluent.ppv2.endpoint.scheme.enable");
            configs.remove("confluent.valid.sni.hostnames");
            configs.remove("confluent.emit.proxy.protocol.metrics");
            configs.remove("confluent.reject.invalid.sni.hostnames");
        }
        switch (securityProtocol) {
            case SSL: {
                ChannelBuilders.requireNonNullMode(connectionMode, securityProtocol);
                channelBuilder = new SslChannelBuilder(connectionMode, listenerName, isInterBrokerListener, logContext, proxyProtocolEngineFactory, metrics);
                break;
            }
            case SASL_SSL: 
            case SASL_PLAINTEXT: {
                Map<Object, Object> jaasContexts;
                ChannelBuilders.requireNonNullMode(connectionMode, securityProtocol);
                String sslClientAuthOverride = null;
                if (connectionMode == ConnectionMode.SERVER) {
                    List enabledMechanisms = (List)configs.get("sasl.enabled.mechanisms");
                    jaasContexts = new HashMap(enabledMechanisms.size());
                    for (String mechanism : enabledMechanisms) {
                        jaasContexts.put(mechanism, JaasContext.loadServerContext(listenerName, mechanism, configs));
                    }
                    if (listenerName != null && securityProtocol == SecurityProtocol.SASL_SSL) {
                        String configuredClientAuth = (String)configs.get("ssl.client.auth");
                        String listenerClientAuth = (String)config.originalsWithPrefix(listenerName.configPrefix(), true).get("ssl.client.auth");
                        if (listenerClientAuth == null) {
                            sslClientAuthOverride = SslClientAuth.NONE.name().toLowerCase(Locale.ROOT);
                            if (configuredClientAuth != null && !configuredClientAuth.equalsIgnoreCase(SslClientAuth.NONE.name())) {
                                log.warn("Broker configuration '{}' is applied only to SSL listeners. Listener-prefixed configuration can be used to enable SSL client authentication for SASL_SSL listeners. In future releases, broker-wide option without listener prefix may be applied to SASL_SSL listeners as well. All configuration options intended for specific listeners should be listener-prefixed.", (Object)"ssl.client.auth");
                            }
                        }
                    }
                } else {
                    JaasContext jaasContext = contextType == JaasContext.Type.CLIENT ? JaasContext.loadClientContext(configs) : JaasContext.loadServerContext(listenerName, clientSaslMechanism, configs);
                    jaasContexts = Collections.singletonMap(clientSaslMechanism, jaasContext);
                }
                channelBuilder = new SaslChannelBuilder(connectionMode, jaasContexts, securityProtocol, listenerName, isInterBrokerListener, clientSaslMechanism, credentialCache, tokenCache, sslClientAuthOverride, time, logContext, apiVersionSupplier, requestCallbackManager, proxyProtocolEngineFactory);
                break;
            }
            case PLAINTEXT: {
                channelBuilder = new PlaintextChannelBuilder(connectionMode, listenerName, proxyProtocolEngineFactory);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected securityProtocol " + String.valueOf((Object)securityProtocol));
            }
        }
        channelBuilder.configure(configs);
        return channelBuilder;
    }

    public static Map<String, Object> channelBuilderConfigs(AbstractConfig config, ListenerName listenerName) {
        Map<String, Object> parsedConfigs = listenerName == null ? config.values() : config.valuesWithPrefixOverride(listenerName.configPrefix());
        config.originals().entrySet().stream().filter(e -> !parsedConfigs.containsKey(e.getKey())).filter(e -> listenerName == null || !((String)e.getKey()).startsWith(listenerName.configPrefix()) || !parsedConfigs.containsKey(((String)e.getKey()).substring(listenerName.configPrefix().length()))).filter(e -> listenerName == null || !parsedConfigs.containsKey(((String)e.getKey()).substring(((String)e.getKey()).indexOf(46) + 1))).forEach(e -> parsedConfigs.put((String)e.getKey(), e.getValue()));
        return parsedConfigs;
    }

    private static void requireNonNullMode(ConnectionMode connectionMode, SecurityProtocol securityProtocol) {
        if (connectionMode == null) {
            throw new IllegalArgumentException("`mode` must be non-null if `securityProtocol` is `" + String.valueOf((Object)securityProtocol) + "`");
        }
    }

    public static KafkaPrincipalBuilder createPrincipalBuilder(Map<String, ?> configs, KerberosShortNamer kerberosShortNamer, SslPrincipalMapper sslPrincipalMapper) {
        KafkaPrincipalBuilder builder;
        Class principalBuilderClass = (Class)configs.get("principal.builder.class");
        if (principalBuilderClass == null || principalBuilderClass == DefaultKafkaPrincipalBuilder.class) {
            builder = new DefaultKafkaPrincipalBuilder(kerberosShortNamer, sslPrincipalMapper);
        } else if (KafkaPrincipalBuilder.class.isAssignableFrom(principalBuilderClass)) {
            builder = (KafkaPrincipalBuilder)Utils.newInstance(principalBuilderClass);
        } else {
            throw new InvalidConfigurationException("Type " + principalBuilderClass.getName() + " is not an instance of " + KafkaPrincipalBuilder.class.getName());
        }
        if (builder instanceof Configurable) {
            ((Configurable)((Object)builder)).configure(configs);
        }
        return builder;
    }

    private static ProxyProtocolEngineFactory proxyProtocolEngineFactory(ConnectionMode connectionMode, AbstractConfig config, Map<String, Object> parsedConfigs, LogContext logContext) {
        ProxyProtocol proxyProtocol;
        if (connectionMode == ConnectionMode.SERVER) {
            proxyProtocol = ProxyProtocol.forName((String)parsedConfigs.getOrDefault("confluent.proxy.protocol.version", config.getString("confluent.proxy.protocol.version")));
        } else {
            String defaultValue = config.values().containsKey("confluent.proxy.protocol.client.version") ? config.getString("confluent.proxy.protocol.client.version") : ConfluentConfigs.PROXY_PROTOCOL_CLIENT_VERSION_DEFAULT;
            proxyProtocol = ProxyProtocol.forName((String)parsedConfigs.getOrDefault("confluent.proxy.protocol.client.version", defaultValue));
        }
        return new ProxyProtocolEngineFactory(proxyProtocol, parsedConfigs, connectionMode, logContext);
    }
}

