/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class ShareFetchRequestData
implements ApiMessage {
    String groupId;
    String memberId;
    int shareSessionEpoch;
    int maxWaitMs;
    int minBytes;
    int maxBytes;
    int maxRecords;
    int batchSize;
    FetchTopicCollection topics;
    List<ForgottenTopic> forgottenTopicsData;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_1 = new Schema(new Field("group_id", Type.COMPACT_NULLABLE_STRING, "The group identifier."), new Field("member_id", Type.COMPACT_NULLABLE_STRING, "The member ID."), new Field("share_session_epoch", Type.INT32, "The current share session epoch: 0 to open a share session; -1 to close it; otherwise increments for consecutive requests."), new Field("max_wait_ms", Type.INT32, "The maximum time in milliseconds to wait for the response."), new Field("min_bytes", Type.INT32, "The minimum bytes to accumulate in the response."), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch. See KIP-74 for cases where this limit may not be honored."), new Field("max_records", Type.INT32, "The maximum number of records to fetch. This limit can be exceeded for alignment of batch boundaries."), new Field("batch_size", Type.INT32, "The optimal number of records for batches of acquired records and acknowledgements."), new Field("topics", new CompactArrayOf(FetchTopic.SCHEMA_1), "The topics to fetch."), new Field("forgotten_topics_data", new CompactArrayOf(ForgottenTopic.SCHEMA_1), "The partitions to remove from this share session."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 1;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public ShareFetchRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ShareFetchRequestData() {
        this.groupId = null;
        this.memberId = "";
        this.shareSessionEpoch = 0;
        this.maxWaitMs = 0;
        this.minBytes = 0;
        this.maxBytes = Integer.MAX_VALUE;
        this.maxRecords = 0;
        this.batchSize = 0;
        this.topics = new FetchTopicCollection(0);
        this.forgottenTopicsData = new ArrayList<ForgottenTopic>(0);
    }

    @Override
    public short apiKey() {
        return 78;
    }

    @Override
    public short lowestSupportedVersion() {
        return 1;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.groupId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field groupId had invalid length " + length);
            }
            this.groupId = _context.read(EntityType.GROUP_ID, _readable.readString(length));
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.memberId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field memberId had invalid length " + length);
            }
            this.memberId = _readable.readString(length);
        }
        this.shareSessionEpoch = _readable.readInt();
        this.maxWaitMs = _readable.readInt();
        this.minBytes = _readable.readInt();
        this.maxBytes = _readable.readInt();
        this.maxRecords = _readable.readInt();
        this.batchSize = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        AbstractCollection newCollection = new FetchTopicCollection(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            ((ImplicitLinkedHashCollection)newCollection).add(new FetchTopic(_readable, _version, _context));
        }
        this.topics = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field forgottenTopicsData was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            ((ArrayList)newCollection).add(new ForgottenTopic(_readable, _version, _context));
        }
        this.forgottenTopicsData = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (this.groupId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.groupId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.memberId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.memberId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeInt(this.shareSessionEpoch);
        _writable.writeInt(this.maxWaitMs);
        _writable.writeInt(this.minBytes);
        _writable.writeInt(this.maxBytes);
        _writable.writeInt(this.maxRecords);
        _writable.writeInt(this.batchSize);
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        _stringBytes = this.topics.iterator();
        while (_stringBytes.hasNext()) {
            FetchTopic topicsElement = (FetchTopic)_stringBytes.next();
            topicsElement.write(_writable, _cache, _version, _context);
        }
        _writable.writeUnsignedVarint(this.forgottenTopicsData.size() + 1);
        for (ForgottenTopic forgottenTopicsDataElement : this.forgottenTopicsData) {
            forgottenTopicsDataElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        if (this.groupId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = _context.write(EntityType.GROUP_ID, this.groupId).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'groupId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.groupId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (this.memberId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'memberId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.memberId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        for (FetchTopic topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version, _context);
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.forgottenTopicsData.size() + 1));
        for (ForgottenTopic forgottenTopicsDataElement : this.forgottenTopicsData) {
            forgottenTopicsDataElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShareFetchRequestData)) {
            return false;
        }
        ShareFetchRequestData other = (ShareFetchRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        if (this.shareSessionEpoch != other.shareSessionEpoch) {
            return false;
        }
        if (this.maxWaitMs != other.maxWaitMs) {
            return false;
        }
        if (this.minBytes != other.minBytes) {
            return false;
        }
        if (this.maxBytes != other.maxBytes) {
            return false;
        }
        if (this.maxRecords != other.maxRecords) {
            return false;
        }
        if (this.batchSize != other.batchSize) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.forgottenTopicsData == null ? other.forgottenTopicsData != null : !this.forgottenTopicsData.equals(other.forgottenTopicsData)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        hashCode = 31 * hashCode + this.shareSessionEpoch;
        hashCode = 31 * hashCode + this.maxWaitMs;
        hashCode = 31 * hashCode + this.minBytes;
        hashCode = 31 * hashCode + this.maxBytes;
        hashCode = 31 * hashCode + this.maxRecords;
        hashCode = 31 * hashCode + this.batchSize;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + (this.forgottenTopicsData == null ? 0 : this.forgottenTopicsData.hashCode());
        return hashCode;
    }

    @Override
    public ShareFetchRequestData duplicate() {
        ShareFetchRequestData _duplicate = new ShareFetchRequestData();
        _duplicate.groupId = this.groupId == null ? null : this.groupId;
        _duplicate.memberId = this.memberId == null ? null : this.memberId;
        _duplicate.shareSessionEpoch = this.shareSessionEpoch;
        _duplicate.maxWaitMs = this.maxWaitMs;
        _duplicate.minBytes = this.minBytes;
        _duplicate.maxBytes = this.maxBytes;
        _duplicate.maxRecords = this.maxRecords;
        _duplicate.batchSize = this.batchSize;
        FetchTopicCollection newTopics = new FetchTopicCollection(this.topics.size());
        for (FetchTopic _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        ArrayList<ForgottenTopic> newForgottenTopicsData = new ArrayList<ForgottenTopic>(this.forgottenTopicsData.size());
        for (ForgottenTopic _element : this.forgottenTopicsData) {
            newForgottenTopicsData.add(_element.duplicate());
        }
        _duplicate.forgottenTopicsData = newForgottenTopicsData;
        return _duplicate;
    }

    public String toString() {
        return "ShareFetchRequestData(groupId=" + (String)(this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", memberId=" + (String)(this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", shareSessionEpoch=" + this.shareSessionEpoch + ", maxWaitMs=" + this.maxWaitMs + ", minBytes=" + this.minBytes + ", maxBytes=" + this.maxBytes + ", maxRecords=" + this.maxRecords + ", batchSize=" + this.batchSize + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", forgottenTopicsData=" + MessageUtil.deepToString(this.forgottenTopicsData.iterator()) + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public String memberId() {
        return this.memberId;
    }

    public int shareSessionEpoch() {
        return this.shareSessionEpoch;
    }

    public int maxWaitMs() {
        return this.maxWaitMs;
    }

    public int minBytes() {
        return this.minBytes;
    }

    public int maxBytes() {
        return this.maxBytes;
    }

    public int maxRecords() {
        return this.maxRecords;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public FetchTopicCollection topics() {
        return this.topics;
    }

    public List<ForgottenTopic> forgottenTopicsData() {
        return this.forgottenTopicsData;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ShareFetchRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public ShareFetchRequestData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    public ShareFetchRequestData setShareSessionEpoch(int v) {
        this.shareSessionEpoch = v;
        return this;
    }

    public ShareFetchRequestData setMaxWaitMs(int v) {
        this.maxWaitMs = v;
        return this;
    }

    public ShareFetchRequestData setMinBytes(int v) {
        this.minBytes = v;
        return this;
    }

    public ShareFetchRequestData setMaxBytes(int v) {
        this.maxBytes = v;
        return this;
    }

    public ShareFetchRequestData setMaxRecords(int v) {
        this.maxRecords = v;
        return this;
    }

    public ShareFetchRequestData setBatchSize(int v) {
        this.batchSize = v;
        return this;
    }

    public ShareFetchRequestData setTopics(FetchTopicCollection v) {
        this.topics = v;
        return this;
    }

    public ShareFetchRequestData setForgottenTopicsData(List<ForgottenTopic> v) {
        this.forgottenTopicsData = v;
        return this;
    }

    public static class FetchTopicCollection
    extends ImplicitLinkedHashMultiCollection<FetchTopic> {
        public FetchTopicCollection() {
        }

        public FetchTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public FetchTopicCollection(Iterator<FetchTopic> iterator) {
            super(iterator);
        }

        @Override
        public FetchTopic find(Uuid topicId) {
            FetchTopic _key = new FetchTopic();
            _key.setTopicId(topicId);
            return this.find(_key);
        }

        @Override
        public List<FetchTopic> findAll(Uuid topicId) {
            FetchTopic _key = new FetchTopic();
            _key.setTopicId(topicId);
            return this.findAll(_key);
        }

        public FetchTopicCollection duplicate() {
            FetchTopicCollection _duplicate = new FetchTopicCollection(this.size());
            for (FetchTopic _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class FetchTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        Uuid topicId;
        FetchPartitionCollection partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_1 = new Schema(new Field("topic_id", Type.UUID, "The unique topic ID."), new Field("partitions", new CompactArrayOf(FetchPartition.SCHEMA_1), "The partitions to fetch."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public FetchTopic(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public FetchTopic() {
            this.topicId = Uuid.ZERO_UUID;
            this.partitions = new FetchPartitionCollection(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 1;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version < 1 || _version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of FetchTopic");
            }
            this.topicId = _readable.readUuid();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            FetchPartitionCollection newCollection = new FetchPartitionCollection(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new FetchPartition(_readable, _version, _context));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeUuid(this.topicId);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            for (FetchPartition partitionsElement : this.partitions) {
                partitionsElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version < 1 || _version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of FetchTopic");
            }
            _size.addBytes(16);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (FetchPartition partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof FetchTopic)) {
                return false;
            }
            FetchTopic other = (FetchTopic)obj;
            return this.topicId.equals(other.topicId);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FetchTopic)) {
                return false;
            }
            FetchTopic other = (FetchTopic)obj;
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicId.hashCode();
            return hashCode;
        }

        @Override
        public FetchTopic duplicate() {
            FetchTopic _duplicate = new FetchTopic();
            _duplicate.topicId = this.topicId;
            FetchPartitionCollection newPartitions = new FetchPartitionCollection(this.partitions.size());
            for (FetchPartition _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "FetchTopic(topicId=" + this.topicId.toString() + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public FetchPartitionCollection partitions() {
            return this.partitions;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public FetchTopic setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public FetchTopic setPartitions(FetchPartitionCollection v) {
            this.partitions = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class ForgottenTopic
    implements Message {
        Uuid topicId;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1 = new Schema(new Field("topic_id", Type.UUID, "The unique topic ID."), new Field("partitions", new CompactArrayOf(Type.INT32), "The partitions indexes to forget."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public ForgottenTopic(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ForgottenTopic() {
            this.topicId = Uuid.ZERO_UUID;
            this.partitions = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 1;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version < 1 || _version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ForgottenTopic");
            }
            this.topicId = _readable.readUuid();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeUuid(this.topicId);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            for (Integer partitionsElement : this.partitions) {
                _writable.writeInt(partitionsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version < 1 || _version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ForgottenTopic");
            }
            _size.addBytes(16);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ForgottenTopic)) {
                return false;
            }
            ForgottenTopic other = (ForgottenTopic)obj;
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public ForgottenTopic duplicate() {
            ForgottenTopic _duplicate = new ForgottenTopic();
            _duplicate.topicId = this.topicId;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "ForgottenTopic(topicId=" + this.topicId.toString() + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ForgottenTopic setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public ForgottenTopic setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }
    }

    public static class FetchPartitionCollection
    extends ImplicitLinkedHashMultiCollection<FetchPartition> {
        public FetchPartitionCollection() {
        }

        public FetchPartitionCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public FetchPartitionCollection(Iterator<FetchPartition> iterator) {
            super(iterator);
        }

        @Override
        public FetchPartition find(int partitionIndex) {
            FetchPartition _key = new FetchPartition();
            _key.setPartitionIndex(partitionIndex);
            return this.find(_key);
        }

        @Override
        public List<FetchPartition> findAll(int partitionIndex) {
            FetchPartition _key = new FetchPartition();
            _key.setPartitionIndex(partitionIndex);
            return this.findAll(_key);
        }

        public FetchPartitionCollection duplicate() {
            FetchPartitionCollection _duplicate = new FetchPartitionCollection(this.size());
            for (FetchPartition _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class AcknowledgementBatch
    implements Message {
        long firstOffset;
        long lastOffset;
        List<Byte> acknowledgeTypes;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1 = new Schema(new Field("first_offset", Type.INT64, "First offset of batch of records to acknowledge."), new Field("last_offset", Type.INT64, "Last offset (inclusive) of batch of records to acknowledge."), new Field("acknowledge_types", new CompactArrayOf(Type.INT8), "Array of acknowledge types - 0:Gap,1:Accept,2:Release,3:Reject."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public AcknowledgementBatch(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public AcknowledgementBatch() {
            this.firstOffset = 0L;
            this.lastOffset = 0L;
            this.acknowledgeTypes = new ArrayList<Byte>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 1;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version < 1 || _version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AcknowledgementBatch");
            }
            this.firstOffset = _readable.readLong();
            this.lastOffset = _readable.readLong();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field acknowledgeTypes was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Byte> newCollection = new ArrayList<Byte>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readByte());
            }
            this.acknowledgeTypes = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeLong(this.firstOffset);
            _writable.writeLong(this.lastOffset);
            _writable.writeUnsignedVarint(this.acknowledgeTypes.size() + 1);
            for (Byte acknowledgeTypesElement : this.acknowledgeTypes) {
                _writable.writeByte(acknowledgeTypesElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version < 1 || _version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AcknowledgementBatch");
            }
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.acknowledgeTypes.size() + 1));
            _size.addBytes(this.acknowledgeTypes.size() * 1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AcknowledgementBatch)) {
                return false;
            }
            AcknowledgementBatch other = (AcknowledgementBatch)obj;
            if (this.firstOffset != other.firstOffset) {
                return false;
            }
            if (this.lastOffset != other.lastOffset) {
                return false;
            }
            if (this.acknowledgeTypes == null ? other.acknowledgeTypes != null : !this.acknowledgeTypes.equals(other.acknowledgeTypes)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + ((int)(this.firstOffset >> 32) ^ (int)this.firstOffset);
            hashCode = 31 * hashCode + ((int)(this.lastOffset >> 32) ^ (int)this.lastOffset);
            hashCode = 31 * hashCode + (this.acknowledgeTypes == null ? 0 : this.acknowledgeTypes.hashCode());
            return hashCode;
        }

        @Override
        public AcknowledgementBatch duplicate() {
            AcknowledgementBatch _duplicate = new AcknowledgementBatch();
            _duplicate.firstOffset = this.firstOffset;
            _duplicate.lastOffset = this.lastOffset;
            ArrayList<Byte> newAcknowledgeTypes = new ArrayList<Byte>(this.acknowledgeTypes.size());
            for (Byte _element : this.acknowledgeTypes) {
                newAcknowledgeTypes.add(_element);
            }
            _duplicate.acknowledgeTypes = newAcknowledgeTypes;
            return _duplicate;
        }

        public String toString() {
            return "AcknowledgementBatch(firstOffset=" + this.firstOffset + ", lastOffset=" + this.lastOffset + ", acknowledgeTypes=" + MessageUtil.deepToString(this.acknowledgeTypes.iterator()) + ")";
        }

        public long firstOffset() {
            return this.firstOffset;
        }

        public long lastOffset() {
            return this.lastOffset;
        }

        public List<Byte> acknowledgeTypes() {
            return this.acknowledgeTypes;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AcknowledgementBatch setFirstOffset(long v) {
            this.firstOffset = v;
            return this;
        }

        public AcknowledgementBatch setLastOffset(long v) {
            this.lastOffset = v;
            return this;
        }

        public AcknowledgementBatch setAcknowledgeTypes(List<Byte> v) {
            this.acknowledgeTypes = v;
            return this;
        }
    }

    public static class FetchPartition
    implements Message,
    ImplicitLinkedHashCollection.Element {
        int partitionIndex;
        int partitionMaxBytes;
        List<AcknowledgementBatch> acknowledgementBatches;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_1 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("acknowledgement_batches", new CompactArrayOf(AcknowledgementBatch.SCHEMA_1), "Record batches to acknowledge."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public FetchPartition(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public FetchPartition() {
            this.partitionIndex = 0;
            this.partitionMaxBytes = 0;
            this.acknowledgementBatches = new ArrayList<AcknowledgementBatch>(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 1;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version < 1 || _version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of FetchPartition");
            }
            this.partitionIndex = _readable.readInt();
            this.partitionMaxBytes = 0;
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field acknowledgementBatches was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<AcknowledgementBatch> newCollection = new ArrayList<AcknowledgementBatch>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new AcknowledgementBatch(_readable, _version, _context));
            }
            this.acknowledgementBatches = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            if (this.partitionMaxBytes != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default partitionMaxBytes at version " + _version);
            }
            _writable.writeUnsignedVarint(this.acknowledgementBatches.size() + 1);
            for (AcknowledgementBatch acknowledgementBatchesElement : this.acknowledgementBatches) {
                acknowledgementBatchesElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version < 1 || _version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of FetchPartition");
            }
            _size.addBytes(4);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.acknowledgementBatches.size() + 1));
            for (AcknowledgementBatch acknowledgementBatchesElement : this.acknowledgementBatches) {
                acknowledgementBatchesElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof FetchPartition)) {
                return false;
            }
            FetchPartition other = (FetchPartition)obj;
            return this.partitionIndex == other.partitionIndex;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FetchPartition)) {
                return false;
            }
            FetchPartition other = (FetchPartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.partitionMaxBytes != other.partitionMaxBytes) {
                return false;
            }
            if (this.acknowledgementBatches == null ? other.acknowledgementBatches != null : !this.acknowledgementBatches.equals(other.acknowledgementBatches)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            return hashCode;
        }

        @Override
        public FetchPartition duplicate() {
            FetchPartition _duplicate = new FetchPartition();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.partitionMaxBytes = this.partitionMaxBytes;
            ArrayList<AcknowledgementBatch> newAcknowledgementBatches = new ArrayList<AcknowledgementBatch>(this.acknowledgementBatches.size());
            for (AcknowledgementBatch _element : this.acknowledgementBatches) {
                newAcknowledgementBatches.add(_element.duplicate());
            }
            _duplicate.acknowledgementBatches = newAcknowledgementBatches;
            return _duplicate;
        }

        public String toString() {
            return "FetchPartition(partitionIndex=" + this.partitionIndex + ", partitionMaxBytes=" + this.partitionMaxBytes + ", acknowledgementBatches=" + MessageUtil.deepToString(this.acknowledgementBatches.iterator()) + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int partitionMaxBytes() {
            return this.partitionMaxBytes;
        }

        public List<AcknowledgementBatch> acknowledgementBatches() {
            return this.acknowledgementBatches;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public FetchPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public FetchPartition setPartitionMaxBytes(int v) {
            this.partitionMaxBytes = v;
            return this;
        }

        public FetchPartition setAcknowledgementBatches(List<AcknowledgementBatch> v) {
            this.acknowledgementBatches = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }
}

