/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeMirrorsRequestData
implements ApiMessage {
    List<String> topics;
    int timeoutMs;
    List<String> linkNames;
    List<String> states;
    boolean includeStateTransitionErrors;
    boolean describeRemoteMirrors;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema SCHEMA_9;
    public static final Schema SCHEMA_10;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 10;

    public DescribeMirrorsRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeMirrorsRequestData() {
        this.topics = new ArrayList<String>(0);
        this.timeoutMs = 0;
        this.linkNames = null;
        this.states = null;
        this.includeStateTransitionErrors = false;
        this.describeRemoteMirrors = false;
    }

    @Override
    public short apiKey() {
        return 10009;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 10;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int length;
        int i;
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topics element was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topics element had invalid length " + length);
            }
            newCollection.add(_context.read(EntityType.TOPIC_NAME, _readable.readString(length)));
        }
        this.topics = newCollection;
        this.timeoutMs = _readable.readInt();
        if (_version >= 5) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.linkNames = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    length = _readable.readUnsignedVarint() - 1;
                    if (length < 0) {
                        throw new RuntimeException("non-nullable field linkNames element was serialized as null");
                    }
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field linkNames element had invalid length " + length);
                    }
                    newCollection.add(_context.read(EntityType.LINK_NAME, _readable.readString(length)));
                }
                this.linkNames = newCollection;
            }
        } else {
            this.linkNames = null;
        }
        if (_version >= 5) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.states = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    length = _readable.readUnsignedVarint() - 1;
                    if (length < 0) {
                        throw new RuntimeException("non-nullable field states element was serialized as null");
                    }
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field states element had invalid length " + length);
                    }
                    newCollection.add(_readable.readString(length));
                }
                this.states = newCollection;
            }
        } else {
            this.states = null;
        }
        this.includeStateTransitionErrors = _version >= 6 ? _readable.readByte() != 0 : false;
        this.describeRemoteMirrors = _version >= 10 ? _readable.readByte() != 0 : false;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        for (String topicsElement : this.topics) {
            _stringBytes = _cache.getSerializedValue(topicsElement);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeInt(this.timeoutMs);
        if (_version >= 5) {
            if (this.linkNames == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.linkNames.size() + 1);
                for (String linkNamesElement : this.linkNames) {
                    _stringBytes = _cache.getSerializedValue(linkNamesElement);
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                    _writable.writeByteArray(_stringBytes);
                }
            }
        }
        if (_version >= 5) {
            if (this.states == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.states.size() + 1);
                for (String statesElement : this.states) {
                    _stringBytes = _cache.getSerializedValue(statesElement);
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                    _writable.writeByteArray(_stringBytes);
                }
            }
        }
        if (_version >= 6) {
            _writable.writeByte(this.includeStateTransitionErrors ? (byte)1 : 0);
        } else if (this.includeStateTransitionErrors) {
            throw new UnsupportedVersionException("Attempted to write a non-default includeStateTransitionErrors at version " + _version);
        }
        if (_version >= 10) {
            _writable.writeByte(this.describeRemoteMirrors ? (byte)1 : 0);
        } else if (this.describeRemoteMirrors) {
            throw new UnsupportedVersionException("Attempted to write a non-default describeRemoteMirrors at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        for (String topicsElement : this.topics) {
            _stringBytes = _context.write(EntityType.TOPIC_NAME, topicsElement).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicsElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(topicsElement, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(4);
        if (_version >= 5) {
            if (this.linkNames == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.linkNames.size() + 1));
                for (String linkNamesElement : this.linkNames) {
                    _stringBytes = _context.write(EntityType.LINK_NAME, linkNamesElement).getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'linkNamesElement' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(linkNamesElement, _stringBytes);
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                }
            }
        }
        if (_version >= 5) {
            if (this.states == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.states.size() + 1));
                for (String statesElement : this.states) {
                    _stringBytes = statesElement.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'statesElement' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(statesElement, _stringBytes);
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                }
            }
        }
        if (_version >= 6) {
            _size.addBytes(1);
        }
        if (_version >= 10) {
            _size.addBytes(1);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeMirrorsRequestData)) {
            return false;
        }
        DescribeMirrorsRequestData other = (DescribeMirrorsRequestData)obj;
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        if (this.linkNames == null ? other.linkNames != null : !this.linkNames.equals(other.linkNames)) {
            return false;
        }
        if (this.states == null ? other.states != null : !this.states.equals(other.states)) {
            return false;
        }
        if (this.includeStateTransitionErrors != other.includeStateTransitionErrors) {
            return false;
        }
        if (this.describeRemoteMirrors != other.describeRemoteMirrors) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.linkNames == null ? 0 : this.linkNames.hashCode());
        hashCode = 31 * hashCode + (this.states == null ? 0 : this.states.hashCode());
        hashCode = 31 * hashCode + (this.includeStateTransitionErrors ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.describeRemoteMirrors ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public DescribeMirrorsRequestData duplicate() {
        DescribeMirrorsRequestData _duplicate = new DescribeMirrorsRequestData();
        ArrayList<String> newTopics = new ArrayList<String>(this.topics.size());
        for (String _element : this.topics) {
            newTopics.add(_element);
        }
        _duplicate.topics = newTopics;
        _duplicate.timeoutMs = this.timeoutMs;
        if (this.linkNames == null) {
            _duplicate.linkNames = null;
        } else {
            ArrayList<String> newLinkNames = new ArrayList<String>(this.linkNames.size());
            for (String _element : this.linkNames) {
                newLinkNames.add(_element);
            }
            _duplicate.linkNames = newLinkNames;
        }
        if (this.states == null) {
            _duplicate.states = null;
        } else {
            ArrayList<String> newStates = new ArrayList<String>(this.states.size());
            for (String _element : this.states) {
                newStates.add(_element);
            }
            _duplicate.states = newStates;
        }
        _duplicate.includeStateTransitionErrors = this.includeStateTransitionErrors;
        _duplicate.describeRemoteMirrors = this.describeRemoteMirrors;
        return _duplicate;
    }

    public String toString() {
        return "DescribeMirrorsRequestData(topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", timeoutMs=" + this.timeoutMs + ", linkNames=" + (this.linkNames == null ? "null" : MessageUtil.deepToString(this.linkNames.iterator())) + ", states=" + (this.states == null ? "null" : MessageUtil.deepToString(this.states.iterator())) + ", includeStateTransitionErrors=" + (this.includeStateTransitionErrors ? "true" : "false") + ", describeRemoteMirrors=" + (this.describeRemoteMirrors ? "true" : "false") + ")";
    }

    public List<String> topics() {
        return this.topics;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public List<String> linkNames() {
        return this.linkNames;
    }

    public List<String> states() {
        return this.states;
    }

    public boolean includeStateTransitionErrors() {
        return this.includeStateTransitionErrors;
    }

    public boolean describeRemoteMirrors() {
        return this.describeRemoteMirrors;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeMirrorsRequestData setTopics(List<String> v) {
        this.topics = v;
        return this;
    }

    public DescribeMirrorsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public DescribeMirrorsRequestData setLinkNames(List<String> v) {
        this.linkNames = v;
        return this;
    }

    public DescribeMirrorsRequestData setStates(List<String> v) {
        this.states = v;
        return this;
    }

    public DescribeMirrorsRequestData setIncludeStateTransitionErrors(boolean v) {
        this.includeStateTransitionErrors = v;
        return this;
    }

    public DescribeMirrorsRequestData setDescribeRemoteMirrors(boolean v) {
        this.describeRemoteMirrors = v;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("topics", new CompactArrayOf(Type.COMPACT_STRING), "The name of the topics to include in the response."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0])))));
        SCHEMA_5 = new Schema(new Field("topics", new CompactArrayOf(Type.COMPACT_STRING), "The name of the topics to include in the response."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), new Field("link_names", CompactArrayOf.nullable(Type.COMPACT_STRING), "The links to filter by. If null, mirrors are not filtered by state."), new Field("states", CompactArrayOf.nullable(Type.COMPACT_STRING), "The mirror states to filter by. If null, mirrors are not filtered by state."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_9 = SCHEMA_8 = (SCHEMA_7 = (SCHEMA_6 = new Schema(new Field("topics", new CompactArrayOf(Type.COMPACT_STRING), "The name of the topics to include in the response."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), new Field("link_names", CompactArrayOf.nullable(Type.COMPACT_STRING), "The links to filter by. If null, mirrors are not filtered by state."), new Field("states", CompactArrayOf.nullable(Type.COMPACT_STRING), "The mirror states to filter by. If null, mirrors are not filtered by state."), new Field("include_state_transition_errors", Type.BOOLEAN, "Whether to include state transition errors in the response."), Field.TaggedFieldsSection.of(new Object[0]))));
        SCHEMA_10 = new Schema(new Field("topics", new CompactArrayOf(Type.COMPACT_STRING), "The name of the topics to include in the response."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), new Field("link_names", CompactArrayOf.nullable(Type.COMPACT_STRING), "The links to filter by. If null, mirrors are not filtered by state."), new Field("states", CompactArrayOf.nullable(Type.COMPACT_STRING), "The mirror states to filter by. If null, mirrors are not filtered by state."), new Field("include_state_transition_errors", Type.BOOLEAN, "Whether to include state transition errors in the response."), new Field("describe_remote_mirrors", Type.BOOLEAN, "Whether to include remote mirrors information in the response."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10};
    }
}

