/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeClusterLinksResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    List<EntryData> entries;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or `0` if the link description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the link listing succeeded."), new Field("entries", CompactArrayOf.nullable(EntryData.SCHEMA_0), "The cluster link listing results."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or `0` if the link description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the link listing succeeded."), new Field("entries", CompactArrayOf.nullable(EntryData.SCHEMA_1), "The cluster link listing results."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or `0` if the link description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the link listing succeeded."), new Field("entries", CompactArrayOf.nullable(EntryData.SCHEMA_2), "The cluster link listing results."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_3 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or `0` if the link description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the link listing succeeded."), new Field("entries", CompactArrayOf.nullable(EntryData.SCHEMA_3), "The cluster link listing results."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_4 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or `0` if the link description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the link listing succeeded."), new Field("entries", CompactArrayOf.nullable(EntryData.SCHEMA_4), "The cluster link listing results."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_5 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or `0` if the link description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the link listing succeeded."), new Field("entries", CompactArrayOf.nullable(EntryData.SCHEMA_5), "The cluster link listing results."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_6 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or `0` if the link description succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the link listing succeeded."), new Field("entries", CompactArrayOf.nullable(EntryData.SCHEMA_6), "The cluster link listing results."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 6;

    public DescribeClusterLinksResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeClusterLinksResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.entries = new ArrayList<EntryData>(0);
    }

    @Override
    public short apiKey() {
        return 10022;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 6;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
        }
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.entries = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<EntryData> newCollection = new ArrayList<EntryData>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new EntryData(_readable, _version, _context));
            }
            this.entries = newCollection;
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.entries == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.entries.size() + 1);
            _stringBytes = this.entries.iterator();
            while (_stringBytes.hasNext()) {
                EntryData entriesElement = (EntryData)_stringBytes.next();
                entriesElement.write(_writable, _cache, _version, _context);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (this.entries == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.entries.size() + 1));
            for (EntryData entriesElement : this.entries) {
                entriesElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeClusterLinksResponseData)) {
            return false;
        }
        DescribeClusterLinksResponseData other = (DescribeClusterLinksResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.entries == null ? other.entries != null : !this.entries.equals(other.entries)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.entries == null ? 0 : this.entries.hashCode());
        return hashCode;
    }

    @Override
    public DescribeClusterLinksResponseData duplicate() {
        DescribeClusterLinksResponseData _duplicate = new DescribeClusterLinksResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        if (this.entries == null) {
            _duplicate.entries = null;
        } else {
            ArrayList<EntryData> newEntries = new ArrayList<EntryData>(this.entries.size());
            for (EntryData _element : this.entries) {
                newEntries.add(_element.duplicate());
            }
            _duplicate.entries = newEntries;
        }
        return _duplicate;
    }

    public String toString() {
        return "DescribeClusterLinksResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", entries=" + (this.entries == null ? "null" : MessageUtil.deepToString(this.entries.iterator())) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<EntryData> entries() {
        return this.entries;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeClusterLinksResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeClusterLinksResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeClusterLinksResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeClusterLinksResponseData setEntries(List<EntryData> v) {
        this.entries = v;
        return this;
    }

    public static class EntryData
    implements Message {
        String linkName;
        Uuid linkId;
        String remoteClusterId;
        String localClusterId;
        List<String> topics;
        short linkMode;
        short connectionMode;
        short linkState;
        int linkCoordinatorId;
        String linkCoordinatorHost;
        int linkCoordinatorPort;
        short linkErrorCode;
        String linkErrorMessage;
        short remoteLinkState;
        short remoteLinkErrorCode;
        String remoteLinkErrorMessage;
        long remoteLinkStateTimeMs;
        int partitionId;
        List<TaskData> tasks;
        List<PartitionMirrorStateCategoryCount> partitionMirrorStateCategoryCounts;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("link_name", Type.COMPACT_STRING, "The name assigned to the cluster link."), new Field("link_id", Type.UUID, "The ID associated with the cluster link."), new Field("remote_cluster_id", Type.COMPACT_NULLABLE_STRING, "The remote cluster ID for the cluster link if known."), new Field("local_cluster_id", Type.COMPACT_STRING, "The local cluster ID for the cluster link."), new Field("topics", CompactArrayOf.nullable(Type.COMPACT_STRING), "The topics that are linked with the cluster link, otherwise if null, then the topics weren't requested."), new Field("link_mode", Type.INT16, "The cluster link mode."), new Field("connection_mode", Type.INT16, "The cluster link connection mode."), new Field("link_state", Type.INT16, "The cluster link state."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("link_name", Type.COMPACT_STRING, "The name assigned to the cluster link."), new Field("link_id", Type.UUID, "The ID associated with the cluster link."), new Field("remote_cluster_id", Type.COMPACT_NULLABLE_STRING, "The remote cluster ID for the cluster link if known."), new Field("local_cluster_id", Type.COMPACT_STRING, "The local cluster ID for the cluster link."), new Field("topics", CompactArrayOf.nullable(Type.COMPACT_STRING), "The topics that are linked with the cluster link, otherwise if null, then the topics weren't requested."), new Field("link_mode", Type.INT16, "The cluster link mode."), new Field("connection_mode", Type.INT16, "The cluster link connection mode."), new Field("link_state", Type.INT16, "The cluster link state."), new Field("link_coordinator_id", Type.INT32, "The broker id of the link coordinator."), new Field("link_coordinator_host", Type.COMPACT_NULLABLE_STRING, "The link coordinator host name."), new Field("link_coordinator_port", Type.INT32, "The link coordinator port."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_2 = new Schema(new Field("link_name", Type.COMPACT_STRING, "The name assigned to the cluster link."), new Field("link_id", Type.UUID, "The ID associated with the cluster link."), new Field("remote_cluster_id", Type.COMPACT_NULLABLE_STRING, "The remote cluster ID for the cluster link if known."), new Field("local_cluster_id", Type.COMPACT_STRING, "The local cluster ID for the cluster link."), new Field("topics", CompactArrayOf.nullable(Type.COMPACT_STRING), "The topics that are linked with the cluster link, otherwise if null, then the topics weren't requested."), new Field("link_mode", Type.INT16, "The cluster link mode."), new Field("connection_mode", Type.INT16, "The cluster link connection mode."), new Field("link_state", Type.INT16, "The cluster link state."), new Field("link_coordinator_id", Type.INT32, "The broker id of the link coordinator."), new Field("link_coordinator_host", Type.COMPACT_NULLABLE_STRING, "The link coordinator host name."), new Field("link_coordinator_port", Type.INT32, "The link coordinator port."), new Field("link_error_code", Type.INT16, "Link error code if it's in an error state, otherwise 0"), new Field("link_error_message", Type.COMPACT_NULLABLE_STRING, "Error message if link is in an error state, otherwise null"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_3 = new Schema(new Field("link_name", Type.COMPACT_STRING, "The name assigned to the cluster link."), new Field("link_id", Type.UUID, "The ID associated with the cluster link."), new Field("remote_cluster_id", Type.COMPACT_NULLABLE_STRING, "The remote cluster ID for the cluster link if known."), new Field("local_cluster_id", Type.COMPACT_STRING, "The local cluster ID for the cluster link."), new Field("topics", CompactArrayOf.nullable(Type.COMPACT_STRING), "The topics that are linked with the cluster link, otherwise if null, then the topics weren't requested."), new Field("link_mode", Type.INT16, "The cluster link mode."), new Field("connection_mode", Type.INT16, "The cluster link connection mode."), new Field("link_state", Type.INT16, "The cluster link state."), new Field("link_coordinator_id", Type.INT32, "The broker id of the link coordinator."), new Field("link_coordinator_host", Type.COMPACT_NULLABLE_STRING, "The link coordinator host name."), new Field("link_coordinator_port", Type.INT32, "The link coordinator port."), new Field("link_error_code", Type.INT16, "Link error code if it's in an error state, otherwise 0"), new Field("link_error_message", Type.COMPACT_NULLABLE_STRING, "Error message if link is in an error state, otherwise null"), new Field("remote_link_state", Type.INT16, "The state of the remote cluster link, if this is a source-initiated or bi-directional link."), new Field("remote_link_error_code", Type.INT16, "Error code for remote link if it is in an error state, otherwise 0"), new Field("remote_link_error_message", Type.COMPACT_NULLABLE_STRING, "Error message if remote link is in an error state, otherwise null"), new Field("remote_link_state_time_ms", Type.INT64, "The time, in milliseconds since epoch, when remote link state was last updated."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_4 = new Schema(new Field("link_name", Type.COMPACT_STRING, "The name assigned to the cluster link."), new Field("link_id", Type.UUID, "The ID associated with the cluster link."), new Field("remote_cluster_id", Type.COMPACT_NULLABLE_STRING, "The remote cluster ID for the cluster link if known."), new Field("local_cluster_id", Type.COMPACT_STRING, "The local cluster ID for the cluster link."), new Field("topics", CompactArrayOf.nullable(Type.COMPACT_STRING), "The topics that are linked with the cluster link, otherwise if null, then the topics weren't requested."), new Field("link_mode", Type.INT16, "The cluster link mode."), new Field("connection_mode", Type.INT16, "The cluster link connection mode."), new Field("link_state", Type.INT16, "The cluster link state."), new Field("link_coordinator_id", Type.INT32, "The broker id of the link coordinator."), new Field("link_coordinator_host", Type.COMPACT_NULLABLE_STRING, "The link coordinator host name."), new Field("link_coordinator_port", Type.INT32, "The link coordinator port."), new Field("link_error_code", Type.INT16, "Link error code if it's in an error state, otherwise 0"), new Field("link_error_message", Type.COMPACT_NULLABLE_STRING, "Error message if link is in an error state, otherwise null"), new Field("remote_link_state", Type.INT16, "The state of the remote cluster link, if this is a source-initiated or bi-directional link."), new Field("remote_link_error_code", Type.INT16, "Error code for remote link if it is in an error state, otherwise 0"), new Field("remote_link_error_message", Type.COMPACT_NULLABLE_STRING, "Error message if remote link is in an error state, otherwise null"), new Field("remote_link_state_time_ms", Type.INT64, "The time, in milliseconds since epoch, when remote link state was last updated."), new Field("tasks", CompactArrayOf.nullable(TaskData.SCHEMA_4), "Tasks information"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_5 = new Schema(new Field("link_name", Type.COMPACT_STRING, "The name assigned to the cluster link."), new Field("link_id", Type.UUID, "The ID associated with the cluster link."), new Field("remote_cluster_id", Type.COMPACT_NULLABLE_STRING, "The remote cluster ID for the cluster link if known."), new Field("local_cluster_id", Type.COMPACT_STRING, "The local cluster ID for the cluster link."), new Field("topics", CompactArrayOf.nullable(Type.COMPACT_STRING), "The topics that are linked with the cluster link, otherwise if null, then the topics weren't requested."), new Field("link_mode", Type.INT16, "The cluster link mode."), new Field("connection_mode", Type.INT16, "The cluster link connection mode."), new Field("link_state", Type.INT16, "The cluster link state."), new Field("link_coordinator_id", Type.INT32, "The broker id of the link coordinator."), new Field("link_coordinator_host", Type.COMPACT_NULLABLE_STRING, "The link coordinator host name."), new Field("link_coordinator_port", Type.INT32, "The link coordinator port."), new Field("link_error_code", Type.INT16, "Link error code if it's in an error state, otherwise 0"), new Field("link_error_message", Type.COMPACT_NULLABLE_STRING, "Error message if link is in an error state, otherwise null"), new Field("remote_link_state", Type.INT16, "The state of the remote cluster link, if this is a source-initiated or bi-directional link."), new Field("remote_link_error_code", Type.INT16, "Error code for remote link if it is in an error state, otherwise 0"), new Field("remote_link_error_message", Type.COMPACT_NULLABLE_STRING, "Error message if remote link is in an error state, otherwise null"), new Field("remote_link_state_time_ms", Type.INT64, "The time, in milliseconds since epoch, when remote link state was last updated."), new Field("partition_id", Type.INT32, "The partition id that owns the link."), new Field("tasks", CompactArrayOf.nullable(TaskData.SCHEMA_4), "Tasks information"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_6 = new Schema(new Field("link_name", Type.COMPACT_STRING, "The name assigned to the cluster link."), new Field("link_id", Type.UUID, "The ID associated with the cluster link."), new Field("remote_cluster_id", Type.COMPACT_NULLABLE_STRING, "The remote cluster ID for the cluster link if known."), new Field("local_cluster_id", Type.COMPACT_STRING, "The local cluster ID for the cluster link."), new Field("topics", CompactArrayOf.nullable(Type.COMPACT_STRING), "The topics that are linked with the cluster link, otherwise if null, then the topics weren't requested."), new Field("link_mode", Type.INT16, "The cluster link mode."), new Field("connection_mode", Type.INT16, "The cluster link connection mode."), new Field("link_state", Type.INT16, "The cluster link state."), new Field("link_coordinator_id", Type.INT32, "The broker id of the link coordinator."), new Field("link_coordinator_host", Type.COMPACT_NULLABLE_STRING, "The link coordinator host name."), new Field("link_coordinator_port", Type.INT32, "The link coordinator port."), new Field("link_error_code", Type.INT16, "Link error code if it's in an error state, otherwise 0"), new Field("link_error_message", Type.COMPACT_NULLABLE_STRING, "Error message if link is in an error state, otherwise null"), new Field("remote_link_state", Type.INT16, "The state of the remote cluster link, if this is a source-initiated or bi-directional link."), new Field("remote_link_error_code", Type.INT16, "Error code for remote link if it is in an error state, otherwise 0"), new Field("remote_link_error_message", Type.COMPACT_NULLABLE_STRING, "Error message if remote link is in an error state, otherwise null"), new Field("remote_link_state_time_ms", Type.INT64, "The time, in milliseconds since epoch, when remote link state was last updated."), new Field("partition_id", Type.INT32, "The partition id that owns the link."), new Field("tasks", CompactArrayOf.nullable(TaskData.SCHEMA_4), "Tasks information"), new Field("partition_mirror_state_category_counts", CompactArrayOf.nullable(PartitionMirrorStateCategoryCount.SCHEMA_6), "Mirror State Category Counts"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 6;

        public EntryData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public EntryData() {
            this.linkName = "";
            this.linkId = Uuid.ZERO_UUID;
            this.remoteClusterId = "";
            this.localClusterId = "";
            this.topics = null;
            this.linkMode = 0;
            this.connectionMode = 0;
            this.linkState = 0;
            this.linkCoordinatorId = -1;
            this.linkCoordinatorHost = "";
            this.linkCoordinatorPort = -1;
            this.linkErrorCode = 0;
            this.linkErrorMessage = null;
            this.remoteLinkState = (short)-1;
            this.remoteLinkErrorCode = 0;
            this.remoteLinkErrorMessage = null;
            this.remoteLinkStateTimeMs = -1L;
            this.partitionId = -1;
            this.tasks = new ArrayList<TaskData>(0);
            this.partitionMirrorStateCategoryCounts = new ArrayList<PartitionMirrorStateCategoryCount>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            ArrayList<String> newCollection;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntryData");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field linkName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field linkName had invalid length " + length);
            }
            this.linkName = _context.read(EntityType.LINK_NAME, _readable.readString(length));
            this.linkId = _readable.readUuid();
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.remoteClusterId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field remoteClusterId had invalid length " + length);
                }
                this.remoteClusterId = _readable.readString(length);
            }
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field localClusterId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field localClusterId had invalid length " + length);
            }
            this.localClusterId = _context.read(EntityType.CLUSTER_ID, _readable.readString(length));
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.topics = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<String>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    int length2 = _readable.readUnsignedVarint() - 1;
                    if (length2 < 0) {
                        throw new RuntimeException("non-nullable field topics element was serialized as null");
                    }
                    if (length2 > Short.MAX_VALUE) {
                        throw new RuntimeException("string field topics element had invalid length " + length2);
                    }
                    newCollection.add(_context.read(EntityType.TOPIC_NAME, _readable.readString(length2)));
                }
                this.topics = newCollection;
            }
            this.linkMode = _readable.readShort();
            this.connectionMode = _readable.readShort();
            this.linkState = _readable.readShort();
            this.linkCoordinatorId = _version >= 1 ? _readable.readInt() : -1;
            if (_version >= 1) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    this.linkCoordinatorHost = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field linkCoordinatorHost had invalid length " + length);
                    }
                    this.linkCoordinatorHost = _readable.readString(length);
                }
            } else {
                this.linkCoordinatorHost = "";
            }
            this.linkCoordinatorPort = _version >= 1 ? _readable.readInt() : -1;
            this.linkErrorCode = _version >= 2 ? _readable.readShort() : (short)0;
            if (_version >= 2) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    this.linkErrorMessage = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field linkErrorMessage had invalid length " + length);
                    }
                    this.linkErrorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
                }
            } else {
                this.linkErrorMessage = null;
            }
            this.remoteLinkState = _version >= 3 ? _readable.readShort() : (short)-1;
            this.remoteLinkErrorCode = _version >= 3 ? _readable.readShort() : (short)0;
            if (_version >= 3) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    this.remoteLinkErrorMessage = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field remoteLinkErrorMessage had invalid length " + length);
                    }
                    this.remoteLinkErrorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
                }
            } else {
                this.remoteLinkErrorMessage = null;
            }
            this.remoteLinkStateTimeMs = _version >= 3 ? _readable.readLong() : -1L;
            this.partitionId = _version >= 5 ? _readable.readInt() : -1;
            if (_version >= 4) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.tasks = null;
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add((String)((Object)new TaskData(_readable, _version, _context)));
                    }
                    this.tasks = newCollection;
                }
            } else {
                this.tasks = new ArrayList<TaskData>(0);
            }
            if (_version >= 6) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.partitionMirrorStateCategoryCounts = null;
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add((String)((Object)new PartitionMirrorStateCategoryCount(_readable, _version, _context)));
                    }
                    this.partitionMirrorStateCategoryCounts = newCollection;
                }
            } else {
                this.partitionMirrorStateCategoryCounts = new ArrayList<PartitionMirrorStateCategoryCount>(0);
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.linkName);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUuid(this.linkId);
            if (this.remoteClusterId == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.remoteClusterId);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            _stringBytes = _cache.getSerializedValue(this.localClusterId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            if (this.topics == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.topics.size() + 1);
                _stringBytes = this.topics.iterator();
                while (_stringBytes.hasNext()) {
                    String topicsElement = (String)_stringBytes.next();
                    byte[] _stringBytes2 = _cache.getSerializedValue(topicsElement);
                    _writable.writeUnsignedVarint(_stringBytes2.length + 1);
                    _writable.writeByteArray(_stringBytes2);
                }
            }
            _writable.writeShort(this.linkMode);
            _writable.writeShort(this.connectionMode);
            _writable.writeShort(this.linkState);
            if (_version >= 1) {
                _writable.writeInt(this.linkCoordinatorId);
            }
            if (_version >= 1) {
                if (this.linkCoordinatorHost == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _stringBytes = _cache.getSerializedValue(this.linkCoordinatorHost);
                    _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                    _writable.writeByteArray((byte[])_stringBytes);
                }
            }
            if (_version >= 1) {
                _writable.writeInt(this.linkCoordinatorPort);
            }
            if (_version >= 2) {
                _writable.writeShort(this.linkErrorCode);
            }
            if (_version >= 2) {
                if (this.linkErrorMessage == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _stringBytes = _cache.getSerializedValue(this.linkErrorMessage);
                    _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                    _writable.writeByteArray((byte[])_stringBytes);
                }
            }
            if (_version >= 3) {
                _writable.writeShort(this.remoteLinkState);
            }
            if (_version >= 3) {
                _writable.writeShort(this.remoteLinkErrorCode);
            }
            if (_version >= 3) {
                if (this.remoteLinkErrorMessage == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _stringBytes = _cache.getSerializedValue(this.remoteLinkErrorMessage);
                    _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                    _writable.writeByteArray((byte[])_stringBytes);
                }
            }
            if (_version >= 3) {
                _writable.writeLong(this.remoteLinkStateTimeMs);
            }
            if (_version >= 5) {
                _writable.writeInt(this.partitionId);
            }
            if (_version >= 4) {
                if (this.tasks == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.tasks.size() + 1);
                    _stringBytes = this.tasks.iterator();
                    while (_stringBytes.hasNext()) {
                        TaskData tasksElement = (TaskData)_stringBytes.next();
                        tasksElement.write(_writable, _cache, _version, _context);
                    }
                }
            }
            if (_version >= 6) {
                if (this.partitionMirrorStateCategoryCounts == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.partitionMirrorStateCategoryCounts.size() + 1);
                    for (PartitionMirrorStateCategoryCount partitionMirrorStateCategoryCountsElement : this.partitionMirrorStateCategoryCounts) {
                        partitionMirrorStateCategoryCountsElement.write(_writable, _cache, _version, _context);
                    }
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of EntryData");
            }
            Object _stringBytes = _context.write(EntityType.LINK_NAME, this.linkName).getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'linkName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.linkName, (byte[])_stringBytes);
            _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
            _size.addBytes(16);
            if (this.remoteClusterId == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = this.remoteClusterId.getBytes(StandardCharsets.UTF_8);
                if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                    throw new RuntimeException("'remoteClusterId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.remoteClusterId, (byte[])_stringBytes);
                _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
            }
            _stringBytes = _context.write(EntityType.CLUSTER_ID, this.localClusterId).getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'localClusterId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.localClusterId, (byte[])_stringBytes);
            _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
            if (this.topics == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
                _stringBytes = this.topics.iterator();
                while (_stringBytes.hasNext()) {
                    String topicsElement = (String)_stringBytes.next();
                    byte[] _stringBytes2 = _context.write(EntityType.TOPIC_NAME, topicsElement).getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes2.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'topicsElement' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(topicsElement, _stringBytes2);
                    _size.addBytes(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes2.length + 1));
                }
            }
            _size.addBytes(2);
            _size.addBytes(2);
            _size.addBytes(2);
            if (_version >= 1) {
                _size.addBytes(4);
            }
            if (_version >= 1) {
                if (this.linkCoordinatorHost == null) {
                    _size.addBytes(1);
                } else {
                    _stringBytes = this.linkCoordinatorHost.getBytes(StandardCharsets.UTF_8);
                    if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                        throw new RuntimeException("'linkCoordinatorHost' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(this.linkCoordinatorHost, (byte[])_stringBytes);
                    _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
                }
            }
            if (_version >= 1) {
                _size.addBytes(4);
            }
            if (_version >= 2) {
                _size.addBytes(2);
            }
            if (_version >= 2) {
                if (this.linkErrorMessage == null) {
                    _size.addBytes(1);
                } else {
                    _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.linkErrorMessage).getBytes(StandardCharsets.UTF_8);
                    if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                        throw new RuntimeException("'linkErrorMessage' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(this.linkErrorMessage, (byte[])_stringBytes);
                    _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
                }
            }
            if (_version >= 3) {
                _size.addBytes(2);
            }
            if (_version >= 3) {
                _size.addBytes(2);
            }
            if (_version >= 3) {
                if (this.remoteLinkErrorMessage == null) {
                    _size.addBytes(1);
                } else {
                    _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.remoteLinkErrorMessage).getBytes(StandardCharsets.UTF_8);
                    if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                        throw new RuntimeException("'remoteLinkErrorMessage' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(this.remoteLinkErrorMessage, (byte[])_stringBytes);
                    _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
                }
            }
            if (_version >= 3) {
                _size.addBytes(8);
            }
            if (_version >= 5) {
                _size.addBytes(4);
            }
            if (_version >= 4) {
                if (this.tasks == null) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.tasks.size() + 1));
                    for (TaskData tasksElement : this.tasks) {
                        tasksElement.addSize(_size, _cache, _version, _context);
                    }
                }
            }
            if (_version >= 6) {
                if (this.partitionMirrorStateCategoryCounts == null) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitionMirrorStateCategoryCounts.size() + 1));
                    for (PartitionMirrorStateCategoryCount partitionMirrorStateCategoryCountsElement : this.partitionMirrorStateCategoryCounts) {
                        partitionMirrorStateCategoryCountsElement.addSize(_size, _cache, _version, _context);
                    }
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntryData)) {
                return false;
            }
            EntryData other = (EntryData)obj;
            if (this.linkName == null ? other.linkName != null : !this.linkName.equals(other.linkName)) {
                return false;
            }
            if (!this.linkId.equals(other.linkId)) {
                return false;
            }
            if (this.remoteClusterId == null ? other.remoteClusterId != null : !this.remoteClusterId.equals(other.remoteClusterId)) {
                return false;
            }
            if (this.localClusterId == null ? other.localClusterId != null : !this.localClusterId.equals(other.localClusterId)) {
                return false;
            }
            if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
                return false;
            }
            if (this.linkMode != other.linkMode) {
                return false;
            }
            if (this.connectionMode != other.connectionMode) {
                return false;
            }
            if (this.linkState != other.linkState) {
                return false;
            }
            if (this.linkCoordinatorId != other.linkCoordinatorId) {
                return false;
            }
            if (this.linkCoordinatorHost == null ? other.linkCoordinatorHost != null : !this.linkCoordinatorHost.equals(other.linkCoordinatorHost)) {
                return false;
            }
            if (this.linkCoordinatorPort != other.linkCoordinatorPort) {
                return false;
            }
            if (this.linkErrorCode != other.linkErrorCode) {
                return false;
            }
            if (this.linkErrorMessage == null ? other.linkErrorMessage != null : !this.linkErrorMessage.equals(other.linkErrorMessage)) {
                return false;
            }
            if (this.remoteLinkState != other.remoteLinkState) {
                return false;
            }
            if (this.remoteLinkErrorCode != other.remoteLinkErrorCode) {
                return false;
            }
            if (this.remoteLinkErrorMessage == null ? other.remoteLinkErrorMessage != null : !this.remoteLinkErrorMessage.equals(other.remoteLinkErrorMessage)) {
                return false;
            }
            if (this.remoteLinkStateTimeMs != other.remoteLinkStateTimeMs) {
                return false;
            }
            if (this.partitionId != other.partitionId) {
                return false;
            }
            if (this.tasks == null ? other.tasks != null : !this.tasks.equals(other.tasks)) {
                return false;
            }
            if (this.partitionMirrorStateCategoryCounts == null ? other.partitionMirrorStateCategoryCounts != null : !this.partitionMirrorStateCategoryCounts.equals(other.partitionMirrorStateCategoryCounts)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.linkName == null ? 0 : this.linkName.hashCode());
            hashCode = 31 * hashCode + this.linkId.hashCode();
            hashCode = 31 * hashCode + (this.remoteClusterId == null ? 0 : this.remoteClusterId.hashCode());
            hashCode = 31 * hashCode + (this.localClusterId == null ? 0 : this.localClusterId.hashCode());
            hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
            hashCode = 31 * hashCode + this.linkMode;
            hashCode = 31 * hashCode + this.connectionMode;
            hashCode = 31 * hashCode + this.linkState;
            hashCode = 31 * hashCode + this.linkCoordinatorId;
            hashCode = 31 * hashCode + (this.linkCoordinatorHost == null ? 0 : this.linkCoordinatorHost.hashCode());
            hashCode = 31 * hashCode + this.linkCoordinatorPort;
            hashCode = 31 * hashCode + this.linkErrorCode;
            hashCode = 31 * hashCode + (this.linkErrorMessage == null ? 0 : this.linkErrorMessage.hashCode());
            hashCode = 31 * hashCode + this.remoteLinkState;
            hashCode = 31 * hashCode + this.remoteLinkErrorCode;
            hashCode = 31 * hashCode + (this.remoteLinkErrorMessage == null ? 0 : this.remoteLinkErrorMessage.hashCode());
            hashCode = 31 * hashCode + ((int)(this.remoteLinkStateTimeMs >> 32) ^ (int)this.remoteLinkStateTimeMs);
            hashCode = 31 * hashCode + this.partitionId;
            hashCode = 31 * hashCode + (this.tasks == null ? 0 : this.tasks.hashCode());
            hashCode = 31 * hashCode + (this.partitionMirrorStateCategoryCounts == null ? 0 : this.partitionMirrorStateCategoryCounts.hashCode());
            return hashCode;
        }

        @Override
        public EntryData duplicate() {
            EntryData _duplicate = new EntryData();
            _duplicate.linkName = this.linkName;
            _duplicate.linkId = this.linkId;
            _duplicate.remoteClusterId = this.remoteClusterId == null ? null : this.remoteClusterId;
            _duplicate.localClusterId = this.localClusterId;
            if (this.topics == null) {
                _duplicate.topics = null;
            } else {
                ArrayList<String> newTopics = new ArrayList<String>(this.topics.size());
                for (String string : this.topics) {
                    newTopics.add(string);
                }
                _duplicate.topics = newTopics;
            }
            _duplicate.linkMode = this.linkMode;
            _duplicate.connectionMode = this.connectionMode;
            _duplicate.linkState = this.linkState;
            _duplicate.linkCoordinatorId = this.linkCoordinatorId;
            _duplicate.linkCoordinatorHost = this.linkCoordinatorHost == null ? null : this.linkCoordinatorHost;
            _duplicate.linkCoordinatorPort = this.linkCoordinatorPort;
            _duplicate.linkErrorCode = this.linkErrorCode;
            _duplicate.linkErrorMessage = this.linkErrorMessage == null ? null : this.linkErrorMessage;
            _duplicate.remoteLinkState = this.remoteLinkState;
            _duplicate.remoteLinkErrorCode = this.remoteLinkErrorCode;
            _duplicate.remoteLinkErrorMessage = this.remoteLinkErrorMessage == null ? null : this.remoteLinkErrorMessage;
            _duplicate.remoteLinkStateTimeMs = this.remoteLinkStateTimeMs;
            _duplicate.partitionId = this.partitionId;
            if (this.tasks == null) {
                _duplicate.tasks = null;
            } else {
                ArrayList<TaskData> newTasks = new ArrayList<TaskData>(this.tasks.size());
                for (TaskData taskData : this.tasks) {
                    newTasks.add(taskData.duplicate());
                }
                _duplicate.tasks = newTasks;
            }
            if (this.partitionMirrorStateCategoryCounts == null) {
                _duplicate.partitionMirrorStateCategoryCounts = null;
            } else {
                ArrayList<PartitionMirrorStateCategoryCount> newPartitionMirrorStateCategoryCounts = new ArrayList<PartitionMirrorStateCategoryCount>(this.partitionMirrorStateCategoryCounts.size());
                for (PartitionMirrorStateCategoryCount partitionMirrorStateCategoryCount : this.partitionMirrorStateCategoryCounts) {
                    newPartitionMirrorStateCategoryCounts.add(partitionMirrorStateCategoryCount.duplicate());
                }
                _duplicate.partitionMirrorStateCategoryCounts = newPartitionMirrorStateCategoryCounts;
            }
            return _duplicate;
        }

        public String toString() {
            return "EntryData(linkName=" + (String)(this.linkName == null ? "null" : "'" + this.linkName.toString() + "'") + ", linkId=" + this.linkId.toString() + ", remoteClusterId=" + (String)(this.remoteClusterId == null ? "null" : "'" + this.remoteClusterId.toString() + "'") + ", localClusterId=" + (String)(this.localClusterId == null ? "null" : "'" + this.localClusterId.toString() + "'") + ", topics=" + (this.topics == null ? "null" : MessageUtil.deepToString(this.topics.iterator())) + ", linkMode=" + this.linkMode + ", connectionMode=" + this.connectionMode + ", linkState=" + this.linkState + ", linkCoordinatorId=" + this.linkCoordinatorId + ", linkCoordinatorHost=" + (String)(this.linkCoordinatorHost == null ? "null" : "'" + this.linkCoordinatorHost.toString() + "'") + ", linkCoordinatorPort=" + this.linkCoordinatorPort + ", linkErrorCode=" + this.linkErrorCode + ", linkErrorMessage=" + (String)(this.linkErrorMessage == null ? "null" : "'" + this.linkErrorMessage.toString() + "'") + ", remoteLinkState=" + this.remoteLinkState + ", remoteLinkErrorCode=" + this.remoteLinkErrorCode + ", remoteLinkErrorMessage=" + (String)(this.remoteLinkErrorMessage == null ? "null" : "'" + this.remoteLinkErrorMessage.toString() + "'") + ", remoteLinkStateTimeMs=" + this.remoteLinkStateTimeMs + ", partitionId=" + this.partitionId + ", tasks=" + (this.tasks == null ? "null" : MessageUtil.deepToString(this.tasks.iterator())) + ", partitionMirrorStateCategoryCounts=" + (this.partitionMirrorStateCategoryCounts == null ? "null" : MessageUtil.deepToString(this.partitionMirrorStateCategoryCounts.iterator())) + ")";
        }

        public String linkName() {
            return this.linkName;
        }

        public Uuid linkId() {
            return this.linkId;
        }

        public String remoteClusterId() {
            return this.remoteClusterId;
        }

        public String localClusterId() {
            return this.localClusterId;
        }

        public List<String> topics() {
            return this.topics;
        }

        public short linkMode() {
            return this.linkMode;
        }

        public short connectionMode() {
            return this.connectionMode;
        }

        public short linkState() {
            return this.linkState;
        }

        public int linkCoordinatorId() {
            return this.linkCoordinatorId;
        }

        public String linkCoordinatorHost() {
            return this.linkCoordinatorHost;
        }

        public int linkCoordinatorPort() {
            return this.linkCoordinatorPort;
        }

        public short linkErrorCode() {
            return this.linkErrorCode;
        }

        public String linkErrorMessage() {
            return this.linkErrorMessage;
        }

        public short remoteLinkState() {
            return this.remoteLinkState;
        }

        public short remoteLinkErrorCode() {
            return this.remoteLinkErrorCode;
        }

        public String remoteLinkErrorMessage() {
            return this.remoteLinkErrorMessage;
        }

        public long remoteLinkStateTimeMs() {
            return this.remoteLinkStateTimeMs;
        }

        public int partitionId() {
            return this.partitionId;
        }

        public List<TaskData> tasks() {
            return this.tasks;
        }

        public List<PartitionMirrorStateCategoryCount> partitionMirrorStateCategoryCounts() {
            return this.partitionMirrorStateCategoryCounts;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public EntryData setLinkName(String v) {
            this.linkName = v;
            return this;
        }

        public EntryData setLinkId(Uuid v) {
            this.linkId = v;
            return this;
        }

        public EntryData setRemoteClusterId(String v) {
            this.remoteClusterId = v;
            return this;
        }

        public EntryData setLocalClusterId(String v) {
            this.localClusterId = v;
            return this;
        }

        public EntryData setTopics(List<String> v) {
            this.topics = v;
            return this;
        }

        public EntryData setLinkMode(short v) {
            this.linkMode = v;
            return this;
        }

        public EntryData setConnectionMode(short v) {
            this.connectionMode = v;
            return this;
        }

        public EntryData setLinkState(short v) {
            this.linkState = v;
            return this;
        }

        public EntryData setLinkCoordinatorId(int v) {
            this.linkCoordinatorId = v;
            return this;
        }

        public EntryData setLinkCoordinatorHost(String v) {
            this.linkCoordinatorHost = v;
            return this;
        }

        public EntryData setLinkCoordinatorPort(int v) {
            this.linkCoordinatorPort = v;
            return this;
        }

        public EntryData setLinkErrorCode(short v) {
            this.linkErrorCode = v;
            return this;
        }

        public EntryData setLinkErrorMessage(String v) {
            this.linkErrorMessage = v;
            return this;
        }

        public EntryData setRemoteLinkState(short v) {
            this.remoteLinkState = v;
            return this;
        }

        public EntryData setRemoteLinkErrorCode(short v) {
            this.remoteLinkErrorCode = v;
            return this;
        }

        public EntryData setRemoteLinkErrorMessage(String v) {
            this.remoteLinkErrorMessage = v;
            return this;
        }

        public EntryData setRemoteLinkStateTimeMs(long v) {
            this.remoteLinkStateTimeMs = v;
            return this;
        }

        public EntryData setPartitionId(int v) {
            this.partitionId = v;
            return this;
        }

        public EntryData setTasks(List<TaskData> v) {
            this.tasks = v;
            return this;
        }

        public EntryData setPartitionMirrorStateCategoryCounts(List<PartitionMirrorStateCategoryCount> v) {
            this.partitionMirrorStateCategoryCounts = v;
            return this;
        }
    }

    public static class PartitionMirrorStateCategoryCount
    implements Message {
        String partitionMirrorStateCategory;
        int count;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_6 = new Schema(new Field("partition_mirror_state_category", Type.COMPACT_STRING, "The mirror state category."), new Field("count", Type.INT32, "Count for category."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, null, null, null, SCHEMA_6};
        public static final short LOWEST_SUPPORTED_VERSION = 6;
        public static final short HIGHEST_SUPPORTED_VERSION = 6;

        public PartitionMirrorStateCategoryCount(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public PartitionMirrorStateCategoryCount() {
            this.partitionMirrorStateCategory = "";
            this.count = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionMirrorStateCategoryCount");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field partitionMirrorStateCategory was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field partitionMirrorStateCategory had invalid length " + length);
            }
            this.partitionMirrorStateCategory = _readable.readString(length);
            this.count = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 6) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of PartitionMirrorStateCategoryCount");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.partitionMirrorStateCategory);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeInt(this.count);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionMirrorStateCategoryCount");
            }
            byte[] _stringBytes = this.partitionMirrorStateCategory.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'partitionMirrorStateCategory' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.partitionMirrorStateCategory, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionMirrorStateCategoryCount)) {
                return false;
            }
            PartitionMirrorStateCategoryCount other = (PartitionMirrorStateCategoryCount)obj;
            if (this.partitionMirrorStateCategory == null ? other.partitionMirrorStateCategory != null : !this.partitionMirrorStateCategory.equals(other.partitionMirrorStateCategory)) {
                return false;
            }
            if (this.count != other.count) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.partitionMirrorStateCategory == null ? 0 : this.partitionMirrorStateCategory.hashCode());
            hashCode = 31 * hashCode + this.count;
            return hashCode;
        }

        @Override
        public PartitionMirrorStateCategoryCount duplicate() {
            PartitionMirrorStateCategoryCount _duplicate = new PartitionMirrorStateCategoryCount();
            _duplicate.partitionMirrorStateCategory = this.partitionMirrorStateCategory;
            _duplicate.count = this.count;
            return _duplicate;
        }

        public String toString() {
            return "PartitionMirrorStateCategoryCount(partitionMirrorStateCategory=" + (String)(this.partitionMirrorStateCategory == null ? "null" : "'" + this.partitionMirrorStateCategory.toString() + "'") + ", count=" + this.count + ")";
        }

        public String partitionMirrorStateCategory() {
            return this.partitionMirrorStateCategory;
        }

        public int count() {
            return this.count;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionMirrorStateCategoryCount setPartitionMirrorStateCategory(String v) {
            this.partitionMirrorStateCategory = v;
            return this;
        }

        public PartitionMirrorStateCategoryCount setCount(int v) {
            this.count = v;
            return this;
        }
    }

    public static class TaskErrorData
    implements Message {
        short errorCode;
        String errorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 4;
        public static final short HIGHEST_SUPPORTED_VERSION = 6;

        public TaskErrorData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TaskErrorData() {
            this.errorCode = 0;
            this.errorMessage = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 4;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TaskErrorData");
            }
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                byte[] _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TaskErrorData");
            }
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskErrorData)) {
                return false;
            }
            TaskErrorData other = (TaskErrorData)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            return hashCode;
        }

        @Override
        public TaskErrorData duplicate() {
            TaskErrorData _duplicate = new TaskErrorData();
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            return _duplicate;
        }

        public String toString() {
            return "TaskErrorData(errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TaskErrorData setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public TaskErrorData setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        static {
            SCHEMA_6 = SCHEMA_5 = (SCHEMA_4 = new Schema(new Field("error_code", Type.INT16, "The error code, or `0` if the task is not in an error state."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the task is not in an error state."), Field.TaggedFieldsSection.of(new Object[0])));
            SCHEMAS = new Schema[]{null, null, null, null, SCHEMA_4, SCHEMA_5, SCHEMA_6};
        }
    }

    public static class TaskData
    implements Message {
        String name;
        short state;
        List<TaskErrorData> errors;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 4;
        public static final short HIGHEST_SUPPORTED_VERSION = 6;

        public TaskData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TaskData() {
            this.name = "";
            this.state = 0;
            this.errors = new ArrayList<TaskErrorData>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TaskData");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.state = _readable.readShort();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.errors = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<TaskErrorData> newCollection = new ArrayList<TaskErrorData>(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    newCollection.add(new TaskErrorData(_readable, _version, _context));
                }
                this.errors = newCollection;
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 4) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TaskData");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeShort(this.state);
            if (this.errors == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.errors.size() + 1);
                _stringBytes = this.errors.iterator();
                while (_stringBytes.hasNext()) {
                    TaskErrorData errorsElement = (TaskErrorData)_stringBytes.next();
                    errorsElement.write(_writable, _cache, _version, _context);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TaskData");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(2);
            if (this.errors == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.errors.size() + 1));
                for (TaskErrorData errorsElement : this.errors) {
                    errorsElement.addSize(_size, _cache, _version, _context);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskData)) {
                return false;
            }
            TaskData other = (TaskData)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.state != other.state) {
                return false;
            }
            if (this.errors == null ? other.errors != null : !this.errors.equals(other.errors)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.state;
            hashCode = 31 * hashCode + (this.errors == null ? 0 : this.errors.hashCode());
            return hashCode;
        }

        @Override
        public TaskData duplicate() {
            TaskData _duplicate = new TaskData();
            _duplicate.name = this.name;
            _duplicate.state = this.state;
            if (this.errors == null) {
                _duplicate.errors = null;
            } else {
                ArrayList<TaskErrorData> newErrors = new ArrayList<TaskErrorData>(this.errors.size());
                for (TaskErrorData _element : this.errors) {
                    newErrors.add(_element.duplicate());
                }
                _duplicate.errors = newErrors;
            }
            return _duplicate;
        }

        public String toString() {
            return "TaskData(name=" + (String)(this.name == null ? "null" : "'" + this.name.toString() + "'") + ", state=" + this.state + ", errors=" + (this.errors == null ? "null" : MessageUtil.deepToString(this.errors.iterator())) + ")";
        }

        public String name() {
            return this.name;
        }

        public short state() {
            return this.state;
        }

        public List<TaskErrorData> errors() {
            return this.errors;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TaskData setName(String v) {
            this.name = v;
            return this;
        }

        public TaskData setState(short v) {
            this.state = v;
            return this;
        }

        public TaskData setErrors(List<TaskErrorData> v) {
            this.errors = v;
            return this;
        }

        static {
            SCHEMA_6 = SCHEMA_5 = (SCHEMA_4 = new Schema(new Field("name", Type.COMPACT_STRING, "The task name."), new Field("state", Type.INT16, "The task state."), new Field("errors", CompactArrayOf.nullable(TaskErrorData.SCHEMA_4), "The task error data."), Field.TaggedFieldsSection.of(new Object[0])));
            SCHEMAS = new Schema[]{null, null, null, null, SCHEMA_4, SCHEMA_5, SCHEMA_6};
        }
    }
}

