/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeBrokerHealthResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    List<DegradedBroker> degradedBrokers;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), new Field("degraded_brokers", new CompactArrayOf(DegradedBroker.SCHEMA_0), "The list of brokers with degraded health and their respective reasons."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), new Field("degraded_brokers", new CompactArrayOf(DegradedBroker.SCHEMA_1), "The list of brokers with degraded health and their respective reasons."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public DescribeBrokerHealthResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeBrokerHealthResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.degradedBrokers = new ArrayList<DegradedBroker>(0);
    }

    @Override
    public short apiKey() {
        return 10020;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
        }
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field degradedBrokers was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<DegradedBroker> newCollection = new ArrayList<DegradedBroker>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new DegradedBroker(_readable, _version, _context));
        }
        this.degradedBrokers = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeUnsignedVarint(this.degradedBrokers.size() + 1);
        _stringBytes = this.degradedBrokers.iterator();
        while (_stringBytes.hasNext()) {
            DegradedBroker degradedBrokersElement = (DegradedBroker)_stringBytes.next();
            degradedBrokersElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.degradedBrokers.size() + 1));
        for (DegradedBroker degradedBrokersElement : this.degradedBrokers) {
            degradedBrokersElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeBrokerHealthResponseData)) {
            return false;
        }
        DescribeBrokerHealthResponseData other = (DescribeBrokerHealthResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.degradedBrokers == null ? other.degradedBrokers != null : !this.degradedBrokers.equals(other.degradedBrokers)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.degradedBrokers == null ? 0 : this.degradedBrokers.hashCode());
        return hashCode;
    }

    @Override
    public DescribeBrokerHealthResponseData duplicate() {
        DescribeBrokerHealthResponseData _duplicate = new DescribeBrokerHealthResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        ArrayList<DegradedBroker> newDegradedBrokers = new ArrayList<DegradedBroker>(this.degradedBrokers.size());
        for (DegradedBroker _element : this.degradedBrokers) {
            newDegradedBrokers.add(_element.duplicate());
        }
        _duplicate.degradedBrokers = newDegradedBrokers;
        return _duplicate;
    }

    public String toString() {
        return "DescribeBrokerHealthResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", degradedBrokers=" + MessageUtil.deepToString(this.degradedBrokers.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<DegradedBroker> degradedBrokers() {
        return this.degradedBrokers;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeBrokerHealthResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeBrokerHealthResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeBrokerHealthResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeBrokerHealthResponseData setDegradedBrokers(List<DegradedBroker> v) {
        this.degradedBrokers = v;
        return this;
    }

    public static class DegradedBroker
    implements Message {
        int brokerId;
        List<Reason> deprecatedReasonsV0;
        List<DegradedBrokerComponent> degradedBrokerComponents;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The unique id of the broker."), new Field("deprecated_reasons_v0", new CompactArrayOf(Reason.SCHEMA_0), "A list of reasons that the broker is demoted."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("broker_id", Type.INT32, "The unique id of the broker."), new Field("degraded_broker_components", new CompactArrayOf(DegradedBrokerComponent.SCHEMA_1), "An array representing all the current health status changes applied to this broker."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public DegradedBroker(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public DegradedBroker() {
            this.brokerId = 0;
            this.deprecatedReasonsV0 = new ArrayList<Reason>(0);
            this.degradedBrokerComponents = new ArrayList<DegradedBrokerComponent>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            ArrayList<Reason> newCollection;
            int arrayLength;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DegradedBroker");
            }
            this.brokerId = _readable.readInt();
            if (_version <= 0) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field deprecatedReasonsV0 was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<Reason>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new Reason(_readable, _version, _context));
                }
                this.deprecatedReasonsV0 = newCollection;
            } else {
                this.deprecatedReasonsV0 = new ArrayList<Reason>(0);
            }
            if (_version >= 1) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field degradedBrokerComponents was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((Reason)((Object)new DegradedBrokerComponent(_readable, _version, _context)));
                }
                this.degradedBrokerComponents = newCollection;
            } else {
                this.degradedBrokerComponents = new ArrayList<DegradedBrokerComponent>(0);
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            if (_version <= 0) {
                _writable.writeUnsignedVarint(this.deprecatedReasonsV0.size() + 1);
                for (Reason deprecatedReasonsV0Element : this.deprecatedReasonsV0) {
                    deprecatedReasonsV0Element.write(_writable, _cache, _version, _context);
                }
            } else if (!this.deprecatedReasonsV0.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default deprecatedReasonsV0 at version " + _version);
            }
            if (_version >= 1) {
                _writable.writeUnsignedVarint(this.degradedBrokerComponents.size() + 1);
                for (DegradedBrokerComponent degradedBrokerComponentsElement : this.degradedBrokerComponents) {
                    degradedBrokerComponentsElement.write(_writable, _cache, _version, _context);
                }
            } else if (!this.degradedBrokerComponents.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default degradedBrokerComponents at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DegradedBroker");
            }
            _size.addBytes(4);
            if (_version <= 0) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.deprecatedReasonsV0.size() + 1));
                for (Reason deprecatedReasonsV0Element : this.deprecatedReasonsV0) {
                    deprecatedReasonsV0Element.addSize(_size, _cache, _version, _context);
                }
            }
            if (_version >= 1) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.degradedBrokerComponents.size() + 1));
                for (DegradedBrokerComponent degradedBrokerComponentsElement : this.degradedBrokerComponents) {
                    degradedBrokerComponentsElement.addSize(_size, _cache, _version, _context);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DegradedBroker)) {
                return false;
            }
            DegradedBroker other = (DegradedBroker)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            if (this.deprecatedReasonsV0 == null ? other.deprecatedReasonsV0 != null : !this.deprecatedReasonsV0.equals(other.deprecatedReasonsV0)) {
                return false;
            }
            if (this.degradedBrokerComponents == null ? other.degradedBrokerComponents != null : !this.degradedBrokerComponents.equals(other.degradedBrokerComponents)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            hashCode = 31 * hashCode + (this.deprecatedReasonsV0 == null ? 0 : this.deprecatedReasonsV0.hashCode());
            hashCode = 31 * hashCode + (this.degradedBrokerComponents == null ? 0 : this.degradedBrokerComponents.hashCode());
            return hashCode;
        }

        @Override
        public DegradedBroker duplicate() {
            DegradedBroker _duplicate = new DegradedBroker();
            _duplicate.brokerId = this.brokerId;
            ArrayList<Reason> newDeprecatedReasonsV0 = new ArrayList<Reason>(this.deprecatedReasonsV0.size());
            for (Reason _element : this.deprecatedReasonsV0) {
                newDeprecatedReasonsV0.add(_element.duplicate());
            }
            _duplicate.deprecatedReasonsV0 = newDeprecatedReasonsV0;
            ArrayList<DegradedBrokerComponent> newDegradedBrokerComponents = new ArrayList<DegradedBrokerComponent>(this.degradedBrokerComponents.size());
            for (DegradedBrokerComponent _element : this.degradedBrokerComponents) {
                newDegradedBrokerComponents.add(_element.duplicate());
            }
            _duplicate.degradedBrokerComponents = newDegradedBrokerComponents;
            return _duplicate;
        }

        public String toString() {
            return "DegradedBroker(brokerId=" + this.brokerId + ", deprecatedReasonsV0=" + MessageUtil.deepToString(this.deprecatedReasonsV0.iterator()) + ", degradedBrokerComponents=" + MessageUtil.deepToString(this.degradedBrokerComponents.iterator()) + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        public List<Reason> deprecatedReasonsV0() {
            return this.deprecatedReasonsV0;
        }

        public List<DegradedBrokerComponent> degradedBrokerComponents() {
            return this.degradedBrokerComponents;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DegradedBroker setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        public DegradedBroker setDeprecatedReasonsV0(List<Reason> v) {
            this.deprecatedReasonsV0 = v;
            return this;
        }

        public DegradedBroker setDegradedBrokerComponents(List<DegradedBrokerComponent> v) {
            this.degradedBrokerComponents = v;
            return this;
        }
    }

    public static class DegradedBrokerComponent
    implements Message {
        String reason;
        byte componentCode;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1 = new Schema(new Field("reason", Type.COMPACT_STRING, "A unique tag representing why a broker's health has been altered in the given manner."), new Field("component_code", Type.INT8, "Which component of broker health has been altered due to the provided reason (UNSPECIFIED=0, STORAGE=1, NETWORK=2)."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public DegradedBrokerComponent(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public DegradedBrokerComponent() {
            this.reason = "";
            this.componentCode = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DegradedBrokerComponent");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field reason was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field reason had invalid length " + length);
            }
            this.reason = _readable.readString(length);
            this.componentCode = _readable.readByte();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DegradedBrokerComponent");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.reason);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeByte(this.componentCode);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DegradedBrokerComponent");
            }
            byte[] _stringBytes = this.reason.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'reason' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.reason, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DegradedBrokerComponent)) {
                return false;
            }
            DegradedBrokerComponent other = (DegradedBrokerComponent)obj;
            if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
                return false;
            }
            if (this.componentCode != other.componentCode) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.reason == null ? 0 : this.reason.hashCode());
            hashCode = 31 * hashCode + this.componentCode;
            return hashCode;
        }

        @Override
        public DegradedBrokerComponent duplicate() {
            DegradedBrokerComponent _duplicate = new DegradedBrokerComponent();
            _duplicate.reason = this.reason;
            _duplicate.componentCode = this.componentCode;
            return _duplicate;
        }

        public String toString() {
            return "DegradedBrokerComponent(reason=" + (String)(this.reason == null ? "null" : "'" + this.reason.toString() + "'") + ", componentCode=" + this.componentCode + ")";
        }

        public String reason() {
            return this.reason;
        }

        public byte componentCode() {
            return this.componentCode;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DegradedBrokerComponent setReason(String v) {
            this.reason = v;
            return this;
        }

        public DegradedBrokerComponent setComponentCode(byte v) {
            this.componentCode = v;
            return this;
        }
    }

    public static class Reason
    implements Message {
        String reason;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("reason", Type.COMPACT_STRING, "Uniquely identifies the cause of demotion."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Reason(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public Reason() {
            this.reason = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field reason was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field reason had invalid length " + length);
            }
            this.reason = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of Reason");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.reason);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.reason.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'reason' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.reason, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Reason)) {
                return false;
            }
            Reason other = (Reason)obj;
            if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.reason == null ? 0 : this.reason.hashCode());
            return hashCode;
        }

        @Override
        public Reason duplicate() {
            Reason _duplicate = new Reason();
            _duplicate.reason = this.reason;
            return _duplicate;
        }

        public String toString() {
            return "Reason(reason=" + (String)(this.reason == null ? "null" : "'" + this.reason.toString() + "'") + ")";
        }

        public String reason() {
            return this.reason;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Reason setReason(String v) {
            this.reason = v;
            return this;
        }
    }
}

