/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.internals;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.apache.kafka.common.KafkaException;

public class ReflectionUtils {
    protected static <T> T invoke(String methodName, MethodHandle methodHandle, Object ... args) {
        try {
            if (methodHandle == null) {
                throw new IllegalArgumentException("Method not found: " + methodName);
            }
            return (T)methodHandle.invokeWithArguments(args);
        }
        catch (Throwable t) {
            throw new KafkaException("Method invocation failed: " + methodName, t);
        }
    }

    protected static MethodHandle methodHandle(MethodHandles.Lookup lookup, Class<?> clazz, String methodName, Class<?> ... argTypes) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, argTypes);
            method.setAccessible(true);
            return lookup.unreflect(method);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new KafkaException("Failed to add method " + clazz.getName() + "." + methodName, e);
        }
    }
}

