/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Objects;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.common.message.AlterMirrorsResponseData;

@Confluent
public class PartitionTruncationInformation {
    private final int partitionId;
    private final long offsetTruncatedTo;
    private final long messagesTruncated;

    public PartitionTruncationInformation(int partitionId, long offsetTruncatedTo, long messagesTruncated) {
        this.partitionId = partitionId;
        this.offsetTruncatedTo = offsetTruncatedTo;
        this.messagesTruncated = messagesTruncated;
    }

    public PartitionTruncationInformation(AlterMirrorsResponseData.MirrorPartitionResponseData data) {
        this(data.partitionId(), data.offsetTruncatedTo(), data.messagesTruncated());
    }

    public int partitionId() {
        return this.partitionId;
    }

    public long offsetTruncatedTo() {
        return this.offsetTruncatedTo;
    }

    public long messagesTruncated() {
        return this.messagesTruncated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionTruncationInformation that = (PartitionTruncationInformation)o;
        return Objects.equals(this.partitionId, that.partitionId) && Objects.equals(this.offsetTruncatedTo, that.offsetTruncatedTo) && Objects.equals(this.messagesTruncated, that.messagesTruncated);
    }

    public int hashCode() {
        return Objects.hash(this.partitionId, this.offsetTruncatedTo, this.messagesTruncated);
    }

    public String toString() {
        return "PartitionTruncationInformation(partitionId=" + this.partitionId + ", offsetTruncatedTo=" + this.offsetTruncatedTo + ", messagesTruncated=" + this.messagesTruncated;
    }
}

