/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.TruncateAndRestoreResult;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
@Confluent
public class AlterMirrorsResult {
    private final Map<String, KafkaFuture<Void>> futures;
    private final Map<String, KafkaFuture<TruncateAndRestoreResult>> truncateAndRestoreFutures;

    public AlterMirrorsResult(Map<String, KafkaFuture<Void>> futures, Map<String, KafkaFuture<TruncateAndRestoreResult>> truncateAndRestoreFutures) {
        if (!(futures != null ^ truncateAndRestoreFutures != null)) {
            throw new IllegalStateException("Exactly one of futures and truncateAndRestoreFutures should be not null");
        }
        this.futures = futures;
        this.truncateAndRestoreFutures = truncateAndRestoreFutures;
    }

    public AlterMirrorsResult(Map<String, KafkaFuture<Void>> futures) {
        this(futures, null);
    }

    public Map<String, KafkaFuture<Void>> values() {
        return this.futures;
    }

    public Map<String, KafkaFuture<TruncateAndRestoreResult>> truncateAndRestoreValues() {
        return this.truncateAndRestoreFutures;
    }

    public KafkaFuture<Void> all() {
        if (this.futures != null) {
            return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0]));
        }
        throw new IllegalStateException("Cannot use all() on truncate and restore results. Use allTruncateAndRestoreResults instead.");
    }

    public KafkaFuture<Map<String, TruncateAndRestoreResult>> allTruncateAndRestoreResults() {
        if (this.truncateAndRestoreFutures != null) {
            return KafkaFuture.allOf(this.truncateAndRestoreFutures.values().toArray(new KafkaFuture[0])).thenApply(aVoid -> {
                HashMap<String, TruncateAndRestoreResult> result = new HashMap<String, TruncateAndRestoreResult>(this.truncateAndRestoreFutures.size());
                for (Map.Entry<String, KafkaFuture<TruncateAndRestoreResult>> entry : this.truncateAndRestoreFutures.entrySet()) {
                    try {
                        result.put(entry.getKey(), entry.getValue().get());
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                return result;
            });
        }
        throw new IllegalStateException("Attempted to use allTruncateRestoreResults() on a result that is not truncate and restore.");
    }
}

