/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.oauthbearer;

import io.confluent.kafka.security.oauthbearer.ValidationUtils;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpRequestFormatter;
import org.apache.kafka.common.utils.Utils;

public class ClientSecretHttpRequestFormatter
implements HttpRequestFormatter {
    private String clientId;
    private String clientSecret;
    private final String scope;
    private final boolean urlEncodeHeader;
    public static final String AUTHORIZATION_HEADER = "Authorization";

    public ClientSecretHttpRequestFormatter(String clientId, String clientSecret, String scope, boolean urlEncodeHeader) {
        this.clientId = Objects.requireNonNull(clientId);
        this.clientSecret = Objects.requireNonNull(clientSecret);
        this.scope = scope;
        this.urlEncodeHeader = urlEncodeHeader;
    }

    @Override
    public Map<String, String> formatHeaders() {
        return Collections.singletonMap(AUTHORIZATION_HEADER, this.getAuthHeader());
    }

    private String getAuthHeader() {
        this.clientId = ValidationUtils.sanitizeString("the token endpoint request client ID parameter", this.clientId);
        this.clientSecret = ValidationUtils.sanitizeString("the token endpoint request client secret parameter", this.clientSecret);
        if (this.urlEncodeHeader) {
            this.clientId = URLEncoder.encode(this.clientId, StandardCharsets.UTF_8);
            this.clientSecret = URLEncoder.encode(this.clientSecret, StandardCharsets.UTF_8);
        }
        String s2 = String.format("%s:%s", this.clientId, this.clientSecret);
        String encoded = Base64.getEncoder().encodeToString(Utils.utf8(s2));
        return String.format("Basic %s", encoded);
    }

    @Override
    public String formatBody() {
        StringBuilder requestParameters = new StringBuilder();
        requestParameters.append("grant_type=client_credentials");
        if (this.scope != null && !this.scope.trim().isEmpty()) {
            String encodedScope = URLEncoder.encode(this.scope.trim(), StandardCharsets.UTF_8);
            requestParameters.append("&scope=").append(encodedScope);
        }
        return requestParameters.toString();
    }
}

