/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.consumer.internals.RequestState;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;

public class HeartbeatRequestState
extends RequestState {
    private final Timer heartbeatTimer;
    private long heartbeatIntervalMs;

    public HeartbeatRequestState(LogContext logContext, Time time, long heartbeatIntervalMs, long retryBackoffMs, long retryBackoffMaxMs, double jitter) {
        super(logContext, HeartbeatRequestState.class.getName(), retryBackoffMs, 2, retryBackoffMaxMs, jitter);
        this.heartbeatIntervalMs = heartbeatIntervalMs;
        this.heartbeatTimer = time.timer(heartbeatIntervalMs);
    }

    public long heartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void resetTimer() {
        this.heartbeatTimer.reset(this.heartbeatIntervalMs);
    }

    public long timeToNextHeartbeatMs(long currentTimeMs) {
        if (this.heartbeatTimer.isExpired()) {
            return this.remainingBackoffMs(currentTimeMs);
        }
        return this.heartbeatTimer.remainingMs();
    }

    @Override
    public void onFailedAttempt(long currentTimeMs) {
        this.heartbeatTimer.reset(0L);
        super.onFailedAttempt(currentTimeMs);
    }

    @Override
    public boolean canSendRequest(long currentTimeMs) {
        this.update(currentTimeMs);
        return this.heartbeatTimer.isExpired() && super.canSendRequest(currentTimeMs);
    }

    private void update(long currentTimeMs) {
        this.heartbeatTimer.update(currentTimeMs);
    }

    public void updateHeartbeatIntervalMs(long heartbeatIntervalMs) {
        if (this.heartbeatIntervalMs == heartbeatIntervalMs) {
            return;
        }
        this.heartbeatIntervalMs = heartbeatIntervalMs;
        this.heartbeatTimer.updateAndReset(heartbeatIntervalMs);
    }

    @Override
    public String toStringBase() {
        return super.toStringBase() + ", remainingMs=" + this.heartbeatTimer.remainingMs() + ", heartbeatIntervalMs=" + this.heartbeatIntervalMs;
    }
}

