/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.MetadataResponse;

public class MetadataRequest
extends AbstractRequest {
    private final MetadataRequestData data;

    public MetadataRequest(MetadataRequestData data, short version) {
        super(ApiKeys.METADATA, version);
        this.data = data;
    }

    @Override
    public MetadataRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        MetadataResponseData responseData = new MetadataResponseData();
        if (this.data.topics() != null) {
            for (MetadataRequestData.MetadataRequestTopic topic : this.data.topics()) {
                String topicName = topic.name() == null ? "" : topic.name();
                responseData.topics().add(new MetadataResponseData.MetadataResponseTopic().setName(topicName).setTopicId(topic.topicId()).setErrorCode(error.code()).setIsInternal(false).setPartitions(Collections.emptyList()).setTopicType(TopicType.UNKNOWN.id()));
            }
        }
        responseData.setThrottleTimeMs(throttleTimeMs);
        responseData.setErrorCode(error.code());
        return new MetadataResponse(responseData, true);
    }

    public boolean isAllTopics() {
        return this.data.topics() == null || this.data.topics().isEmpty() && this.version() == 0;
    }

    public List<String> topics() {
        if (this.isAllTopics()) {
            return null;
        }
        return this.data.topics().stream().map(MetadataRequestData.MetadataRequestTopic::name).collect(Collectors.toList());
    }

    public List<Uuid> topicIds() {
        if (this.isAllTopics()) {
            return Collections.emptyList();
        }
        if (this.version() < 10) {
            return Collections.emptyList();
        }
        return this.data.topics().stream().map(MetadataRequestData.MetadataRequestTopic::topicId).collect(Collectors.toList());
    }

    public boolean allowAutoTopicCreation() {
        return this.data.allowAutoTopicCreation();
    }

    public static MetadataRequest parse(Readable readable, short version, MessageContext context) {
        return new MetadataRequest(new MetadataRequestData(readable, version, context), version);
    }

    public static List<MetadataRequestData.MetadataRequestTopic> convertToMetadataRequestTopic(Collection<String> topics) {
        return topics.stream().map(topic -> new MetadataRequestData.MetadataRequestTopic().setName((String)topic)).collect(Collectors.toList());
    }

    public static List<MetadataRequestData.MetadataRequestTopic> convertTopicIdsToMetadataRequestTopic(Collection<Uuid> topicIds) {
        return topicIds.stream().map(topicId -> new MetadataRequestData.MetadataRequestTopic().setTopicId((Uuid)topicId)).collect(Collectors.toList());
    }

    public static class Builder
    extends AbstractRequest.Builder<MetadataRequest> {
        private static final MetadataRequestData ALL_TOPICS_REQUEST_DATA = new MetadataRequestData().setTopics(null).setAllowAutoTopicCreation(true);
        private final MetadataRequestData data;

        public Builder(MetadataRequestData data) {
            super(ApiKeys.METADATA);
            this.data = data;
        }

        public Builder(List<String> topics, boolean allowAutoTopicCreation, short allowedVersion) {
            this(topics, allowAutoTopicCreation, allowedVersion, allowedVersion);
        }

        public Builder(List<String> topics, boolean allowAutoTopicCreation, short minVersion, short maxVersion) {
            super(ApiKeys.METADATA, minVersion, maxVersion);
            this.data = this.requestTopicNamesOrAllTopics(topics, allowAutoTopicCreation);
        }

        private MetadataRequestData requestTopicNamesOrAllTopics(List<String> topics, boolean allowAutoTopicCreation) {
            MetadataRequestData data = new MetadataRequestData();
            if (topics == null) {
                data.setTopics(null);
            } else {
                topics.forEach(topic -> data.topics().add(new MetadataRequestData.MetadataRequestTopic().setName((String)topic)));
            }
            data.setAllowAutoTopicCreation(allowAutoTopicCreation);
            return data;
        }

        private static MetadataRequestData requestTopicIds(Set<Uuid> topicIds) {
            MetadataRequestData data = new MetadataRequestData();
            if (topicIds == null) {
                data.setTopics(null);
            } else {
                topicIds.forEach(topicId -> data.topics().add(new MetadataRequestData.MetadataRequestTopic().setTopicId((Uuid)topicId)));
            }
            data.setAllowAutoTopicCreation(false);
            return data;
        }

        public Builder(List<String> topics, boolean allowAutoTopicCreation) {
            this(topics, allowAutoTopicCreation, ApiKeys.METADATA.oldestVersion(), ApiKeys.METADATA.latestVersion());
        }

        public static Builder allTopics() {
            return new Builder(ALL_TOPICS_REQUEST_DATA);
        }

        public static Builder forTopicNames(List<String> topicNames, boolean allowAutoTopicCreation) {
            return new Builder(topicNames, allowAutoTopicCreation);
        }

        public static Builder forTopicIds(Set<Uuid> topicIds) {
            return new Builder(Builder.requestTopicIds(new HashSet<Uuid>(topicIds)));
        }

        public boolean emptyTopicList() {
            return this.data.topics().isEmpty();
        }

        public boolean isAllTopics() {
            return this.data.topics() == null;
        }

        public List<Uuid> topicIds() {
            return this.data.topics().stream().map(MetadataRequestData.MetadataRequestTopic::topicId).collect(Collectors.toList());
        }

        public List<String> topics() {
            return this.data.topics().stream().map(MetadataRequestData.MetadataRequestTopic::name).collect(Collectors.toList());
        }

        @Override
        public MetadataRequest build(short version) {
            if (version < 1) {
                throw new UnsupportedVersionException("MetadataRequest versions older than 1 are not supported.");
            }
            if (!this.data.allowAutoTopicCreation() && version < 4) {
                throw new UnsupportedVersionException("MetadataRequest versions older than 4 don't support the allowAutoTopicCreation field");
            }
            if (this.data.topics() != null) {
                this.data.topics().forEach(topic -> {
                    if (topic.name() == null && version < 12) {
                        throw new UnsupportedVersionException("MetadataRequest version " + version + " does not support null topic names.");
                    }
                    if (!Uuid.ZERO_UUID.equals(topic.topicId()) && version < 12) {
                        throw new UnsupportedVersionException("MetadataRequest version " + version + " does not support non-zero topic IDs.");
                    }
                });
            }
            return new MetadataRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

