/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.message.InitProducerIdRequestData;
import org.apache.kafka.common.message.InitProducerIdResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.InitProducerIdResponse;

public class InitProducerIdRequest
extends AbstractRequest {
    private final InitProducerIdRequestData data;

    private InitProducerIdRequest(InitProducerIdRequestData data, short version) {
        super(ApiKeys.INIT_PRODUCER_ID, version);
        this.data = data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        InitProducerIdResponseData response = new InitProducerIdResponseData().setErrorCode(Errors.forException(e).code()).setProducerId(-1L).setProducerEpoch((short)-1).setThrottleTimeMs(throttleTimeMs);
        return new InitProducerIdResponse(response);
    }

    public static InitProducerIdRequest parse(Readable readable, short version, MessageContext context) {
        return new InitProducerIdRequest(new InitProducerIdRequestData(readable, version, context), version);
    }

    @Override
    public InitProducerIdRequestData data() {
        return this.data;
    }

    public boolean enable2Pc() {
        return this.data.enable2Pc() || this.data.confluentEnableTwoPhaseCommit();
    }

    public boolean keepPreparedTxn() {
        return this.data.keepPreparedTxn() || this.data.confluentKeepPreparedTransaction();
    }

    public boolean isCfltFlink2PCTransaction() {
        return this.data.confluentEnableTwoPhaseCommit();
    }

    public static class Builder
    extends AbstractRequest.Builder<InitProducerIdRequest> {
        public final InitProducerIdRequestData data;

        public Builder(InitProducerIdRequestData data) {
            super(ApiKeys.INIT_PRODUCER_ID);
            this.data = data;
        }

        @Override
        public InitProducerIdRequest build(short version) {
            if (this.data.transactionTimeoutMs() <= 0) {
                throw new IllegalArgumentException("transaction timeout value is not positive: " + this.data.transactionTimeoutMs());
            }
            if (this.data.transactionalId() != null && this.data.transactionalId().isEmpty()) {
                throw new IllegalArgumentException("Must set either a null or a non-empty transactional id.");
            }
            return new InitProducerIdRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

