/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.EnumMap;
import java.util.Map;
import org.apache.kafka.common.message.DescribeLogDirsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeLogDirsResponse
extends AbstractResponse {
    public static final long INVALID_OFFSET_LAG = -1L;
    public static final long UNKNOWN_VOLUME_BYTES = -1L;
    private final DescribeLogDirsResponseData data;

    public DescribeLogDirsResponse(DescribeLogDirsResponseData data) {
        super(ApiKeys.DESCRIBE_LOG_DIRS);
        this.data = data;
    }

    @Override
    public DescribeLogDirsResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> errorCounts = new EnumMap<Errors, Integer>(Errors.class);
        errorCounts.put(Errors.forCode(this.data.errorCode()), 1);
        this.data.results().forEach(result -> DescribeLogDirsResponse.updateErrorCounts(errorCounts, Errors.forCode(result.errorCode())));
        return errorCounts;
    }

    public static DescribeLogDirsResponse parse(Readable readable, short version, MessageContext context) {
        return new DescribeLogDirsResponse(new DescribeLogDirsResponseData(readable, version, context));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

