/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.AlterBrokerHealthResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class AlterBrokerHealthResponse
extends AbstractResponse {
    private final AlterBrokerHealthResponseData data;

    public AlterBrokerHealthResponse(AlterBrokerHealthResponseData data) {
        super(ApiKeys.ALTER_BROKER_HEALTH);
        this.data = data;
    }

    @Override
    public AlterBrokerHealthResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        if (this.data.errorCode() != Errors.NONE.code()) {
            if (this.data.brokerHealthStatusResults().isEmpty()) {
                return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
            }
            return Collections.singletonMap(Errors.forCode(this.data.errorCode()), this.data.brokerHealthStatusResults().size());
        }
        return AlterBrokerHealthResponse.errorCounts(this.data.brokerHealthStatusResults().stream().map(result -> Errors.forCode(result.errorCode())).collect(Collectors.toList()));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    public static AlterBrokerHealthResponse parse(Readable readable, short version, MessageContext context) {
        return new AlterBrokerHealthResponse(new AlterBrokerHealthResponseData(readable, version, context));
    }
}

