/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ReadShareGroupStateResponseData
implements ApiMessage {
    List<ReadStateResult> results;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("results", new CompactArrayOf(ReadStateResult.SCHEMA_0), "The read results."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ReadShareGroupStateResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ReadShareGroupStateResponseData() {
        this.results = new ArrayList<ReadStateResult>(0);
    }

    @Override
    public short apiKey() {
        return 84;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field results was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<ReadStateResult> newCollection = new ArrayList<ReadStateResult>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new ReadStateResult(_readable, _version, _context));
        }
        this.results = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.results.size() + 1);
        for (ReadStateResult resultsElement : this.results) {
            resultsElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.results.size() + 1));
        for (ReadStateResult resultsElement : this.results) {
            resultsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReadShareGroupStateResponseData)) {
            return false;
        }
        ReadShareGroupStateResponseData other = (ReadShareGroupStateResponseData)obj;
        if (this.results == null ? other.results != null : !this.results.equals(other.results)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.results == null ? 0 : this.results.hashCode());
        return hashCode;
    }

    @Override
    public ReadShareGroupStateResponseData duplicate() {
        ReadShareGroupStateResponseData _duplicate = new ReadShareGroupStateResponseData();
        ArrayList<ReadStateResult> newResults = new ArrayList<ReadStateResult>(this.results.size());
        for (ReadStateResult _element : this.results) {
            newResults.add(_element.duplicate());
        }
        _duplicate.results = newResults;
        return _duplicate;
    }

    public String toString() {
        return "ReadShareGroupStateResponseData(results=" + MessageUtil.deepToString(this.results.iterator()) + ")";
    }

    public List<ReadStateResult> results() {
        return this.results;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ReadShareGroupStateResponseData setResults(List<ReadStateResult> v) {
        this.results = v;
        return this;
    }

    public static class ReadStateResult
    implements Message {
        Uuid topicId;
        List<PartitionResult> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_id", Type.UUID, "The topic identifier."), new Field("partitions", new CompactArrayOf(PartitionResult.SCHEMA_0), "The results for the partitions."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public ReadStateResult(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ReadStateResult() {
            this.topicId = Uuid.ZERO_UUID;
            this.partitions = new ArrayList<PartitionResult>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ReadStateResult");
            }
            this.topicId = _readable.readUuid();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<PartitionResult> newCollection = new ArrayList<PartitionResult>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new PartitionResult(_readable, _version, _context));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeUuid(this.topicId);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            for (PartitionResult partitionsElement : this.partitions) {
                partitionsElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ReadStateResult");
            }
            _size.addBytes(16);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (PartitionResult partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReadStateResult)) {
                return false;
            }
            ReadStateResult other = (ReadStateResult)obj;
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public ReadStateResult duplicate() {
            ReadStateResult _duplicate = new ReadStateResult();
            _duplicate.topicId = this.topicId;
            ArrayList<PartitionResult> newPartitions = new ArrayList<PartitionResult>(this.partitions.size());
            for (PartitionResult _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "ReadStateResult(topicId=" + this.topicId.toString() + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public List<PartitionResult> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ReadStateResult setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public ReadStateResult setPartitions(List<PartitionResult> v) {
            this.partitions = v;
            return this;
        }
    }

    public static class StateBatch
    implements Message {
        long firstOffset;
        long lastOffset;
        byte deliveryState;
        short deliveryCount;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("first_offset", Type.INT64, "The first offset of this state batch."), new Field("last_offset", Type.INT64, "The last offset of this state batch."), new Field("delivery_state", Type.INT8, "The delivery state - 0:Available,2:Acked,4:Archived."), new Field("delivery_count", Type.INT16, "The delivery count."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public StateBatch(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public StateBatch() {
            this.firstOffset = 0L;
            this.lastOffset = 0L;
            this.deliveryState = 0;
            this.deliveryCount = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of StateBatch");
            }
            this.firstOffset = _readable.readLong();
            this.lastOffset = _readable.readLong();
            this.deliveryState = _readable.readByte();
            this.deliveryCount = _readable.readShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeLong(this.firstOffset);
            _writable.writeLong(this.lastOffset);
            _writable.writeByte(this.deliveryState);
            _writable.writeShort(this.deliveryCount);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of StateBatch");
            }
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(1);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StateBatch)) {
                return false;
            }
            StateBatch other = (StateBatch)obj;
            if (this.firstOffset != other.firstOffset) {
                return false;
            }
            if (this.lastOffset != other.lastOffset) {
                return false;
            }
            if (this.deliveryState != other.deliveryState) {
                return false;
            }
            if (this.deliveryCount != other.deliveryCount) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + ((int)(this.firstOffset >> 32) ^ (int)this.firstOffset);
            hashCode = 31 * hashCode + ((int)(this.lastOffset >> 32) ^ (int)this.lastOffset);
            hashCode = 31 * hashCode + this.deliveryState;
            hashCode = 31 * hashCode + this.deliveryCount;
            return hashCode;
        }

        @Override
        public StateBatch duplicate() {
            StateBatch _duplicate = new StateBatch();
            _duplicate.firstOffset = this.firstOffset;
            _duplicate.lastOffset = this.lastOffset;
            _duplicate.deliveryState = this.deliveryState;
            _duplicate.deliveryCount = this.deliveryCount;
            return _duplicate;
        }

        public String toString() {
            return "StateBatch(firstOffset=" + this.firstOffset + ", lastOffset=" + this.lastOffset + ", deliveryState=" + this.deliveryState + ", deliveryCount=" + this.deliveryCount + ")";
        }

        public long firstOffset() {
            return this.firstOffset;
        }

        public long lastOffset() {
            return this.lastOffset;
        }

        public byte deliveryState() {
            return this.deliveryState;
        }

        public short deliveryCount() {
            return this.deliveryCount;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public StateBatch setFirstOffset(long v) {
            this.firstOffset = v;
            return this;
        }

        public StateBatch setLastOffset(long v) {
            this.lastOffset = v;
            return this;
        }

        public StateBatch setDeliveryState(byte v) {
            this.deliveryState = v;
            return this;
        }

        public StateBatch setDeliveryCount(short v) {
            this.deliveryCount = v;
            return this;
        }
    }

    public static class PartitionResult
    implements Message {
        int partition;
        short errorCode;
        String errorMessage;
        int stateEpoch;
        long startOffset;
        List<StateBatch> stateBatches;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), new Field("state_epoch", Type.INT32, "The state epoch of the share-partition."), new Field("start_offset", Type.INT64, "The share-partition start offset, which can be -1 if it is not yet initialized."), new Field("state_batches", new CompactArrayOf(StateBatch.SCHEMA_0), "The state batches for this share-partition."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public PartitionResult(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public PartitionResult() {
            this.partition = 0;
            this.errorCode = 0;
            this.errorMessage = null;
            this.stateEpoch = 0;
            this.startOffset = 0L;
            this.stateBatches = new ArrayList<StateBatch>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionResult");
            }
            this.partition = _readable.readInt();
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _readable.readString(length);
            }
            this.stateEpoch = _readable.readInt();
            this.startOffset = _readable.readLong();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field stateBatches was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<StateBatch> newCollection = new ArrayList<StateBatch>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new StateBatch(_readable, _version, _context));
            }
            this.stateBatches = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeInt(this.partition);
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            _writable.writeInt(this.stateEpoch);
            _writable.writeLong(this.startOffset);
            _writable.writeUnsignedVarint(this.stateBatches.size() + 1);
            _stringBytes = this.stateBatches.iterator();
            while (_stringBytes.hasNext()) {
                StateBatch stateBatchesElement = (StateBatch)_stringBytes.next();
                stateBatchesElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionResult");
            }
            _size.addBytes(4);
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _size.addBytes(4);
            _size.addBytes(8);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.stateBatches.size() + 1));
            for (StateBatch stateBatchesElement : this.stateBatches) {
                stateBatchesElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionResult)) {
                return false;
            }
            PartitionResult other = (PartitionResult)obj;
            if (this.partition != other.partition) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.stateEpoch != other.stateEpoch) {
                return false;
            }
            if (this.startOffset != other.startOffset) {
                return false;
            }
            if (this.stateBatches == null ? other.stateBatches != null : !this.stateBatches.equals(other.stateBatches)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partition;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + this.stateEpoch;
            hashCode = 31 * hashCode + ((int)(this.startOffset >> 32) ^ (int)this.startOffset);
            hashCode = 31 * hashCode + (this.stateBatches == null ? 0 : this.stateBatches.hashCode());
            return hashCode;
        }

        @Override
        public PartitionResult duplicate() {
            PartitionResult _duplicate = new PartitionResult();
            _duplicate.partition = this.partition;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            _duplicate.stateEpoch = this.stateEpoch;
            _duplicate.startOffset = this.startOffset;
            ArrayList<StateBatch> newStateBatches = new ArrayList<StateBatch>(this.stateBatches.size());
            for (StateBatch _element : this.stateBatches) {
                newStateBatches.add(_element.duplicate());
            }
            _duplicate.stateBatches = newStateBatches;
            return _duplicate;
        }

        public String toString() {
            return "PartitionResult(partition=" + this.partition + ", errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", stateEpoch=" + this.stateEpoch + ", startOffset=" + this.startOffset + ", stateBatches=" + MessageUtil.deepToString(this.stateBatches.iterator()) + ")";
        }

        public int partition() {
            return this.partition;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public int stateEpoch() {
            return this.stateEpoch;
        }

        public long startOffset() {
            return this.startOffset;
        }

        public List<StateBatch> stateBatches() {
            return this.stateBatches;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionResult setPartition(int v) {
            this.partition = v;
            return this;
        }

        public PartitionResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public PartitionResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public PartitionResult setStateEpoch(int v) {
            this.stateEpoch = v;
            return this;
        }

        public PartitionResult setStartOffset(long v) {
            this.startOffset = v;
            return this;
        }

        public PartitionResult setStateBatches(List<StateBatch> v) {
            this.stateBatches = v;
            return this;
        }
    }
}

