/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.oauthbearer;

import io.confluent.kafka.security.oauthbearer.ClientAssertion;
import io.confluent.kafka.security.oauthbearer.ClientAssertionHttpRequestFormatter;
import io.confluent.kafka.security.oauthbearer.ClientSecretHttpRequestFormatter;
import io.confluent.kafka.security.oauthbearer.FileBasedClientAssertion;
import io.confluent.kafka.security.oauthbearer.PrivateKeyClientAssertion;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigOrJaas;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpRequestFormatter;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestFormatterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestFormatterFactory.class);

    public static HttpRequestFormatter create(ConfigurationUtils cu, JaasOptionsUtils jou) {
        ConfigOrJaas configOrJaas = new ConfigOrJaas(cu, jou);
        String scope = configOrJaas.scope();
        boolean urlEncodeHeader = HttpRequestFormatterFactory.validateUrlEncodeHeader(cu);
        if (cu.containsKey("sasl.oauthbearer.assertion.claim.iss") || cu.containsKey("sasl.oauthbearer.assertion.file")) {
            String clientAssertionLocation = (String)cu.get("sasl.oauthbearer.assertion.file");
            ClientAssertion clientAssertion = null;
            if (clientAssertionLocation != null) {
                LOG.info("Configuring File based client assertion using file: {}", (Object)clientAssertionLocation);
                clientAssertion = new FileBasedClientAssertion(clientAssertionLocation);
            } else {
                LOG.info("Configuring local client assertion creation");
                clientAssertion = new PrivateKeyClientAssertion(cu.validateString("sasl.oauthbearer.assertion.claim.iss"), cu.validateString("sasl.oauthbearer.assertion.claim.aud"), cu.validateString("sasl.oauthbearer.assertion.claim.sub"), cu.validateInteger("sasl.oauthbearer.assertion.claim.exp.minutes", false, 1), (Boolean)cu.get("sasl.oauthbearer.assertion.claim.nbf.include"), (Boolean)cu.get("sasl.oauthbearer.assertion.claim.jti.include"), cu.validateString("sasl.oauthbearer.assertion.private.key.file"), cu.validatePassword("sasl.oauthbearer.assertion.private.key.passphrase", false), cu.validateString("sasl.oauthbearer.assertion.template.file", false));
            }
            return new ClientAssertionHttpRequestFormatter(clientAssertion, configOrJaas.clientId(false), scope);
        }
        return new ClientSecretHttpRequestFormatter(configOrJaas.clientId(), configOrJaas.clientSecret(), scope, urlEncodeHeader);
    }

    static boolean validateUrlEncodeHeader(ConfigurationUtils configurationUtils) {
        Boolean urlEncodeHeader = configurationUtils.validateBoolean("sasl.oauthbearer.header.urlencode", false);
        if (urlEncodeHeader != null) {
            return urlEncodeHeader;
        }
        return false;
    }
}

