/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.apache.kafka.common.utils.LogAction;
import org.apache.kafka.common.utils.TimeBasedSampler;

public class SlowLogAction
implements LogAction {
    private final TimeBasedSampler sampler;
    private final Double slowLogThresholdOverride;
    private final Double minP99SlowLogThreshold;

    public SlowLogAction(TimeBasedSampler sampler, Double slowLogThresholdOverride, Double minP99SlowLogThreshold) {
        this.sampler = sampler;
        this.slowLogThresholdOverride = slowLogThresholdOverride;
        this.minP99SlowLogThreshold = minP99SlowLogThreshold;
    }

    @Override
    public boolean shouldLog() {
        return true;
    }

    @Override
    public boolean shouldCaptureTrace() {
        return false;
    }

    public LogAction maybeSample(long requestTimeMs) {
        return this.sampler.maybeSample(requestTimeMs);
    }

    public SlowLogCheckResponse shouldLogSlowRequests(double totalTimeMs, Double p99Threshold, long requestTimeMs) {
        double newThreshold = p99Threshold;
        if (this.slowLogThresholdOverride >= 0.0) {
            newThreshold = this.slowLogThresholdOverride;
        } else if (this.minP99SlowLogThreshold >= 0.0) {
            newThreshold = Math.max(this.minP99SlowLogThreshold, p99Threshold);
        }
        boolean shouldLog = totalTimeMs > newThreshold && this.maybeSample(requestTimeMs).shouldLog();
        return new SlowLogCheckResponse(shouldLog, newThreshold);
    }

    public static class SlowLogCheckResponse {
        public boolean shouldLog;
        public double slowLogThreshold;

        public SlowLogCheckResponse(boolean shouldLog, double slowLogThreshold) {
            this.shouldLog = shouldLog;
            this.slowLogThreshold = slowLogThreshold;
        }
    }
}

