/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.internals.ExclusionRequestUtils;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AlterBrokerHealthRequestData;
import org.apache.kafka.common.message.AlterBrokerHealthResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterBrokerHealthResponse;
import org.apache.kafka.common.requests.ApiError;

public class AlterBrokerHealthRequest
extends AbstractRequest {
    public static String networkHealthManagerDetectedAlterBrokerHealthReason = "NetworkHealthManager";
    public static String networkHealthStartupAlterBrokerHealthReason = "NetworkHealthStartup";
    private final AlterBrokerHealthRequestData data;

    public AlterBrokerHealthRequest(AlterBrokerHealthRequestData data, short apiVersion) {
        super(ApiKeys.ALTER_BROKER_HEALTH, apiVersion);
        this.data = data;
    }

    @Override
    public AlterBrokerHealthRequestData data() {
        return this.data;
    }

    @Override
    public AlterBrokerHealthResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        AlterBrokerHealthResponseData responseData = new AlterBrokerHealthResponseData().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setThrottleTimeMs(throttleTimeMs);
        return new AlterBrokerHealthResponse(responseData);
    }

    public static AlterBrokerHealthRequest parse(Readable readable, short version, MessageContext context) {
        return new AlterBrokerHealthRequest(new AlterBrokerHealthRequestData(readable, version, context), version);
    }

    private boolean hasValidBrokerIds() {
        if (this.data.brokerIds().isEmpty()) {
            return false;
        }
        for (Integer brokerId : this.data.brokerIds()) {
            if (brokerId >= 0) continue;
            return false;
        }
        return true;
    }

    public void validate() throws InvalidRequestException {
        if (!this.hasValidBrokerIds()) {
            throw Errors.INVALID_REQUEST.exception("Invalid brokerIds: " + String.valueOf(this.data.brokerIds()) + " must be a non-empty list where every brokerId is a non-negative integer.");
        }
        if (!this.hasValidComponentCode()) {
            throw Errors.INVALID_REQUEST.exception("Invalid componentCode: " + this.data.componentCode() + " must be one of unspecified (0), storage (1), or network (2).");
        }
        if (!this.hasValidStatusCode()) {
            throw Errors.INVALID_REQUEST.exception("Invalid statusCode: " + this.data.statusCode() + ". Valid values for statusCode are degraded (0) or healthy (1).");
        }
        if (this.hasValidEpoch() && this.data.brokerIds().size() > 1) {
            throw Errors.INVALID_REQUEST.exception("Invalid broker count: " + this.data.brokerIds().size() + ". There must only be 1 broker if epoch was set.");
        }
        try {
            ExclusionRequestUtils.validateNonEmptyReason(this.data.reason());
        }
        catch (IllegalArgumentException e) {
            throw Errors.INVALID_REQUEST.exception(e.getMessage());
        }
    }

    private boolean hasValidComponentCode() {
        BrokerComponent component = BrokerComponent.forId(this.data.componentCode());
        return component.isValid(this.version());
    }

    private boolean hasValidStatusCode() {
        return this.data.statusCode() == 0 || this.data.statusCode() == 1;
    }

    private boolean hasValidEpoch() {
        return this.data.brokerEpoch() > 0L;
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterBrokerHealthRequest> {
        private final AlterBrokerHealthRequestData data;

        public Builder(AlterBrokerHealthRequestData data) {
            super(ApiKeys.ALTER_BROKER_HEALTH);
            this.data = data;
        }

        public Builder(short oldestAllowedVersion, AlterBrokerHealthRequestData data) {
            super(ApiKeys.ALTER_BROKER_HEALTH, oldestAllowedVersion, ApiKeys.ALTER_BROKER_HEALTH.latestVersion());
            this.data = data;
        }

        public Builder(short oldestAllowedVersion, short newestAllowedVersion, AlterBrokerHealthRequestData data) {
            super(ApiKeys.ALTER_BROKER_HEALTH, oldestAllowedVersion, newestAllowedVersion);
            this.data = data;
        }

        @Override
        public AlterBrokerHealthRequest build(short version) {
            BrokerComponent component = BrokerComponent.forId(this.data.componentCode());
            if ((component = component.maybeDowngrade(version)).id() != this.data.componentCode()) {
                this.data.setComponentCode(component.id());
            }
            return new AlterBrokerHealthRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

