/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.producer.internals.BuiltInPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BuiltInPartitionerTest {
    private static final Node[] NODES = new Node[]{new Node(0, "localhost", 99), new Node(1, "localhost", 100), new Node(2, "localhost", 101), new Node(11, "localhost", 102)};
    static final String TOPIC_A = "topicA";
    static final String TOPIC_B = "topicB";
    static final String TOPIC_C = "topicC";
    final LogContext logContext = new LogContext();

    @Test
    public void testStickyPartitioning() {
        List<PartitionInfo> allPartitions = Arrays.asList(new PartitionInfo(TOPIC_A, 0, NODES[0], NODES, NODES), new PartitionInfo(TOPIC_A, 1, NODES[1], NODES, NODES), new PartitionInfo(TOPIC_A, 2, NODES[2], NODES, NODES), new PartitionInfo(TOPIC_B, 0, NODES[0], NODES, NODES));
        Cluster testCluster = new Cluster("clusterId", Arrays.asList(NODES), allPartitions, Collections.emptySet(), Collections.emptySet());
        SequentialPartitioner builtInPartitionerA = new SequentialPartitioner(this.logContext, TOPIC_A, 3);
        BuiltInPartitioner.StickyPartitionInfo partitionInfo = builtInPartitionerA.peekCurrentPartitionInfo(testCluster);
        int partA = partitionInfo.partition();
        builtInPartitionerA.updatePartitionInfo(partitionInfo, 1, testCluster);
        partitionInfo = builtInPartitionerA.peekCurrentPartitionInfo(testCluster);
        Assertions.assertEquals((int)partA, (int)partitionInfo.partition());
        builtInPartitionerA.updatePartitionInfo(partitionInfo, 1, testCluster);
        partitionInfo = builtInPartitionerA.peekCurrentPartitionInfo(testCluster);
        Assertions.assertEquals((int)partA, (int)partitionInfo.partition());
        builtInPartitionerA.updatePartitionInfo(partitionInfo, 1, testCluster);
        Assertions.assertNotEquals((int)partA, (int)builtInPartitionerA.peekCurrentPartitionInfo(testCluster).partition());
        SequentialPartitioner builtInPartitionerB = new SequentialPartitioner(this.logContext, TOPIC_B, 1);
        int c = 10;
        while (c-- > 0) {
            partitionInfo = builtInPartitionerB.peekCurrentPartitionInfo(testCluster);
            Assertions.assertEquals((int)0, (int)partitionInfo.partition());
            builtInPartitionerB.updatePartitionInfo(partitionInfo, 1, testCluster);
        }
    }

    @Test
    public void unavailablePartitionsTest() {
        List<PartitionInfo> allPartitions = Arrays.asList(new PartitionInfo(TOPIC_A, 0, NODES[0], NODES, NODES), new PartitionInfo(TOPIC_A, 1, null, NODES, NODES), new PartitionInfo(TOPIC_A, 2, NODES[2], NODES, NODES), new PartitionInfo(TOPIC_B, 0, null, NODES, NODES), new PartitionInfo(TOPIC_B, 1, NODES[0], NODES, NODES), new PartitionInfo(TOPIC_C, 0, null, NODES, NODES));
        Cluster testCluster = new Cluster("clusterId", Arrays.asList(NODES[0], NODES[1], NODES[2]), allPartitions, Collections.emptySet(), Collections.emptySet());
        BuiltInPartitioner builtInPartitionerA = new BuiltInPartitioner(this.logContext, TOPIC_A, 1);
        BuiltInPartitioner.StickyPartitionInfo partitionInfo = builtInPartitionerA.peekCurrentPartitionInfo(testCluster);
        int partA = partitionInfo.partition();
        builtInPartitionerA.updatePartitionInfo(partitionInfo, 1, testCluster);
        boolean foundAnotherPartA = false;
        Assertions.assertNotEquals((int)1, (int)partA);
        for (int aPartitions = 0; aPartitions < 100; ++aPartitions) {
            partitionInfo = builtInPartitionerA.peekCurrentPartitionInfo(testCluster);
            int anotherPartA = partitionInfo.partition();
            builtInPartitionerA.updatePartitionInfo(partitionInfo, 1, testCluster);
            Assertions.assertNotEquals((int)1, (int)anotherPartA);
            foundAnotherPartA = foundAnotherPartA || anotherPartA != partA;
        }
        Assertions.assertTrue((boolean)foundAnotherPartA, (String)("Expected to find partition other than " + partA));
        BuiltInPartitioner builtInPartitionerB = new BuiltInPartitioner(this.logContext, TOPIC_B, 1);
        partitionInfo = builtInPartitionerB.peekCurrentPartitionInfo(testCluster);
        int partB = partitionInfo.partition();
        builtInPartitionerB.updatePartitionInfo(partitionInfo, 1, testCluster);
        Assertions.assertEquals((int)1, (int)partB);
        for (int bPartitions = 0; bPartitions < 100; ++bPartitions) {
            partitionInfo = builtInPartitionerB.peekCurrentPartitionInfo(testCluster);
            Assertions.assertEquals((int)1, (int)partitionInfo.partition());
            builtInPartitionerB.updatePartitionInfo(partitionInfo, 1, testCluster);
        }
        BuiltInPartitioner builtInPartitionerC = new BuiltInPartitioner(this.logContext, TOPIC_C, 1);
        partitionInfo = builtInPartitionerC.peekCurrentPartitionInfo(testCluster);
        int partC = partitionInfo.partition();
        builtInPartitionerC.updatePartitionInfo(partitionInfo, 1, testCluster);
        Assertions.assertEquals((int)0, (int)partC);
        partitionInfo = builtInPartitionerC.peekCurrentPartitionInfo(testCluster);
        partC = partitionInfo.partition();
        Assertions.assertEquals((int)0, (int)partC);
    }

    @Test
    public void adaptivePartitionsTest() {
        int i;
        SequentialPartitioner builtInPartitioner = new SequentialPartitioner(this.logContext, TOPIC_A, 1);
        int[] queueSizes = new int[]{5, 0, 3, 0, 1};
        int[] partitionIds = new int[queueSizes.length];
        int[] expectedFrequencies = new int[queueSizes.length];
        ArrayList<PartitionInfo> allPartitions = new ArrayList<PartitionInfo>();
        for (int i2 = 0; i2 < partitionIds.length; ++i2) {
            partitionIds[i2] = i2;
            allPartitions.add(new PartitionInfo(TOPIC_A, i2, NODES[i2 % NODES.length], NODES, NODES));
            expectedFrequencies[i2] = 6 - queueSizes[i2];
        }
        builtInPartitioner.updatePartitionLoadStats(queueSizes, partitionIds, queueSizes.length);
        Cluster testCluster = new Cluster("clusterId", Arrays.asList(NODES), allPartitions, Collections.emptySet(), Collections.emptySet());
        int numberOfCycles = 2;
        int numberOfIterations = builtInPartitioner.loadStatsRangeEnd() * 2;
        int[] frequencies = new int[queueSizes.length];
        for (i = 0; i < numberOfIterations; ++i) {
            BuiltInPartitioner.StickyPartitionInfo partitionInfo = builtInPartitioner.peekCurrentPartitionInfo(testCluster);
            int n = partitionInfo.partition();
            frequencies[n] = frequencies[n] + 1;
            builtInPartitioner.updatePartitionInfo(partitionInfo, 1, testCluster);
        }
        for (i = 0; i < frequencies.length; ++i) {
            Assertions.assertEquals((int)(expectedFrequencies[i] * 2), (int)frequencies[i], (String)("Partition " + i + " was chosen " + frequencies[i] + " times"));
        }
    }

    @Test
    void testStickyBatchSizeMoreThatZero() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BuiltInPartitioner(this.logContext, TOPIC_A, 0));
        Assertions.assertDoesNotThrow(() -> new BuiltInPartitioner(this.logContext, TOPIC_A, 1));
    }

    private static class SequentialPartitioner
    extends BuiltInPartitioner {
        AtomicInteger mockRandom = new AtomicInteger();

        public SequentialPartitioner(LogContext logContext, String topic, int stickyBatchSize) {
            super(logContext, topic, stickyBatchSize);
        }

        int randomPartition() {
            return this.mockRandom.getAndAdd(1);
        }
    }
}

