/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.clients.consumer.AcknowledgeType;
import org.apache.kafka.clients.consumer.AcknowledgementCommitCallback;
import org.apache.kafka.clients.consumer.internals.AcknowledgementCommitCallbackHandler;
import org.apache.kafka.clients.consumer.internals.Acknowledgements;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidRecordStateException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class AcknowledgementCommitCallbackHandlerTest {
    private AcknowledgementCommitCallbackHandler acknowledgementCommitCallbackHandler;
    private Map<TopicPartitionAndOffset, Exception> exceptionMap;
    private final TopicPartition tp0 = new TopicPartition("test-topic", 0);
    private final TopicIdPartition tip0 = new TopicIdPartition(Uuid.randomUuid(), this.tp0);
    private final TopicPartitionAndOffset tpo00 = new TopicPartitionAndOffset(this.tip0, 0L);
    private final TopicPartitionAndOffset tpo01 = new TopicPartitionAndOffset(this.tip0, 1L);
    private final TopicPartition tp1 = new TopicPartition("test-topic-2", 0);
    private final TopicIdPartition tip1 = new TopicIdPartition(Uuid.randomUuid(), this.tp1);
    private final TopicPartitionAndOffset tpo10 = new TopicPartitionAndOffset(this.tip1, 0L);
    private final TopicPartition tp2 = new TopicPartition("test-topic-2", 1);
    private final TopicIdPartition tip2 = new TopicIdPartition(Uuid.randomUuid(), this.tp2);
    private final TopicPartitionAndOffset tpo20 = new TopicPartitionAndOffset(this.tip2, 0L);
    private Map<TopicIdPartition, Acknowledgements> acknowledgementsMap;

    AcknowledgementCommitCallbackHandlerTest() {
    }

    @BeforeEach
    public void setup() {
        this.acknowledgementsMap = new HashMap<TopicIdPartition, Acknowledgements>();
        this.exceptionMap = new LinkedHashMap<TopicPartitionAndOffset, Exception>();
        TestableAcknowledgeCommitCallback callback = new TestableAcknowledgeCommitCallback();
        this.acknowledgementCommitCallbackHandler = new AcknowledgementCommitCallbackHandler((AcknowledgementCommitCallback)callback);
    }

    @Test
    public void testNoException() throws Exception {
        Acknowledgements acknowledgements = Acknowledgements.empty();
        acknowledgements.add(0L, AcknowledgeType.ACCEPT);
        acknowledgements.add(1L, AcknowledgeType.REJECT);
        this.acknowledgementsMap.put(this.tip0, acknowledgements);
        this.acknowledgementCommitCallbackHandler.onComplete(Collections.singletonList(this.acknowledgementsMap));
        TestUtils.retryOnExceptionWithTimeout(() -> {
            Assertions.assertNull((Object)this.exceptionMap.get(this.tpo00));
            Assertions.assertNull((Object)this.exceptionMap.get(this.tpo01));
        });
    }

    @Test
    public void testInvalidRecord() throws Exception {
        Acknowledgements acknowledgements = Acknowledgements.empty();
        acknowledgements.add(0L, AcknowledgeType.ACCEPT);
        acknowledgements.add(1L, AcknowledgeType.REJECT);
        acknowledgements.setAcknowledgeErrorCode(Errors.INVALID_RECORD_STATE);
        this.acknowledgementsMap.put(this.tip0, acknowledgements);
        this.acknowledgementCommitCallbackHandler.onComplete(Collections.singletonList(this.acknowledgementsMap));
        TestUtils.retryOnExceptionWithTimeout(() -> {
            Assertions.assertInstanceOf(InvalidRecordStateException.class, (Object)this.exceptionMap.get(this.tpo00));
            Assertions.assertInstanceOf(InvalidRecordStateException.class, (Object)this.exceptionMap.get(this.tpo01));
        });
    }

    @Test
    public void testUnauthorizedTopic() throws Exception {
        Acknowledgements acknowledgements = Acknowledgements.empty();
        acknowledgements.add(0L, AcknowledgeType.ACCEPT);
        acknowledgements.add(1L, AcknowledgeType.REJECT);
        acknowledgements.setAcknowledgeErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED);
        this.acknowledgementsMap.put(this.tip0, acknowledgements);
        this.acknowledgementCommitCallbackHandler.onComplete(Collections.singletonList(this.acknowledgementsMap));
        TestUtils.retryOnExceptionWithTimeout(() -> {
            Assertions.assertInstanceOf(TopicAuthorizationException.class, (Object)this.exceptionMap.get(this.tpo00));
            Assertions.assertInstanceOf(TopicAuthorizationException.class, (Object)this.exceptionMap.get(this.tpo01));
        });
    }

    @Test
    public void testMultiplePartitions() throws Exception {
        Acknowledgements acknowledgements = Acknowledgements.empty();
        acknowledgements.add(0L, AcknowledgeType.ACCEPT);
        acknowledgements.add(1L, AcknowledgeType.REJECT);
        acknowledgements.setAcknowledgeErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED);
        this.acknowledgementsMap.put(this.tip0, acknowledgements);
        Acknowledgements acknowledgements1 = Acknowledgements.empty();
        acknowledgements1.add(0L, AcknowledgeType.RELEASE);
        acknowledgements1.setAcknowledgeErrorCode(Errors.INVALID_RECORD_STATE);
        this.acknowledgementsMap.put(this.tip1, acknowledgements1);
        HashMap<TopicIdPartition, Acknowledgements> acknowledgementsMap2 = new HashMap<TopicIdPartition, Acknowledgements>();
        Acknowledgements acknowledgements2 = Acknowledgements.empty();
        acknowledgements2.add(0L, AcknowledgeType.ACCEPT);
        acknowledgementsMap2.put(this.tip2, acknowledgements2);
        LinkedList<Map<TopicIdPartition, Acknowledgements>> acknowledgementsMapList = new LinkedList<Map<TopicIdPartition, Acknowledgements>>();
        acknowledgementsMapList.add(this.acknowledgementsMap);
        acknowledgementsMapList.add(acknowledgementsMap2);
        this.acknowledgementCommitCallbackHandler.onComplete(acknowledgementsMapList);
        TestUtils.retryOnExceptionWithTimeout(() -> {
            Assertions.assertInstanceOf(TopicAuthorizationException.class, (Object)this.exceptionMap.get(this.tpo00));
            Assertions.assertInstanceOf(TopicAuthorizationException.class, (Object)this.exceptionMap.get(this.tpo01));
            Assertions.assertInstanceOf(InvalidRecordStateException.class, (Object)this.exceptionMap.get(this.tpo10));
            Assertions.assertNull((Object)this.exceptionMap.get(this.tpo20));
        });
    }

    private static class TopicPartitionAndOffset {
        TopicIdPartition topicIdPartition;
        Long offset;

        TopicPartitionAndOffset(TopicIdPartition topicIdPartition, Long offset) {
            this.topicIdPartition = topicIdPartition;
            this.offset = offset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopicPartitionAndOffset that = (TopicPartitionAndOffset)o;
            return Objects.equals(this.topicIdPartition, that.topicIdPartition) && Objects.equals(this.offset, that.offset);
        }

        public int hashCode() {
            return Objects.hash(this.topicIdPartition, this.offset);
        }
    }

    private class TestableAcknowledgeCommitCallback
    implements AcknowledgementCommitCallback {
        private TestableAcknowledgeCommitCallback() {
        }

        public void onComplete(Map<TopicIdPartition, Set<Long>> offsetsMap, Exception exception) {
            offsetsMap.forEach((partition, offsets) -> offsets.forEach(offset -> {
                TopicPartitionAndOffset tpo = new TopicPartitionAndOffset((TopicIdPartition)partition, (Long)offset);
                AcknowledgementCommitCallbackHandlerTest.this.exceptionMap.put(tpo, exception);
            }));
        }
    }
}

