/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.internals.AdminBootstrapAddresses;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class AdminBootstrapAddressesTest {
    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testNoBootstrapSet(boolean nullValue) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (nullValue) {
            map.put("bootstrap.servers", null);
            map.put("bootstrap.controllers", null);
        } else {
            map.put("bootstrap.servers", "");
            map.put("bootstrap.controllers", "");
        }
        AdminClientConfig config = new AdminClientConfig(map);
        Assertions.assertEquals((Object)"You must set either bootstrap.servers or bootstrap.controllers", (Object)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> AdminBootstrapAddresses.fromConfig((AbstractConfig)config))).getMessage());
    }

    @Test
    public void testTwoBootstrapsSet() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bootstrap.controllers", "localhost:9092");
        map.put("bootstrap.servers", "localhost:9092");
        AdminClientConfig config = new AdminClientConfig(map);
        Assertions.assertEquals((Object)"You cannot set both bootstrap.servers and bootstrap.controllers", (Object)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> AdminBootstrapAddresses.fromConfig((AbstractConfig)config))).getMessage());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFromConfig(boolean usingBootstrapControllers) {
        HashMap<String, String> map = new HashMap<String, String>();
        String connectString = "localhost:9092,localhost:9093,localhost:9094";
        if (usingBootstrapControllers) {
            map.put("bootstrap.controllers", connectString);
        } else {
            map.put("bootstrap.servers", connectString);
        }
        AdminClientConfig config = new AdminClientConfig(map);
        AdminBootstrapAddresses addresses = AdminBootstrapAddresses.fromConfig((AbstractConfig)config);
        Assertions.assertEquals((Object)usingBootstrapControllers, (Object)addresses.usingBootstrapControllers());
        Assertions.assertEquals(Arrays.asList(new InetSocketAddress("localhost", 9092), new InetSocketAddress("localhost", 9093), new InetSocketAddress("localhost", 9094)), (Object)addresses.addresses());
    }
}

