/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.OffsetsForLeaderEpochClient;
import org.apache.kafka.clients.consumer.internals.OffsetsForLeaderEpochUtils;
import org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OffsetForLeaderEpochClientTest {
    private final TopicPartition tp0 = new TopicPartition("topic", 0);
    private ConsumerNetworkClient consumerClient;
    private MockClient client;

    @Test
    public void testEmptyResponse() {
        OffsetsForLeaderEpochClient offsetClient = this.newOffsetClient();
        RequestFuture future = offsetClient.sendAsyncRequest(Node.noNode(), Collections.emptyMap());
        OffsetsForLeaderEpochResponse resp = new OffsetsForLeaderEpochResponse(new OffsetForLeaderEpochResponseData());
        this.client.prepareResponse((AbstractResponse)resp);
        this.consumerClient.pollNoWakeup();
        OffsetsForLeaderEpochUtils.OffsetForEpochResult result = (OffsetsForLeaderEpochUtils.OffsetForEpochResult)future.value();
        Assertions.assertTrue((boolean)result.partitionsToRetry().isEmpty());
        Assertions.assertTrue((boolean)result.endOffsets().isEmpty());
    }

    @Test
    public void testUnexpectedEmptyResponse() {
        HashMap<TopicPartition, SubscriptionState.FetchPosition> positionMap = new HashMap<TopicPartition, SubscriptionState.FetchPosition>();
        positionMap.put(this.tp0, new SubscriptionState.FetchPosition(0L, Optional.of(1), new Metadata.LeaderAndEpoch(Optional.empty(), Optional.of(1))));
        OffsetsForLeaderEpochClient offsetClient = this.newOffsetClient();
        RequestFuture future = offsetClient.sendAsyncRequest(Node.noNode(), positionMap);
        OffsetsForLeaderEpochResponse resp = new OffsetsForLeaderEpochResponse(new OffsetForLeaderEpochResponseData());
        this.client.prepareResponse((AbstractResponse)resp);
        this.consumerClient.pollNoWakeup();
        OffsetsForLeaderEpochUtils.OffsetForEpochResult result = (OffsetsForLeaderEpochUtils.OffsetForEpochResult)future.value();
        Assertions.assertFalse((boolean)result.partitionsToRetry().isEmpty());
        Assertions.assertTrue((boolean)result.endOffsets().isEmpty());
    }

    @Test
    public void testOkResponse() {
        HashMap<TopicPartition, SubscriptionState.FetchPosition> positionMap = new HashMap<TopicPartition, SubscriptionState.FetchPosition>();
        positionMap.put(this.tp0, new SubscriptionState.FetchPosition(0L, Optional.of(1), new Metadata.LeaderAndEpoch(Optional.empty(), Optional.of(1))));
        OffsetsForLeaderEpochClient offsetClient = this.newOffsetClient();
        RequestFuture future = offsetClient.sendAsyncRequest(Node.noNode(), positionMap);
        this.client.prepareResponse((AbstractResponse)OffsetForLeaderEpochClientTest.prepareOffsetForLeaderEpochResponse(this.tp0, Errors.NONE, 1, 10L));
        this.consumerClient.pollNoWakeup();
        OffsetsForLeaderEpochUtils.OffsetForEpochResult result = (OffsetsForLeaderEpochUtils.OffsetForEpochResult)future.value();
        Assertions.assertTrue((boolean)result.partitionsToRetry().isEmpty());
        Assertions.assertTrue((boolean)result.endOffsets().containsKey(this.tp0));
        Assertions.assertEquals((short)((OffsetForLeaderEpochResponseData.EpochEndOffset)result.endOffsets().get(this.tp0)).errorCode(), (short)Errors.NONE.code());
        Assertions.assertEquals((int)((OffsetForLeaderEpochResponseData.EpochEndOffset)result.endOffsets().get(this.tp0)).leaderEpoch(), (int)1);
        Assertions.assertEquals((long)((OffsetForLeaderEpochResponseData.EpochEndOffset)result.endOffsets().get(this.tp0)).endOffset(), (long)10L);
    }

    @Test
    public void testUnauthorizedTopic() {
        HashMap<TopicPartition, SubscriptionState.FetchPosition> positionMap = new HashMap<TopicPartition, SubscriptionState.FetchPosition>();
        positionMap.put(this.tp0, new SubscriptionState.FetchPosition(0L, Optional.of(1), new Metadata.LeaderAndEpoch(Optional.empty(), Optional.of(1))));
        OffsetsForLeaderEpochClient offsetClient = this.newOffsetClient();
        RequestFuture future = offsetClient.sendAsyncRequest(Node.noNode(), positionMap);
        this.client.prepareResponse((AbstractResponse)OffsetForLeaderEpochClientTest.prepareOffsetForLeaderEpochResponse(this.tp0, Errors.TOPIC_AUTHORIZATION_FAILED, -1, -1L));
        this.consumerClient.pollNoWakeup();
        Assertions.assertTrue((boolean)future.failed());
        Assertions.assertEquals(future.exception().getClass(), TopicAuthorizationException.class);
        Assertions.assertTrue((boolean)((TopicAuthorizationException)((Object)future.exception())).unauthorizedTopics().contains(this.tp0.topic()));
    }

    @Test
    public void testRetriableError() {
        HashMap<TopicPartition, SubscriptionState.FetchPosition> positionMap = new HashMap<TopicPartition, SubscriptionState.FetchPosition>();
        positionMap.put(this.tp0, new SubscriptionState.FetchPosition(0L, Optional.of(1), new Metadata.LeaderAndEpoch(Optional.empty(), Optional.of(1))));
        OffsetsForLeaderEpochClient offsetClient = this.newOffsetClient();
        RequestFuture future = offsetClient.sendAsyncRequest(Node.noNode(), positionMap);
        this.client.prepareResponse((AbstractResponse)OffsetForLeaderEpochClientTest.prepareOffsetForLeaderEpochResponse(this.tp0, Errors.LEADER_NOT_AVAILABLE, -1, -1L));
        this.consumerClient.pollNoWakeup();
        Assertions.assertFalse((boolean)future.failed());
        OffsetsForLeaderEpochUtils.OffsetForEpochResult result = (OffsetsForLeaderEpochUtils.OffsetForEpochResult)future.value();
        Assertions.assertTrue((boolean)result.partitionsToRetry().contains(this.tp0));
        Assertions.assertFalse((boolean)result.endOffsets().containsKey(this.tp0));
    }

    private OffsetsForLeaderEpochClient newOffsetClient() {
        this.buildDependencies(OffsetResetStrategy.EARLIEST);
        return new OffsetsForLeaderEpochClient(this.consumerClient, new LogContext());
    }

    private void buildDependencies(OffsetResetStrategy offsetResetStrategy) {
        LogContext logContext = new LogContext();
        MockTime time = new MockTime(1L);
        SubscriptionState subscriptions = new SubscriptionState(logContext, offsetResetStrategy);
        ConsumerMetadata metadata = new ConsumerMetadata(0L, 0L, Long.MAX_VALUE, false, false, subscriptions, logContext, new ClusterResourceListeners());
        this.client = new MockClient((Time)time, (Metadata)metadata);
        this.consumerClient = new ConsumerNetworkClient(logContext, (KafkaClient)this.client, (Metadata)metadata, (Time)time, 100L, 1000, Integer.MAX_VALUE);
    }

    private static OffsetsForLeaderEpochResponse prepareOffsetForLeaderEpochResponse(TopicPartition tp, Errors error, int leaderEpoch, long endOffset) {
        OffsetForLeaderEpochResponseData data = new OffsetForLeaderEpochResponseData();
        OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult topic = new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult().setTopic(tp.topic());
        data.topics().add((ImplicitLinkedHashCollection.Element)topic);
        topic.partitions().add(new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()).setLeaderEpoch(leaderEpoch).setEndOffset(endOffset));
        return new OffsetsForLeaderEpochResponse(data);
    }
}

