/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.message.UpdateMetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.FlattenedIterator;
import org.apache.kafka.common.utils.Utils;

public class UpdateMetadataRequest
extends AbstractControlRequest {
    private final UpdateMetadataRequestData data;

    UpdateMetadataRequest(UpdateMetadataRequestData data, short version) {
        super(ApiKeys.UPDATE_METADATA, version);
        this.data = data;
        this.normalize();
    }

    private void normalize() {
        if (this.version() < 3) {
            for (UpdateMetadataRequestData.UpdateMetadataBroker liveBroker : this.data.liveBrokers()) {
                if (this.version() == 0 && liveBroker.endpoints().isEmpty()) {
                    SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                    liveBroker.setEndpoints(Collections.singletonList(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(liveBroker.v0Host()).setPort(liveBroker.v0Port()).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol(securityProtocol).value())));
                    continue;
                }
                for (UpdateMetadataRequestData.UpdateMetadataEndpoint endpoint : liveBroker.endpoints()) {
                    if (!endpoint.listener().isEmpty()) continue;
                    endpoint.setListener(UpdateMetadataRequest.listenerNameFromSecurityProtocol(endpoint));
                }
            }
        }
        if (this.version() >= 5) {
            for (UpdateMetadataRequestData.UpdateMetadataTopicState topicState : this.data.topicStates()) {
                for (UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState : topicState.partitionStates()) {
                    partitionState.setTopicName(topicState.topicName());
                }
            }
        }
    }

    private static String listenerNameFromSecurityProtocol(UpdateMetadataRequestData.UpdateMetadataEndpoint endpoint) {
        SecurityProtocol securityProtocol = SecurityProtocol.forId(endpoint.securityProtocol());
        return ListenerName.forSecurityProtocol(securityProtocol).value();
    }

    @Override
    public int controllerId() {
        return this.data.controllerId();
    }

    @Override
    public boolean isKRaftController() {
        return this.data.isKRaftController();
    }

    public AbstractControlRequest.Type updateType() {
        return AbstractControlRequest.Type.fromByte(this.data.type());
    }

    @Override
    public int controllerEpoch() {
        return this.data.controllerEpoch();
    }

    @Override
    public long brokerEpoch() {
        return this.data.brokerEpoch();
    }

    @Override
    public UpdateMetadataResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        UpdateMetadataResponseData data = new UpdateMetadataResponseData().setErrorCode(Errors.forException(e).code());
        return new UpdateMetadataResponse(data);
    }

    public Iterable<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates() {
        if (this.version() >= 5) {
            return () -> new FlattenedIterator(this.data.topicStates().iterator(), topicState -> topicState.partitionStates().iterator());
        }
        return this.data.ungroupedPartitionStates();
    }

    public List<UpdateMetadataRequestData.UpdateMetadataTopicState> topicStates() {
        if (this.version() >= 5) {
            return this.data.topicStates();
        }
        return Collections.emptyList();
    }

    public MirrorTopicState mirrorTopicState(UpdateMetadataRequestData.UpdateMetadataTopicState topicState) {
        if (this.version() >= 8 && this.data.linkCoordinatorEnabled() && topicState.mirrorTopicMetadata().linkId() != Uuid.ZERO_UUID && topicState.clusterLinkNameForMirrorTopic() != null) {
            return new MirrorTopicState(topicState.mirrorTopicMetadata().state(), topicState.mirrorTopicMetadata().linkId(), topicState.clusterLinkNameForMirrorTopic(), topicState.mirrorTopicStateLastUpdateTimeMs(), topicState.sourceTopicIdForMirrorTopic(), topicState.linkLevelPauseForMirrorTopic(), topicState.topicLevelPauseForMirrorTopic(), topicState.mirrorTopicPreviousState(), topicState.mirrorTopicPromoted(), topicState.mirrorTopicStoppedLogEndOffsets(), topicState.mirrorTopicMirrorStartOffsets(), topicState.mirrorTopicError(), topicState.mirrorTopicNextState());
        }
        return null;
    }

    public List<UpdateMetadataRequestData.UpdateMetadataBrokerHealthState> brokerHealthStates() {
        if (this.version() >= 7) {
            return this.data.brokerHealth();
        }
        return Collections.emptyList();
    }

    public List<UpdateMetadataRequestData.UpdateMetadataBroker> liveBrokers() {
        return this.data.liveBrokers();
    }

    public List<UpdateMetadataRequestData.UpdateMetadataCell> cells() {
        return this.data.cells();
    }

    public boolean linkCoordinatorEnabled() {
        return this.data.linkCoordinatorEnabled();
    }

    @Override
    public UpdateMetadataRequestData data() {
        return this.data;
    }

    public static UpdateMetadataRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new UpdateMetadataRequest(new UpdateMetadataRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static Map<String, String> tagMapFromBrokerTagCollection(List<UpdateMetadataRequestData.Tag> tags) {
        return tags.stream().collect(Collectors.toMap(UpdateMetadataRequestData.Tag::name, UpdateMetadataRequestData.Tag::value));
    }

    public static List<UpdateMetadataRequestData.Tag> brokerTagCollectionFromTagMap(Map<String, String> tags) {
        ArrayList<UpdateMetadataRequestData.Tag> tagCollection = new ArrayList<UpdateMetadataRequestData.Tag>(tags.size());
        tags.forEach((name, value) -> tagCollection.add(new UpdateMetadataRequestData.Tag().setName((String)name).setValue((String)value)));
        return tagCollection;
    }

    public long partitionSize() {
        long size = 0L;
        Iterator<UpdateMetadataRequestData.UpdateMetadataPartitionState> it = this.partitionStates().iterator();
        while (it.hasNext()) {
            it.next();
            ++size;
        }
        return size;
    }

    public Iterable<UpdateMetadataRequestData.UpdateMetadataPartitionState> filterTopicPartitonsByString(String topicSubString) {
        ArrayList<UpdateMetadataRequestData.UpdateMetadataPartitionState> topicPartitons = new ArrayList<UpdateMetadataRequestData.UpdateMetadataPartitionState>();
        for (UpdateMetadataRequestData.UpdateMetadataPartitionState state : this.partitionStates()) {
            if (!state.topicName().contains(topicSubString)) continue;
            topicPartitons.add(state);
        }
        return topicPartitons;
    }

    public static class MirrorTopicState {
        private final String state;
        private final Uuid clusterLinkId;
        private final String clusterLinkName;
        private final long timeMs;
        private final Uuid sourceTopicId;
        private boolean linkLevelPause;
        private boolean topicLevelPause;
        private String previousState;
        private boolean promoted;
        private List<Long> stoppedLogEndOffsets;
        private List<Long> mirrorStartOffsets;
        private short mirrorTopicError;
        private String nextState;

        public MirrorTopicState(String state, Uuid clusterLinkId, String clusterLinkName, long timeMs, Uuid sourceTopicId) {
            this(state, clusterLinkId, clusterLinkName, timeMs, sourceTopicId, false, false, null, false, null, null, MirrorTopicError.NO_ERROR.code(), null);
        }

        public MirrorTopicState(String state, Uuid clusterLinkId, String clusterLinkName, long timeMs, Uuid sourceTopicId, boolean linkLevelPause, boolean topicLevelPause, String previousState, boolean promoted, List<Long> stoppedLogEndOffsets, List<Long> mirrorStartOffsets, short mirrorTopicError, String nextState) {
            this.state = state;
            this.clusterLinkId = clusterLinkId;
            this.clusterLinkName = clusterLinkName;
            this.timeMs = timeMs;
            this.sourceTopicId = sourceTopicId;
            this.linkLevelPause = linkLevelPause;
            this.topicLevelPause = topicLevelPause;
            this.previousState = previousState;
            this.promoted = promoted;
            this.stoppedLogEndOffsets = stoppedLogEndOffsets;
            this.mirrorStartOffsets = mirrorStartOffsets == null ? Collections.emptyList() : mirrorStartOffsets;
            this.mirrorTopicError = mirrorTopicError;
            this.nextState = nextState;
        }

        public MirrorTopicState setLinkLevelPause(boolean linkLevelPause) {
            this.linkLevelPause = linkLevelPause;
            return this;
        }

        public MirrorTopicState setTopicLevelPause(boolean topicLevelPause) {
            this.topicLevelPause = topicLevelPause;
            return this;
        }

        public MirrorTopicState setPreviousState(String previousState) {
            this.previousState = previousState;
            return this;
        }

        public MirrorTopicState setPromoted(boolean promoted) {
            this.promoted = promoted;
            return this;
        }

        public MirrorTopicState setStoppedLogEndOffsets(List<Long> stoppedLogEndOffsets) {
            this.stoppedLogEndOffsets = stoppedLogEndOffsets;
            return this;
        }

        public MirrorTopicState setMirrorStartOffsets(List<Long> mirrorStartOffsets) {
            this.mirrorStartOffsets = mirrorStartOffsets == null ? Collections.emptyList() : mirrorStartOffsets;
            return this;
        }

        public MirrorTopicState setMirrorTopicError(short error) {
            this.mirrorTopicError = error;
            return this;
        }

        public MirrorTopicState setNextState(String nextState) {
            this.nextState = nextState;
            return this;
        }

        public String state() {
            return this.state;
        }

        public Uuid clusterLinkId() {
            return this.clusterLinkId;
        }

        public String clusterLinkName() {
            return this.clusterLinkName;
        }

        public long timeMs() {
            return this.timeMs;
        }

        public Uuid sourceTopicId() {
            return this.sourceTopicId;
        }

        public boolean linkLevelPause() {
            return this.linkLevelPause;
        }

        public boolean topicLevelPause() {
            return this.topicLevelPause;
        }

        public String previousState() {
            return this.previousState;
        }

        public boolean promoted() {
            return this.promoted;
        }

        public List<Long> stoppedLogEndOffsets() {
            return this.stoppedLogEndOffsets;
        }

        public List<Long> mirrorStartOffsets() {
            return this.mirrorStartOffsets;
        }

        public short mirrorTopicError() {
            return this.mirrorTopicError;
        }

        public String nextState() {
            return this.nextState;
        }
    }

    public static class Builder
    extends AbstractControlRequest.Builder<UpdateMetadataRequest> {
        private final List<UpdateMetadataRequestData.UpdateMetadataBrokerHealthState> brokerHealthStates;
        private final List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates;
        private final List<UpdateMetadataRequestData.UpdateMetadataBroker> liveBrokers;
        private final Map<String, Uuid> topicIds;
        private final Map<String, MirrorTopicState> mirrorTopicsMetadata;
        private final boolean linkCoordinatorEnabled;
        private final AbstractControlRequest.Type updateType;
        private final List<UpdateMetadataRequestData.UpdateMetadataCell> cells;

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, List<UpdateMetadataRequestData.UpdateMetadataBrokerHealthState> brokerHealthStates, List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates, List<UpdateMetadataRequestData.UpdateMetadataBroker> liveBrokers, Map<String, Uuid> topicIds, List<UpdateMetadataRequestData.UpdateMetadataCell> cells, boolean kraftController) {
            this(version, controllerId, controllerEpoch, brokerEpoch, brokerHealthStates, partitionStates, liveBrokers, topicIds, Collections.emptyMap(), false, cells, kraftController, AbstractControlRequest.Type.UNKNOWN, System.currentTimeMillis());
        }

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, List<UpdateMetadataRequestData.UpdateMetadataBrokerHealthState> brokerHealthStates, List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates, List<UpdateMetadataRequestData.UpdateMetadataBroker> liveBrokers, Map<String, Uuid> topicIds, List<UpdateMetadataRequestData.UpdateMetadataCell> cells, boolean kraftController, long timestamp) {
            this(version, controllerId, controllerEpoch, brokerEpoch, brokerHealthStates, partitionStates, liveBrokers, topicIds, Collections.emptyMap(), false, cells, kraftController, AbstractControlRequest.Type.UNKNOWN, timestamp);
        }

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, List<UpdateMetadataRequestData.UpdateMetadataBrokerHealthState> brokerHealthStates, List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates, List<UpdateMetadataRequestData.UpdateMetadataBroker> liveBrokers, Map<String, Uuid> topicIds, Map<String, MirrorTopicState> mirrorTopicsMetadata, boolean linkCoordinatorEnabled, List<UpdateMetadataRequestData.UpdateMetadataCell> cells, boolean kraftController, AbstractControlRequest.Type updateType) {
            this(version, controllerId, controllerEpoch, brokerEpoch, brokerHealthStates, partitionStates, liveBrokers, topicIds, mirrorTopicsMetadata, linkCoordinatorEnabled, cells, kraftController, updateType, System.currentTimeMillis());
        }

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, List<UpdateMetadataRequestData.UpdateMetadataBrokerHealthState> brokerHealthStates, List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates, List<UpdateMetadataRequestData.UpdateMetadataBroker> liveBrokers, Map<String, Uuid> topicIds, Map<String, MirrorTopicState> mirrorTopicsMetadata, boolean linkCoordinatorEnabled, List<UpdateMetadataRequestData.UpdateMetadataCell> cells, boolean kraftController, AbstractControlRequest.Type updateType, long timestamp) {
            super(ApiKeys.UPDATE_METADATA, version, controllerId, controllerEpoch, brokerEpoch, kraftController, timestamp);
            this.partitionStates = partitionStates;
            this.liveBrokers = liveBrokers;
            this.topicIds = topicIds;
            this.cells = cells;
            this.mirrorTopicsMetadata = mirrorTopicsMetadata;
            this.linkCoordinatorEnabled = linkCoordinatorEnabled;
            this.brokerHealthStates = version >= 7 ? brokerHealthStates : Collections.emptyList();
            this.updateType = version >= 8 ? updateType : AbstractControlRequest.Type.UNKNOWN;
        }

        @Override
        public UpdateMetadataRequest build(short version) {
            if (version < 3) {
                for (UpdateMetadataRequestData.UpdateMetadataBroker broker : this.liveBrokers) {
                    if (version == 0) {
                        if (broker.endpoints().size() != 1) {
                            throw new UnsupportedVersionException("UpdateMetadataRequest v0 requires a single endpoint");
                        }
                        if (broker.endpoints().get(0).securityProtocol() != SecurityProtocol.PLAINTEXT.id) {
                            throw new UnsupportedVersionException("UpdateMetadataRequest v0 only handles PLAINTEXT endpoints");
                        }
                        UpdateMetadataRequestData.UpdateMetadataEndpoint endpoint2 = broker.endpoints().get(0);
                        broker.setV0Host(endpoint2.host());
                        broker.setV0Port(endpoint2.port());
                        continue;
                    }
                    if (!broker.endpoints().stream().anyMatch(endpoint -> !endpoint.listener().isEmpty() && !endpoint.listener().equals(UpdateMetadataRequest.listenerNameFromSecurityProtocol(endpoint)))) continue;
                    throw new UnsupportedVersionException("UpdateMetadataRequest v0-v3 does not support custom listeners, request version: " + version + ", endpoints: " + broker.endpoints());
                }
            }
            UpdateMetadataRequestData data = new UpdateMetadataRequestData().setControllerId(this.controllerId).setControllerEpoch(this.controllerEpoch).setBrokerEpoch(this.brokerEpoch).setLiveBrokers(this.liveBrokers).setTimestamp(this.timestamp);
            if (version >= 8) {
                data.setIsKRaftController(this.kraftController);
                data.setType(this.updateType.toByte());
            }
            if (version >= 5) {
                Map<String, UpdateMetadataRequestData.UpdateMetadataTopicState> topicStatesMap = Builder.groupByTopic(version, this.topicIds, this.partitionStates, this.mirrorTopicsMetadata);
                data.setTopicStates(new ArrayList<UpdateMetadataRequestData.UpdateMetadataTopicState>(topicStatesMap.values()));
            } else {
                data.setUngroupedPartitionStates(this.partitionStates);
            }
            if (version >= 7) {
                data.setBrokerHealth(this.brokerHealthStates);
                data.setCells(this.cells);
                data.setLinkCoordinatorEnabled(this.linkCoordinatorEnabled);
            }
            if (version >= 8) {
                data.setIsKRaftController(this.kraftController);
            }
            return new UpdateMetadataRequest(data, version);
        }

        private static Map<String, UpdateMetadataRequestData.UpdateMetadataTopicState> groupByTopic(short version, Map<String, Uuid> topicIds, List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates, Map<String, MirrorTopicState> mirrorTopicsMetadata) {
            HashMap<String, UpdateMetadataRequestData.UpdateMetadataTopicState> topicStates = new HashMap<String, UpdateMetadataRequestData.UpdateMetadataTopicState>();
            for (UpdateMetadataRequestData.UpdateMetadataPartitionState partition : partitionStates) {
                UpdateMetadataRequestData.UpdateMetadataTopicState topicState = topicStates.computeIfAbsent(partition.topicName(), t -> new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName(partition.topicName()).setTopicId(topicIds.getOrDefault(partition.topicName(), Uuid.ZERO_UUID)));
                topicState.partitionStates().add(partition);
                MirrorTopicState mirrorTopicState = mirrorTopicsMetadata.get(partition.topicName());
                if (version < 8 || mirrorTopicState == null) continue;
                topicState.setMirrorTopicMetadata(new UpdateMetadataRequestData.MirrorTopicMetadata().setState(mirrorTopicState.state()).setLinkId(mirrorTopicState.clusterLinkId())).setClusterLinkNameForMirrorTopic(mirrorTopicState.clusterLinkName()).setMirrorTopicStateLastUpdateTimeMs(mirrorTopicState.timeMs()).setSourceTopicIdForMirrorTopic(mirrorTopicState.sourceTopicId()).setLinkLevelPauseForMirrorTopic(mirrorTopicState.linkLevelPause()).setTopicLevelPauseForMirrorTopic(mirrorTopicState.topicLevelPause()).setMirrorTopicPreviousState(mirrorTopicState.previousState()).setMirrorTopicPromoted(mirrorTopicState.promoted()).setMirrorTopicStoppedLogEndOffsets(mirrorTopicState.stoppedLogEndOffsets()).setMirrorTopicMirrorStartOffsets(mirrorTopicState.mirrorStartOffsets()).setMirrorTopicError(mirrorTopicState.mirrorTopicError()).setMirrorTopicNextState(mirrorTopicState.nextState());
            }
            return topicStates;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type: UpdateMetadataRequest=").append(", controllerId=").append(this.controllerId).append(", controllerEpoch=").append(this.controllerEpoch).append(", kraftController=").append(this.kraftController).append(", type=").append((Object)this.updateType).append(", brokerEpoch=").append(this.brokerEpoch).append(", partitionStates=").append(this.partitionStates).append(", liveBrokers=").append(Utils.join(this.liveBrokers, ", ")).append(")");
            return bld.toString();
        }
    }
}

