/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;

public class IncrementalAlterConfigsRequest
extends AbstractRequest {
    private final IncrementalAlterConfigsRequestData data;
    private final short version;

    public IncrementalAlterConfigsRequest(IncrementalAlterConfigsRequestData data, short version) {
        super(ApiKeys.INCREMENTAL_ALTER_CONFIGS, version);
        this.data = data;
        this.version = version;
    }

    public static IncrementalAlterConfigsRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new IncrementalAlterConfigsRequest(new IncrementalAlterConfigsRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    @Override
    public IncrementalAlterConfigsRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        IncrementalAlterConfigsResponseData response = new IncrementalAlterConfigsResponseData();
        ApiError apiError = ApiError.fromThrowable(e);
        for (IncrementalAlterConfigsRequestData.AlterConfigsResource resource : this.data.resources()) {
            response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName(resource.resourceName()).setResourceType(resource.resourceType()).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()));
        }
        return new IncrementalAlterConfigsResponse(response);
    }

    public static class Builder
    extends AbstractRequest.Builder<IncrementalAlterConfigsRequest> {
        private final IncrementalAlterConfigsRequestData data;

        public Builder(IncrementalAlterConfigsRequestData data) {
            super(ApiKeys.INCREMENTAL_ALTER_CONFIGS);
            this.data = data;
        }

        public Builder(Collection<ConfigResource> resources, Map<ConfigResource, Collection<AlterConfigOp>> configs, boolean validateOnly, boolean skipMirrorTopicConfigValidation) {
            super(ApiKeys.INCREMENTAL_ALTER_CONFIGS);
            this.data = new IncrementalAlterConfigsRequestData().setValidateOnly(validateOnly).setSkipMirrorTopicConfigValidation(skipMirrorTopicConfigValidation);
            for (ConfigResource resource : resources) {
                IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigSet = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
                for (AlterConfigOp configEntry : configs.get(resource)) {
                    alterableConfigSet.add(new IncrementalAlterConfigsRequestData.AlterableConfig().setName(configEntry.configEntry().name()).setValue(configEntry.configEntry().value()).setConfigOperation(configEntry.opType().id()));
                }
                IncrementalAlterConfigsRequestData.AlterConfigsResource alterConfigsResource = new IncrementalAlterConfigsRequestData.AlterConfigsResource();
                alterConfigsResource.setResourceType(resource.type().id()).setResourceName(resource.name()).setConfigs(alterableConfigSet);
                this.data.resources().add(alterConfigsResource);
            }
        }

        public Builder(Collection<ConfigResource> resources, Map<ConfigResource, Collection<AlterConfigOp>> configs, boolean validateOnly) {
            this(resources, configs, validateOnly, false);
        }

        public Builder(Map<ConfigResource, Collection<AlterConfigOp>> configs, boolean validateOnly) {
            this(configs.keySet(), configs, validateOnly);
        }

        @Override
        public IncrementalAlterConfigsRequest build(short version) {
            return new IncrementalAlterConfigsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

