/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.message.DescribeClusterLinksRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeClusterLinksResponse;

public class DescribeClusterLinksRequest
extends AbstractRequest {
    private final DescribeClusterLinksRequestData data;

    public DescribeClusterLinksRequest(DescribeClusterLinksRequestData data, short version) {
        super(ApiKeys.DESCRIBE_CLUSTER_LINKS, version);
        this.data = data;
    }

    public Optional<List<String>> linkNames() {
        return Optional.ofNullable(this.data.linkNames());
    }

    public boolean includeTopics() {
        return this.data.includeTopics();
    }

    public int timeoutMs() {
        return this.data.timeoutMs();
    }

    @Override
    public DescribeClusterLinksResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new DescribeClusterLinksResponse(throttleTimeMs, e);
    }

    @Override
    public DescribeClusterLinksRequestData data() {
        return this.data;
    }

    public static DescribeClusterLinksRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeClusterLinksRequest(new DescribeClusterLinksRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeClusterLinksRequest> {
        private final DescribeClusterLinksRequestData data;

        public Builder(Optional<Collection<String>> linkNames, boolean includeTopics, int timeoutMs) {
            super(ApiKeys.DESCRIBE_CLUSTER_LINKS);
            this.data = new DescribeClusterLinksRequestData().setLinkNames(linkNames.map(names -> new ArrayList(names)).orElse(null)).setIncludeTopics(includeTopics).setTimeoutMs(timeoutMs);
        }

        @Override
        public DescribeClusterLinksRequest build(short version) {
            return new DescribeClusterLinksRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

