/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.message.AlterCellRequestData;
import org.apache.kafka.common.message.AlterCellResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterCellResponse;
import org.apache.kafka.common.requests.ApiError;

public class AlterCellRequest
extends AbstractRequest {
    private final AlterCellRequestData data;

    AlterCellRequest(AlterCellRequestData data, short version) {
        super(ApiKeys.ALTER_CELL, version);
        this.data = data;
    }

    @Override
    public AlterCellRequestData data() {
        return this.data;
    }

    public int cellId() {
        return this.data.cellId();
    }

    public byte state() {
        return this.data.state();
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable t) {
        ApiError apiError = ApiError.fromThrowable(t);
        return new AlterCellResponse(new AlterCellResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()));
    }

    public static AlterCellRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new AlterCellRequest(new AlterCellRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterCellRequest> {
        private final AlterCellRequestData data;

        public Builder() {
            super(ApiKeys.ALTER_CELL);
            this.data = new AlterCellRequestData();
        }

        public Builder(AlterCellRequestData data) {
            super(ApiKeys.ALTER_CELL);
            this.data = data;
        }

        public Builder setCellId(int id) {
            this.data.setCellId(id);
            return this;
        }

        public Builder setState(CellState state) {
            this.data.setState(state.code());
            return this;
        }

        @Override
        public AlterCellRequest build(short version) {
            return new AlterCellRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

