/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.replica;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.Confluent;

@Confluent
public class ReplicaStatus {
    private final int brokerId;
    private final boolean isLeader;
    private final boolean isObserver;
    private final boolean isIsrEligible;
    private final boolean isInIsr;
    private final boolean isCaughtUp;
    private final long logStartOffset;
    private final long logEndOffset;
    private final long lastCaughtUpTimeMs;
    private final long lastFetchTimeMs;
    private final Optional<String> linkName;
    private final Optional<MirrorInfo> mirrorInfo;

    public ReplicaStatus(int brokerId, boolean isLeader, boolean isObserver, boolean isIsrEligible, boolean isInIsr, boolean isCaughtUp, long logStartOffset, long logEndOffset, long lastCaughtUpTimeMs, long lastFetchTimeMs, Optional<String> linkName) {
        this(brokerId, isLeader, isObserver, isIsrEligible, isInIsr, isCaughtUp, logStartOffset, logEndOffset, lastCaughtUpTimeMs, lastFetchTimeMs, linkName, Optional.empty());
    }

    public ReplicaStatus(int brokerId, boolean isLeader, boolean isObserver, boolean isIsrEligible, boolean isInIsr, boolean isCaughtUp, long logStartOffset, long logEndOffset, long lastCaughtUpTimeMs, long lastFetchTimeMs, Optional<String> linkName, Optional<MirrorInfo> mirrorInfo) {
        this.brokerId = brokerId;
        this.isLeader = isLeader;
        this.isObserver = isObserver;
        this.isIsrEligible = isIsrEligible;
        this.isInIsr = isInIsr;
        this.isCaughtUp = isCaughtUp;
        this.logStartOffset = logStartOffset;
        this.logEndOffset = logEndOffset;
        this.lastCaughtUpTimeMs = lastCaughtUpTimeMs;
        this.lastFetchTimeMs = lastFetchTimeMs;
        this.linkName = Objects.requireNonNull(linkName);
        this.mirrorInfo = Objects.requireNonNull(mirrorInfo);
    }

    public ReplicaStatus duplicate(Optional<MirrorInfo> mirrorInfo) {
        return new ReplicaStatus(this.brokerId(), this.isLeader(), this.isObserver(), this.isIsrEligible(), this.isInIsr(), this.isCaughtUp(), this.logStartOffset(), this.logEndOffset(), this.lastCaughtUpTimeMs(), this.lastFetchTimeMs(), this.linkName(), mirrorInfo);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public boolean isObserver() {
        return this.isObserver;
    }

    public boolean isIsrEligible() {
        return this.isIsrEligible;
    }

    public boolean isInIsr() {
        return this.isInIsr;
    }

    public boolean isCaughtUp() {
        return this.isCaughtUp;
    }

    public long logStartOffset() {
        return this.logStartOffset;
    }

    public long logEndOffset() {
        return this.logEndOffset;
    }

    public long lastCaughtUpTimeMs() {
        return this.lastCaughtUpTimeMs;
    }

    public long lastFetchTimeMs() {
        return this.lastFetchTimeMs;
    }

    public Optional<String> linkName() {
        return this.linkName;
    }

    public Optional<MirrorInfo> mirrorInfo() {
        return this.mirrorInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaStatus that = (ReplicaStatus)o;
        return Objects.equals(this.brokerId, that.brokerId) && Objects.equals(this.isLeader, that.isLeader) && Objects.equals(this.isObserver, that.isObserver) && Objects.equals(this.isIsrEligible, that.isIsrEligible) && Objects.equals(this.isInIsr, that.isInIsr) && Objects.equals(this.isCaughtUp, that.isCaughtUp) && Objects.equals(this.logStartOffset, that.logStartOffset) && Objects.equals(this.logEndOffset, that.logEndOffset) && Objects.equals(this.lastCaughtUpTimeMs, that.lastCaughtUpTimeMs) && Objects.equals(this.lastFetchTimeMs, that.lastFetchTimeMs) && Objects.equals(this.linkName, that.linkName) && Objects.equals(this.mirrorInfo, that.mirrorInfo);
    }

    public int hashCode() {
        return Objects.hash(this.brokerId, this.isLeader, this.isObserver, this.isIsrEligible, this.isInIsr, this.isCaughtUp, this.logStartOffset, this.logEndOffset, this.lastCaughtUpTimeMs, this.lastFetchTimeMs, this.linkName, this.mirrorInfo);
    }

    public String toString() {
        return "ReplicaStatus(brokerId=" + this.brokerId + ", isLeader=" + this.isLeader + ", isObserver=" + this.isObserver + ", isIsrEligible=" + this.isIsrEligible + ", isInIsr=" + this.isInIsr + ", isCaughtUp=" + this.isCaughtUp + ", logStartOffset=" + this.logStartOffset + ", logEndOffset=" + this.logEndOffset + ", lastCaughtUpTimeMs=" + this.lastCaughtUpTimeMs + ", lastFetchTimeMs=" + this.lastFetchTimeMs + ", linkName=" + this.linkName + ", mirrorInfo=" + this.mirrorInfo + ')';
    }

    public static class MirrorInfo {
        private final State state;
        private final long lastFetchTimeMs;
        private final long lastFetchSourceHighWatermark;

        public MirrorInfo(State state, long lastFetchTimeMs, long lastFetchSourceHighWatermark) {
            this.state = Objects.requireNonNull(state);
            this.lastFetchTimeMs = lastFetchTimeMs;
            this.lastFetchSourceHighWatermark = lastFetchSourceHighWatermark;
        }

        public State state() {
            return this.state;
        }

        public long lastFetchTimeMs() {
            return this.lastFetchTimeMs;
        }

        public long lastFetchSourceHighWatermark() {
            return this.lastFetchSourceHighWatermark;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MirrorInfo that = (MirrorInfo)o;
            return Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.lastFetchTimeMs, that.lastFetchTimeMs) && Objects.equals(this.lastFetchSourceHighWatermark, that.lastFetchSourceHighWatermark);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.state, this.lastFetchTimeMs, this.lastFetchSourceHighWatermark});
        }

        public String toString() {
            return "MirrorInfo(state=" + (Object)((Object)this.state) + ", lastFetchTimeMs=" + this.lastFetchTimeMs + ", lastFetchSourceHighWatermark=" + this.lastFetchSourceHighWatermark + ')';
        }

        public static enum State {
            UNKNOWN,
            ACTIVE,
            PENDING_STOPPED,
            STOPPED,
            FAILED,
            PAUSED,
            SOURCE_TOPIC_AUTHORIZATION_FAILED,
            SOURCE_AUTHENTICATION_FAILED,
            SOURCE_UNAVAILABLE,
            NO_SOURCE_RECORDS,
            LINK_FAILED,
            PENDING_MIRROR,
            PENDING_SYNCHRONIZE,
            PENDING_REPAIR;

        }
    }
}

