/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.kafka.common.network.AbstractProxyProtocolEngine;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.utils.LogContext;

public class ProxyProtocolV1Engine
extends AbstractProxyProtocolEngine {
    private static final int MAX_LENGTH = 108;
    private static final String INVALID_PROTOCOL_HEADER = "Invalid Proxy Protocol Header.";
    private static final byte[] PROXY = "PROXY".getBytes(StandardCharsets.US_ASCII);
    private int byteCount;
    private final StringBuilder stringBuilder = new StringBuilder();
    private boolean carriageReturnSeen = false;
    private boolean proxyHeaderDetected = false;

    public ProxyProtocolV1Engine(Mode mode, LogContext logContext) {
        super(mode, logContext);
    }

    private IOException invalidProtocolHeaderException() {
        return this.invalidProtocolHeaderException("Protocol Header:" + this.stringBuilder);
    }

    @Override
    protected IOException invalidProtocolHeaderException(String s) {
        return new IOException("Invalid Proxy Protocol Header. " + s);
    }

    private void decodeProxyProtocol() throws IOException {
        if (this.proxyHeaderProcessed) {
            return;
        }
        String[] tokens = this.stringBuilder.toString().split(" ");
        if (tokens.length < 1 || !Arrays.equals(tokens[0].getBytes(StandardCharsets.US_ASCII), PROXY)) {
            throw this.invalidProtocolHeaderException();
        }
        switch (tokens[1]) {
            case "TCP4": {
                if (tokens.length == 6) {
                    this.sourceAddress = Inet4Address.getByName(tokens[2]);
                    break;
                }
                throw this.invalidProtocolHeaderException();
            }
            case "TCP6": {
                if (tokens.length == 6) {
                    this.sourceAddress = Inet6Address.getByName(tokens[2]);
                    break;
                }
                throw this.invalidProtocolHeaderException();
            }
            case "UNKNOWN": {
                break;
            }
            default: {
                throw this.invalidProtocolHeaderException();
            }
        }
        if (this.sourceAddress != null) {
            try {
                this.sourcePort = Integer.parseInt(tokens[4]);
            }
            catch (NumberFormatException e) {
                throw this.invalidProtocolHeaderException();
            }
        }
        this.proxyHeaderProcessed = true;
    }

    @Override
    public void processHeaders(ByteBuffer buf) throws IOException {
        if (!this.proxyHeaderDetected) {
            if (buf.remaining() < PROXY.length) {
                return;
            }
            for (byte proxyByte : PROXY) {
                byte bufferByte = buf.get();
                if (bufferByte != proxyByte) {
                    if (this.proxyProtocolFallbackEnabled) {
                        buf.position(0);
                        this.proxyHeaderProcessed = true;
                        return;
                    }
                    throw new IOException(INVALID_PROTOCOL_HEADER);
                }
                this.stringBuilder.append((char)bufferByte);
            }
            this.proxyHeaderDetected = true;
        }
        while (buf.hasRemaining()) {
            char c = (char)buf.get();
            if (this.carriageReturnSeen) {
                if (c == '\n') {
                    this.decodeProxyProtocol();
                    break;
                }
                throw new IOException(INVALID_PROTOCOL_HEADER);
            }
            if (c == '\r') {
                this.carriageReturnSeen = true;
            } else {
                this.stringBuilder.append(c);
            }
            if (this.byteCount++ != 108) continue;
            throw new IOException(INVALID_PROTOCOL_HEADER);
        }
    }

    @Override
    public byte[] emitHeaders(InetAddress destinationAddress, int destinationPort) throws IOException {
        this.validateAddresses(destinationAddress);
        this.validatePorts(destinationPort);
        String protocol = destinationAddress instanceof Inet4Address ? "TCP4" : "TCP6";
        String header = String.format("PROXY %s %s %s %d %d\r\n", protocol, this.sourceAddress.getHostAddress(), destinationAddress.getHostAddress(), this.sourcePort, destinationPort);
        this.log.debug("emitting PROXY header: {}", (Object)header);
        this.proxyHeaderProcessed = true;
        return header.getBytes(StandardCharsets.US_ASCII);
    }
}

