/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.stats;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.internals.MetricsUtils;

public class TokenBucket
implements MeasurableStat {
    private final TimeUnit unit;
    private double tokens;
    private long lastUpdateMs;
    private double maxReplenishedTime;

    public TokenBucket() {
        this(TimeUnit.SECONDS);
    }

    public TokenBucket(TimeUnit unit) {
        this(unit, Long.MAX_VALUE);
    }

    public TokenBucket(TimeUnit unit, long maxReplenishedTimeMs) {
        this.unit = unit;
        this.tokens = 0.0;
        this.lastUpdateMs = 0L;
        this.maxReplenishedTime = MetricsUtils.convert(maxReplenishedTimeMs, unit);
    }

    @Override
    public double measure(MetricConfig config, long timeMs) {
        if (config.quota() == null) {
            return 9.223372036854776E18;
        }
        double quota = config.quota().bound();
        double burst = this.burst(config);
        this.refill(quota, burst, timeMs);
        return this.tokens;
    }

    @Override
    public void record(MetricConfig config, double value, long timeMs) {
        if (config.quota() == null) {
            return;
        }
        double quota = config.quota().bound();
        double burst = this.burst(config);
        this.refill(quota, burst, timeMs);
        double newTokens = Math.min(burst, this.tokens - value);
        if (newTokens < 0.0 && quota > 0.0) {
            newTokens = Math.max(newTokens, -1.0 * this.maxReplenishedTime * quota);
        }
        this.updateTokens(newTokens);
    }

    private void refill(double quota, double burst, long timeMs) {
        this.updateTokens(Math.min(burst, this.tokens + quota * MetricsUtils.convert(timeMs - this.lastUpdateMs, this.unit)));
        this.lastUpdateMs = timeMs;
    }

    protected void updateTokens(double tokens) {
        this.tokens = tokens;
    }

    private double burst(MetricConfig config) {
        return (double)config.samples() * MetricsUtils.convert(config.timeWindowMs(), this.unit) * config.quota().bound();
    }

    public String toString() {
        return "TokenBucket(unit=" + (Object)((Object)this.unit) + ", tokens=" + this.tokens + ", lastUpdateMs=" + this.lastUpdateMs + ')';
    }
}

