/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.stats;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.stats.TokenBucket;

public class MinTokenBucket
extends TokenBucket {
    private double minTokens;

    public MinTokenBucket(double minTokens) {
        super(TimeUnit.SECONDS);
        if (minTokens >= 0.0) {
            throw new IllegalArgumentException("minTokens must be negative");
        }
        this.minTokens = minTokens;
    }

    @Override
    protected void updateTokens(double tokens) {
        super.updateTokens(Math.max(this.minTokens, tokens));
    }
}

