/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class UpdateMetadataRequestData
implements ApiMessage {
    int controllerId;
    boolean isKRaftController;
    byte type;
    int controllerEpoch;
    long brokerEpoch;
    List<UpdateMetadataBrokerHealthState> brokerHealth;
    List<UpdateMetadataPartitionState> ungroupedPartitionStates;
    List<UpdateMetadataTopicState> topicStates;
    List<UpdateMetadataBroker> liveBrokers;
    boolean linkCoordinatorEnabled;
    List<UpdateMetadataCell> cells;
    long timestamp;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("ungrouped_partition_states", new ArrayOf(UpdateMetadataPartitionState.SCHEMA_0), "In older versions of this RPC, each partition that we would like to update."), new Field("live_brokers", new ArrayOf(UpdateMetadataBroker.SCHEMA_0), ""));
    public static final Schema SCHEMA_1 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("ungrouped_partition_states", new ArrayOf(UpdateMetadataPartitionState.SCHEMA_0), "In older versions of this RPC, each partition that we would like to update."), new Field("live_brokers", new ArrayOf(UpdateMetadataBroker.SCHEMA_1), ""));
    public static final Schema SCHEMA_2 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("ungrouped_partition_states", new ArrayOf(UpdateMetadataPartitionState.SCHEMA_0), "In older versions of this RPC, each partition that we would like to update."), new Field("live_brokers", new ArrayOf(UpdateMetadataBroker.SCHEMA_2), ""));
    public static final Schema SCHEMA_3 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("ungrouped_partition_states", new ArrayOf(UpdateMetadataPartitionState.SCHEMA_0), "In older versions of this RPC, each partition that we would like to update."), new Field("live_brokers", new ArrayOf(UpdateMetadataBroker.SCHEMA_3), ""));
    public static final Schema SCHEMA_4 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("ungrouped_partition_states", new ArrayOf(UpdateMetadataPartitionState.SCHEMA_4), "In older versions of this RPC, each partition that we would like to update."), new Field("live_brokers", new ArrayOf(UpdateMetadataBroker.SCHEMA_3), ""));
    public static final Schema SCHEMA_5 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("broker_epoch", Type.INT64, "The broker epoch."), new Field("topic_states", new ArrayOf(UpdateMetadataTopicState.SCHEMA_5), "In newer versions of this RPC, each topic that we would like to update."), new Field("live_brokers", new ArrayOf(UpdateMetadataBroker.SCHEMA_3), ""));
    public static final Schema SCHEMA_6 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("broker_epoch", Type.INT64, "The broker epoch."), new Field("topic_states", new CompactArrayOf(UpdateMetadataTopicState.SCHEMA_6), "In newer versions of this RPC, each topic that we would like to update."), new Field("live_brokers", new CompactArrayOf(UpdateMetadataBroker.SCHEMA_6), ""), Field.TaggedFieldsSection.of(10003, new Field("timestamp", Type.INT64, "The timestamp for the metadata change on the controller")));
    public static final Schema SCHEMA_7 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("broker_epoch", Type.INT64, "The broker epoch."), new Field("topic_states", new CompactArrayOf(UpdateMetadataTopicState.SCHEMA_7), "In newer versions of this RPC, each topic that we would like to update."), new Field("live_brokers", new CompactArrayOf(UpdateMetadataBroker.SCHEMA_6), ""), Field.TaggedFieldsSection.of(10000, new Field("broker_health", new CompactArrayOf(UpdateMetadataBrokerHealthState.SCHEMA_7), "In newer versions of this RPC, the broker's current health state that we would like to update."), 10001, new Field("link_coordinator_enabled", Type.BOOLEAN, ""), 10002, new Field("cells", new CompactArrayOf(UpdateMetadataCell.SCHEMA_7), "The list of cells and their information."), 10003, new Field("timestamp", Type.INT64, "The timestamp for the metadata change on the controller")));
    public static final Schema SCHEMA_8 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("is_kraft_controller", Type.BOOLEAN, "If KRaft controller id is used during migration. See KIP-866"), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("broker_epoch", Type.INT64, "The broker epoch."), new Field("topic_states", new CompactArrayOf(UpdateMetadataTopicState.SCHEMA_8), "In newer versions of this RPC, each topic that we would like to update."), new Field("live_brokers", new CompactArrayOf(UpdateMetadataBroker.SCHEMA_6), ""), Field.TaggedFieldsSection.of(0, new Field("type", Type.INT8, "Indicates if this request is a Full metadata snapshot (2), Incremental (1), or Unknown (0). Using during ZK migration, see KIP-866"), 10000, new Field("broker_health", new CompactArrayOf(UpdateMetadataBrokerHealthState.SCHEMA_7), "In newer versions of this RPC, the broker's current health state that we would like to update."), 10001, new Field("link_coordinator_enabled", Type.BOOLEAN, ""), 10002, new Field("cells", new CompactArrayOf(UpdateMetadataCell.SCHEMA_7), "The list of cells and their information."), 10003, new Field("timestamp", Type.INT64, "The timestamp for the metadata change on the controller")));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 8;

    public UpdateMetadataRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public UpdateMetadataRequestData() {
        this.controllerId = 0;
        this.isKRaftController = false;
        this.type = 0;
        this.controllerEpoch = 0;
        this.brokerEpoch = -1L;
        this.brokerHealth = new ArrayList<UpdateMetadataBrokerHealthState>(0);
        this.ungroupedPartitionStates = new ArrayList<UpdateMetadataPartitionState>(0);
        this.topicStates = new ArrayList<UpdateMetadataTopicState>(0);
        this.liveBrokers = new ArrayList<UpdateMetadataBroker>(0);
        this.linkCoordinatorEnabled = false;
        this.cells = new ArrayList<UpdateMetadataCell>(0);
        this.timestamp = 0L;
    }

    @Override
    public short apiKey() {
        return 6;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 8;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        ArrayList<UpdateMetadataPartitionState> newCollection;
        int arrayLength;
        this.controllerId = _readable.readInt();
        this.isKRaftController = _version >= 8 ? _readable.readByte() != 0 : false;
        this.type = 0;
        this.controllerEpoch = _readable.readInt();
        this.brokerEpoch = _version >= 5 ? _readable.readLong() : -1L;
        this.brokerHealth = new ArrayList<UpdateMetadataBrokerHealthState>(0);
        if (_version <= 4) {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field ungroupedPartitionStates was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<UpdateMetadataPartitionState>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new UpdateMetadataPartitionState(_readable, _version, _context));
            }
            this.ungroupedPartitionStates = newCollection;
        } else {
            this.ungroupedPartitionStates = new ArrayList<UpdateMetadataPartitionState>(0);
        }
        if (_version >= 5) {
            if (_version >= 6) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topicStates was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((UpdateMetadataPartitionState)((Object)new UpdateMetadataTopicState(_readable, _version, _context)));
                }
                this.topicStates = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topicStates was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((UpdateMetadataPartitionState)((Object)new UpdateMetadataTopicState(_readable, _version, _context)));
                }
                this.topicStates = newCollection;
            }
        } else {
            this.topicStates = new ArrayList<UpdateMetadataTopicState>(0);
        }
        if (_version >= 6) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field liveBrokers was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((UpdateMetadataPartitionState)((Object)new UpdateMetadataBroker(_readable, _version, _context)));
            }
            this.liveBrokers = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field liveBrokers was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((UpdateMetadataPartitionState)((Object)new UpdateMetadataBroker(_readable, _version, _context)));
            }
            this.liveBrokers = newCollection;
        }
        this.linkCoordinatorEnabled = false;
        this.cells = new ArrayList<UpdateMetadataCell>(0);
        this.timestamp = 0L;
        this._unknownTaggedFields = null;
        if (_version >= 6) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block12: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 0: {
                        if (_version >= 8) {
                            this.type = _readable.readByte();
                            continue block12;
                        }
                        throw new RuntimeException("Tag 0 is not valid for version " + _version);
                    }
                    case 10000: {
                        int i2;
                        ArrayList<UpdateMetadataBrokerHealthState> newCollection2;
                        int arrayLength2;
                        if (_version >= 7) {
                            arrayLength2 = _readable.readUnsignedVarint() - 1;
                            if (arrayLength2 < 0) {
                                throw new RuntimeException("non-nullable field brokerHealth was serialized as null");
                            }
                            if (arrayLength2 > _readable.remaining()) {
                                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                            }
                            newCollection2 = new ArrayList<UpdateMetadataBrokerHealthState>(arrayLength2);
                            for (i2 = 0; i2 < arrayLength2; ++i2) {
                                newCollection2.add(new UpdateMetadataBrokerHealthState(_readable, _version, _context));
                            }
                            this.brokerHealth = newCollection2;
                            continue block12;
                        }
                        throw new RuntimeException("Tag 10000 is not valid for version " + _version);
                    }
                    case 10001: {
                        if (_version >= 7) {
                            this.linkCoordinatorEnabled = _readable.readByte() != 0;
                            continue block12;
                        }
                        throw new RuntimeException("Tag 10001 is not valid for version " + _version);
                    }
                    case 10002: {
                        int i2;
                        ArrayList<UpdateMetadataBrokerHealthState> newCollection2;
                        int arrayLength2;
                        if (_version >= 7) {
                            arrayLength2 = _readable.readUnsignedVarint() - 1;
                            if (arrayLength2 < 0) {
                                throw new RuntimeException("non-nullable field cells was serialized as null");
                            }
                            if (arrayLength2 > _readable.remaining()) {
                                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                            }
                            newCollection2 = new ArrayList(arrayLength2);
                            for (i2 = 0; i2 < arrayLength2; ++i2) {
                                newCollection2.add((UpdateMetadataBrokerHealthState)((Object)new UpdateMetadataCell(_readable, _version, _context)));
                            }
                            this.cells = newCollection2;
                            continue block12;
                        }
                        throw new RuntimeException("Tag 10002 is not valid for version " + _version);
                    }
                    case 10003: {
                        this.timestamp = _readable.readLong();
                        continue block12;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.controllerId);
        if (_version >= 8) {
            _writable.writeByte(this.isKRaftController ? (byte)1 : 0);
        } else if (this.isKRaftController) {
            throw new UnsupportedVersionException("Attempted to write a non-default isKRaftController at version " + _version);
        }
        if (_version >= 8) {
            if (this.type != 0) {
                ++_numTaggedFields;
            }
        } else if (this.type != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default type at version " + _version);
        }
        _writable.writeInt(this.controllerEpoch);
        if (_version >= 5) {
            _writable.writeLong(this.brokerEpoch);
        }
        if (_version >= 7 && !this.brokerHealth.isEmpty()) {
            ++_numTaggedFields;
        }
        if (_version <= 4) {
            _writable.writeInt(this.ungroupedPartitionStates.size());
            for (UpdateMetadataPartitionState ungroupedPartitionStatesElement : this.ungroupedPartitionStates) {
                ungroupedPartitionStatesElement.write(_writable, _cache, _version, _context);
            }
        } else if (!this.ungroupedPartitionStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default ungroupedPartitionStates at version " + _version);
        }
        if (_version >= 5) {
            if (_version >= 6) {
                _writable.writeUnsignedVarint(this.topicStates.size() + 1);
                for (UpdateMetadataTopicState topicStatesElement : this.topicStates) {
                    topicStatesElement.write(_writable, _cache, _version, _context);
                }
            } else {
                _writable.writeInt(this.topicStates.size());
                for (UpdateMetadataTopicState topicStatesElement : this.topicStates) {
                    topicStatesElement.write(_writable, _cache, _version, _context);
                }
            }
        } else if (!this.topicStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default topicStates at version " + _version);
        }
        if (_version >= 6) {
            _writable.writeUnsignedVarint(this.liveBrokers.size() + 1);
            for (UpdateMetadataBroker liveBrokersElement : this.liveBrokers) {
                liveBrokersElement.write(_writable, _cache, _version, _context);
            }
        } else {
            _writable.writeInt(this.liveBrokers.size());
            for (UpdateMetadataBroker liveBrokersElement : this.liveBrokers) {
                liveBrokersElement.write(_writable, _cache, _version, _context);
            }
        }
        if (_version >= 7 && this.linkCoordinatorEnabled) {
            ++_numTaggedFields;
        }
        if (_version >= 7 && !this.cells.isEmpty()) {
            ++_numTaggedFields;
        }
        if (_version >= 6 && this.timestamp != 0L) {
            ++_numTaggedFields;
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 6) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            if (_version >= 8 && this.type != 0) {
                _writable.writeUnsignedVarint(0);
                _writable.writeUnsignedVarint(1);
                _writable.writeByte(this.type);
            }
            _rawWriter.writeRawTags(_writable, 10000);
            if (_version >= 7 && !this.brokerHealth.isEmpty()) {
                _writable.writeUnsignedVarint(10000);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.brokerHealth));
                _writable.writeUnsignedVarint(this.brokerHealth.size() + 1);
                for (UpdateMetadataBrokerHealthState brokerHealthElement : this.brokerHealth) {
                    brokerHealthElement.write(_writable, _cache, _version, _context);
                }
            }
            if (_version >= 7 && this.linkCoordinatorEnabled) {
                _writable.writeUnsignedVarint(10001);
                _writable.writeUnsignedVarint(1);
                _writable.writeByte(this.linkCoordinatorEnabled ? (byte)1 : 0);
            }
            if (_version >= 7 && !this.cells.isEmpty()) {
                _writable.writeUnsignedVarint(10002);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.cells));
                _writable.writeUnsignedVarint(this.cells.size() + 1);
                for (UpdateMetadataCell cellsElement : this.cells) {
                    cellsElement.write(_writable, _cache, _version, _context);
                }
            }
            if (this.timestamp != 0L) {
                _writable.writeUnsignedVarint(10003);
                _writable.writeUnsignedVarint(8);
                _writable.writeLong(this.timestamp);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        if (_version >= 8) {
            _size.addBytes(1);
        }
        if (_version >= 8 && this.type != 0) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        _size.addBytes(4);
        if (_version >= 5) {
            _size.addBytes(8);
        }
        if (_version >= 7 && !this.brokerHealth.isEmpty()) {
            ++_numTaggedFields;
            _size.addBytes(2);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.brokerHealth.size() + 1));
            for (UpdateMetadataBrokerHealthState brokerHealthElement : this.brokerHealth) {
                brokerHealthElement.addSize(_size, _cache, _version, _context);
            }
            int _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.brokerHealth, _arraySize);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
        }
        if (_version <= 4) {
            _size.addBytes(4);
            for (UpdateMetadataPartitionState ungroupedPartitionStatesElement : this.ungroupedPartitionStates) {
                ungroupedPartitionStatesElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (_version >= 5) {
            if (_version >= 6) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topicStates.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (UpdateMetadataTopicState topicStatesElement : this.topicStates) {
                topicStatesElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (_version >= 6) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.liveBrokers.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (UpdateMetadataBroker liveBrokersElement : this.liveBrokers) {
            liveBrokersElement.addSize(_size, _cache, _version, _context);
        }
        if (_version >= 7 && this.linkCoordinatorEnabled) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        if (_version >= 7 && !this.cells.isEmpty()) {
            ++_numTaggedFields;
            _size.addBytes(2);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.cells.size() + 1));
            for (UpdateMetadataCell cellsElement : this.cells) {
                cellsElement.addSize(_size, _cache, _version, _context);
            }
            int _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.cells, _arraySize);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
        }
        if (_version >= 6 && this.timestamp != 0L) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _size.addBytes(1);
            _size.addBytes(8);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 6) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UpdateMetadataRequestData)) {
            return false;
        }
        UpdateMetadataRequestData other = (UpdateMetadataRequestData)obj;
        if (this.controllerId != other.controllerId) {
            return false;
        }
        if (this.isKRaftController != other.isKRaftController) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.controllerEpoch != other.controllerEpoch) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.brokerHealth == null ? other.brokerHealth != null : !this.brokerHealth.equals(other.brokerHealth)) {
            return false;
        }
        if (this.ungroupedPartitionStates == null ? other.ungroupedPartitionStates != null : !this.ungroupedPartitionStates.equals(other.ungroupedPartitionStates)) {
            return false;
        }
        if (this.topicStates == null ? other.topicStates != null : !this.topicStates.equals(other.topicStates)) {
            return false;
        }
        if (this.liveBrokers == null ? other.liveBrokers != null : !this.liveBrokers.equals(other.liveBrokers)) {
            return false;
        }
        if (this.linkCoordinatorEnabled != other.linkCoordinatorEnabled) {
            return false;
        }
        if (this.cells == null ? other.cells != null : !this.cells.equals(other.cells)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.controllerId;
        hashCode = 31 * hashCode + (this.isKRaftController ? 1231 : 1237);
        hashCode = 31 * hashCode + this.type;
        hashCode = 31 * hashCode + this.controllerEpoch;
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode = 31 * hashCode + (this.brokerHealth == null ? 0 : this.brokerHealth.hashCode());
        hashCode = 31 * hashCode + (this.ungroupedPartitionStates == null ? 0 : this.ungroupedPartitionStates.hashCode());
        hashCode = 31 * hashCode + (this.topicStates == null ? 0 : this.topicStates.hashCode());
        hashCode = 31 * hashCode + (this.liveBrokers == null ? 0 : this.liveBrokers.hashCode());
        hashCode = 31 * hashCode + (this.linkCoordinatorEnabled ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.cells == null ? 0 : this.cells.hashCode());
        hashCode = 31 * hashCode + ((int)(this.timestamp >> 32) ^ (int)this.timestamp);
        return hashCode;
    }

    @Override
    public UpdateMetadataRequestData duplicate() {
        UpdateMetadataRequestData _duplicate = new UpdateMetadataRequestData();
        _duplicate.controllerId = this.controllerId;
        _duplicate.isKRaftController = this.isKRaftController;
        _duplicate.type = this.type;
        _duplicate.controllerEpoch = this.controllerEpoch;
        _duplicate.brokerEpoch = this.brokerEpoch;
        ArrayList<UpdateMetadataBrokerHealthState> newBrokerHealth = new ArrayList<UpdateMetadataBrokerHealthState>(this.brokerHealth.size());
        for (UpdateMetadataBrokerHealthState updateMetadataBrokerHealthState : this.brokerHealth) {
            newBrokerHealth.add(updateMetadataBrokerHealthState.duplicate());
        }
        _duplicate.brokerHealth = newBrokerHealth;
        ArrayList<UpdateMetadataPartitionState> newUngroupedPartitionStates = new ArrayList<UpdateMetadataPartitionState>(this.ungroupedPartitionStates.size());
        for (UpdateMetadataPartitionState updateMetadataPartitionState : this.ungroupedPartitionStates) {
            newUngroupedPartitionStates.add(updateMetadataPartitionState.duplicate());
        }
        _duplicate.ungroupedPartitionStates = newUngroupedPartitionStates;
        ArrayList<UpdateMetadataTopicState> arrayList = new ArrayList<UpdateMetadataTopicState>(this.topicStates.size());
        for (UpdateMetadataTopicState updateMetadataTopicState : this.topicStates) {
            arrayList.add(updateMetadataTopicState.duplicate());
        }
        _duplicate.topicStates = arrayList;
        ArrayList<UpdateMetadataBroker> arrayList2 = new ArrayList<UpdateMetadataBroker>(this.liveBrokers.size());
        for (UpdateMetadataBroker _element : this.liveBrokers) {
            arrayList2.add(_element.duplicate());
        }
        _duplicate.liveBrokers = arrayList2;
        _duplicate.linkCoordinatorEnabled = this.linkCoordinatorEnabled;
        ArrayList<UpdateMetadataCell> arrayList3 = new ArrayList<UpdateMetadataCell>(this.cells.size());
        for (UpdateMetadataCell _element : this.cells) {
            arrayList3.add(_element.duplicate());
        }
        _duplicate.cells = arrayList3;
        _duplicate.timestamp = this.timestamp;
        return _duplicate;
    }

    public String toString() {
        return "UpdateMetadataRequestData(controllerId=" + this.controllerId + ", isKRaftController=" + (this.isKRaftController ? "true" : "false") + ", type=" + this.type + ", controllerEpoch=" + this.controllerEpoch + ", brokerEpoch=" + this.brokerEpoch + ", brokerHealth=" + MessageUtil.deepToString(this.brokerHealth.iterator()) + ", ungroupedPartitionStates=" + MessageUtil.deepToString(this.ungroupedPartitionStates.iterator()) + ", topicStates=" + MessageUtil.deepToString(this.topicStates.iterator()) + ", liveBrokers=" + MessageUtil.deepToString(this.liveBrokers.iterator()) + ", linkCoordinatorEnabled=" + (this.linkCoordinatorEnabled ? "true" : "false") + ", cells=" + MessageUtil.deepToString(this.cells.iterator()) + ", timestamp=" + this.timestamp + ")";
    }

    public int controllerId() {
        return this.controllerId;
    }

    public boolean isKRaftController() {
        return this.isKRaftController;
    }

    public byte type() {
        return this.type;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public List<UpdateMetadataBrokerHealthState> brokerHealth() {
        return this.brokerHealth;
    }

    public List<UpdateMetadataPartitionState> ungroupedPartitionStates() {
        return this.ungroupedPartitionStates;
    }

    public List<UpdateMetadataTopicState> topicStates() {
        return this.topicStates;
    }

    public List<UpdateMetadataBroker> liveBrokers() {
        return this.liveBrokers;
    }

    public boolean linkCoordinatorEnabled() {
        return this.linkCoordinatorEnabled;
    }

    public List<UpdateMetadataCell> cells() {
        return this.cells;
    }

    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public UpdateMetadataRequestData setControllerId(int v) {
        this.controllerId = v;
        return this;
    }

    public UpdateMetadataRequestData setIsKRaftController(boolean v) {
        this.isKRaftController = v;
        return this;
    }

    public UpdateMetadataRequestData setType(byte v) {
        this.type = v;
        return this;
    }

    public UpdateMetadataRequestData setControllerEpoch(int v) {
        this.controllerEpoch = v;
        return this;
    }

    public UpdateMetadataRequestData setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public UpdateMetadataRequestData setBrokerHealth(List<UpdateMetadataBrokerHealthState> v) {
        this.brokerHealth = v;
        return this;
    }

    public UpdateMetadataRequestData setUngroupedPartitionStates(List<UpdateMetadataPartitionState> v) {
        this.ungroupedPartitionStates = v;
        return this;
    }

    public UpdateMetadataRequestData setTopicStates(List<UpdateMetadataTopicState> v) {
        this.topicStates = v;
        return this;
    }

    public UpdateMetadataRequestData setLiveBrokers(List<UpdateMetadataBroker> v) {
        this.liveBrokers = v;
        return this;
    }

    public UpdateMetadataRequestData setLinkCoordinatorEnabled(boolean v) {
        this.linkCoordinatorEnabled = v;
        return this;
    }

    public UpdateMetadataRequestData setCells(List<UpdateMetadataCell> v) {
        this.cells = v;
        return this;
    }

    public UpdateMetadataRequestData setTimestamp(long v) {
        this.timestamp = v;
        return this;
    }

    public static class UpdateMetadataPartitionState
    implements Message {
        String topicName;
        int partitionIndex;
        int controllerEpoch;
        int leader;
        int leaderEpoch;
        List<Integer> isr;
        int zkVersion;
        List<Integer> replicas;
        List<Integer> observers;
        List<Integer> offlineReplicas;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 8;

        public UpdateMetadataPartitionState(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public UpdateMetadataPartitionState() {
            this.topicName = "";
            this.partitionIndex = 0;
            this.controllerEpoch = 0;
            this.leader = 0;
            this.leaderEpoch = 0;
            this.isr = new ArrayList<Integer>(0);
            this.zkVersion = 0;
            this.replicas = new ArrayList<Integer>(0);
            this.observers = new ArrayList<Integer>(0);
            this.offlineReplicas = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            if (_version <= 4) {
                short length = _readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field topicName was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field topicName had invalid length " + length);
                }
                this.topicName = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            } else {
                this.topicName = "";
            }
            this.partitionIndex = _readable.readInt();
            this.controllerEpoch = _readable.readInt();
            this.leader = _readable.readInt();
            this.leaderEpoch = _readable.readInt();
            int arrayLength = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field isr was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.isr = newCollection;
            this.zkVersion = _readable.readInt();
            arrayLength = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field replicas was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.replicas = newCollection;
            this.observers = new ArrayList<Integer>(0);
            if (_version >= 4) {
                arrayLength = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field offlineReplicas was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readInt());
                }
                this.offlineReplicas = newCollection;
            } else {
                this.offlineReplicas = new ArrayList<Integer>(0);
            }
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                block6: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        case 10000: {
                            int arrayLength2 = _readable.readUnsignedVarint() - 1;
                            if (arrayLength2 < 0) {
                                throw new RuntimeException("non-nullable field observers was serialized as null");
                            }
                            if (arrayLength2 > _readable.remaining()) {
                                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                            }
                            ArrayList<Integer> newCollection2 = new ArrayList<Integer>(arrayLength2);
                            for (int i2 = 0; i2 < arrayLength2; ++i2) {
                                newCollection2.add(_readable.readInt());
                            }
                            this.observers = newCollection2;
                            continue block6;
                        }
                        default: {
                            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        }
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            if (_version <= 4) {
                _stringBytes = _cache.getSerializedValue(this.topicName);
                _writable.writeShort((short)((byte[])_stringBytes).length);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            _writable.writeInt(this.partitionIndex);
            _writable.writeInt(this.controllerEpoch);
            _writable.writeInt(this.leader);
            _writable.writeInt(this.leaderEpoch);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(this.isr.size() + 1);
            } else {
                _writable.writeInt(this.isr.size());
            }
            _stringBytes = this.isr.iterator();
            while (_stringBytes.hasNext()) {
                Integer isrElement = (Integer)_stringBytes.next();
                _writable.writeInt(isrElement);
            }
            _writable.writeInt(this.zkVersion);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(this.replicas.size() + 1);
            } else {
                _writable.writeInt(this.replicas.size());
            }
            for (Integer replicasElement : this.replicas) {
                _writable.writeInt(replicasElement);
            }
            if (_version >= 6 && !this.observers.isEmpty()) {
                ++_numTaggedFields;
            }
            if (_version >= 4) {
                if (_version >= 6) {
                    _writable.writeUnsignedVarint(this.offlineReplicas.size() + 1);
                } else {
                    _writable.writeInt(this.offlineReplicas.size());
                }
                for (Integer offlineReplicasElement : this.offlineReplicas) {
                    _writable.writeInt(offlineReplicasElement);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, 10000);
                if (!this.observers.isEmpty()) {
                    _writable.writeUnsignedVarint(10000);
                    _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.observers));
                    _writable.writeUnsignedVarint(this.observers.size() + 1);
                    for (Integer observersElement : this.observers) {
                        _writable.writeInt(observersElement);
                    }
                }
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version <= 4) {
                byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topicName).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'topicName' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.topicName, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(4);
            if (_version >= 6) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.isr.size() + 1));
            } else {
                _size.addBytes(4);
            }
            _size.addBytes(this.isr.size() * 4);
            _size.addBytes(4);
            if (_version >= 6) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.replicas.size() + 1));
            } else {
                _size.addBytes(4);
            }
            _size.addBytes(this.replicas.size() * 4);
            if (_version >= 6 && !this.observers.isEmpty()) {
                ++_numTaggedFields;
                _size.addBytes(2);
                int _sizeBeforeArray = _size.totalSize();
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.observers.size() + 1));
                _size.addBytes(this.observers.size() * 4);
                int _arraySize = _size.totalSize() - _sizeBeforeArray;
                _cache.setArraySizeInBytes(this.observers, _arraySize);
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
            }
            if (_version >= 4) {
                if (_version >= 6) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.offlineReplicas.size() + 1));
                } else {
                    _size.addBytes(4);
                }
                _size.addBytes(this.offlineReplicas.size() * 4);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 6) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdateMetadataPartitionState)) {
                return false;
            }
            UpdateMetadataPartitionState other = (UpdateMetadataPartitionState)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.controllerEpoch != other.controllerEpoch) {
                return false;
            }
            if (this.leader != other.leader) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.isr == null ? other.isr != null : !this.isr.equals(other.isr)) {
                return false;
            }
            if (this.zkVersion != other.zkVersion) {
                return false;
            }
            if (this.replicas == null ? other.replicas != null : !this.replicas.equals(other.replicas)) {
                return false;
            }
            if (this.observers == null ? other.observers != null : !this.observers.equals(other.observers)) {
                return false;
            }
            if (this.offlineReplicas == null ? other.offlineReplicas != null : !this.offlineReplicas.equals(other.offlineReplicas)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.controllerEpoch;
            hashCode = 31 * hashCode + this.leader;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + (this.isr == null ? 0 : this.isr.hashCode());
            hashCode = 31 * hashCode + this.zkVersion;
            hashCode = 31 * hashCode + (this.replicas == null ? 0 : this.replicas.hashCode());
            hashCode = 31 * hashCode + (this.observers == null ? 0 : this.observers.hashCode());
            hashCode = 31 * hashCode + (this.offlineReplicas == null ? 0 : this.offlineReplicas.hashCode());
            return hashCode;
        }

        @Override
        public UpdateMetadataPartitionState duplicate() {
            UpdateMetadataPartitionState _duplicate = new UpdateMetadataPartitionState();
            _duplicate.topicName = this.topicName;
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.controllerEpoch = this.controllerEpoch;
            _duplicate.leader = this.leader;
            _duplicate.leaderEpoch = this.leaderEpoch;
            ArrayList<Integer> newIsr = new ArrayList<Integer>(this.isr.size());
            for (Integer n : this.isr) {
                newIsr.add(n);
            }
            _duplicate.isr = newIsr;
            _duplicate.zkVersion = this.zkVersion;
            ArrayList<Integer> newReplicas = new ArrayList<Integer>(this.replicas.size());
            for (Integer n : this.replicas) {
                newReplicas.add(n);
            }
            _duplicate.replicas = newReplicas;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(this.observers.size());
            for (Integer _element : this.observers) {
                arrayList.add(_element);
            }
            _duplicate.observers = arrayList;
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(this.offlineReplicas.size());
            for (Integer _element : this.offlineReplicas) {
                arrayList2.add(_element);
            }
            _duplicate.offlineReplicas = arrayList2;
            return _duplicate;
        }

        public String toString() {
            return "UpdateMetadataPartitionState(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitionIndex=" + this.partitionIndex + ", controllerEpoch=" + this.controllerEpoch + ", leader=" + this.leader + ", leaderEpoch=" + this.leaderEpoch + ", isr=" + MessageUtil.deepToString(this.isr.iterator()) + ", zkVersion=" + this.zkVersion + ", replicas=" + MessageUtil.deepToString(this.replicas.iterator()) + ", observers=" + MessageUtil.deepToString(this.observers.iterator()) + ", offlineReplicas=" + MessageUtil.deepToString(this.offlineReplicas.iterator()) + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int controllerEpoch() {
            return this.controllerEpoch;
        }

        public int leader() {
            return this.leader;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<Integer> isr() {
            return this.isr;
        }

        public int zkVersion() {
            return this.zkVersion;
        }

        public List<Integer> replicas() {
            return this.replicas;
        }

        public List<Integer> observers() {
            return this.observers;
        }

        public List<Integer> offlineReplicas() {
            return this.offlineReplicas;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public UpdateMetadataPartitionState setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public UpdateMetadataPartitionState setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public UpdateMetadataPartitionState setControllerEpoch(int v) {
            this.controllerEpoch = v;
            return this;
        }

        public UpdateMetadataPartitionState setLeader(int v) {
            this.leader = v;
            return this;
        }

        public UpdateMetadataPartitionState setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public UpdateMetadataPartitionState setIsr(List<Integer> v) {
            this.isr = v;
            return this;
        }

        public UpdateMetadataPartitionState setZkVersion(int v) {
            this.zkVersion = v;
            return this;
        }

        public UpdateMetadataPartitionState setReplicas(List<Integer> v) {
            this.replicas = v;
            return this;
        }

        public UpdateMetadataPartitionState setObservers(List<Integer> v) {
            this.observers = v;
            return this;
        }

        public UpdateMetadataPartitionState setOfflineReplicas(List<Integer> v) {
            this.offlineReplicas = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("topic_name", Type.STRING, "In older versions of this RPC, the topic name."), new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The ID of the broker which is the current partition leader."), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition."), new Field("isr", new ArrayOf(Type.INT32), "The brokers which are in the ISR for this partition."), new Field("zk_version", Type.INT32, "The Zookeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "All the replicas of this partition."))));
            SCHEMA_4 = new Schema(new Field("topic_name", Type.STRING, "In older versions of this RPC, the topic name."), new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The ID of the broker which is the current partition leader."), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition."), new Field("isr", new ArrayOf(Type.INT32), "The brokers which are in the ISR for this partition."), new Field("zk_version", Type.INT32, "The Zookeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "All the replicas of this partition."), new Field("offline_replicas", new ArrayOf(Type.INT32), "The replicas of this partition which are offline."));
            SCHEMA_5 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The ID of the broker which is the current partition leader."), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition."), new Field("isr", new ArrayOf(Type.INT32), "The brokers which are in the ISR for this partition."), new Field("zk_version", Type.INT32, "The Zookeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "All the replicas of this partition."), new Field("offline_replicas", new ArrayOf(Type.INT32), "The replicas of this partition which are offline."));
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The ID of the broker which is the current partition leader."), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition."), new Field("isr", new CompactArrayOf(Type.INT32), "The brokers which are in the ISR for this partition."), new Field("zk_version", Type.INT32, "The Zookeeper version."), new Field("replicas", new CompactArrayOf(Type.INT32), "All the replicas of this partition."), new Field("offline_replicas", new CompactArrayOf(Type.INT32), "The replicas of this partition which are offline."), Field.TaggedFieldsSection.of(10000, new Field("observers", new CompactArrayOf(Type.INT32), "The brokers in Replicas that are observers in a partition."))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8};
        }
    }

    public static class UpdateMetadataCell
    implements Message {
        int cellId;
        List<Integer> brokers;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 7;
        public static final short HIGHEST_SUPPORTED_VERSION = 8;

        public UpdateMetadataCell(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public UpdateMetadataCell() {
            this.cellId = 0;
            this.brokers = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 8;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of UpdateMetadataCell");
            }
            this.cellId = _readable.readInt();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field brokers was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.brokers = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 7) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of UpdateMetadataCell");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.cellId);
            _writable.writeUnsignedVarint(this.brokers.size() + 1);
            for (Integer brokersElement : this.brokers) {
                _writable.writeInt(brokersElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of UpdateMetadataCell");
            }
            _size.addBytes(4);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.brokers.size() + 1));
            _size.addBytes(this.brokers.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdateMetadataCell)) {
                return false;
            }
            UpdateMetadataCell other = (UpdateMetadataCell)obj;
            if (this.cellId != other.cellId) {
                return false;
            }
            if (this.brokers == null ? other.brokers != null : !this.brokers.equals(other.brokers)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.cellId;
            hashCode = 31 * hashCode + (this.brokers == null ? 0 : this.brokers.hashCode());
            return hashCode;
        }

        @Override
        public UpdateMetadataCell duplicate() {
            UpdateMetadataCell _duplicate = new UpdateMetadataCell();
            _duplicate.cellId = this.cellId;
            ArrayList<Integer> newBrokers = new ArrayList<Integer>(this.brokers.size());
            for (Integer _element : this.brokers) {
                newBrokers.add(_element);
            }
            _duplicate.brokers = newBrokers;
            return _duplicate;
        }

        public String toString() {
            return "UpdateMetadataCell(cellId=" + this.cellId + ", brokers=" + MessageUtil.deepToString(this.brokers.iterator()) + ")";
        }

        public int cellId() {
            return this.cellId;
        }

        public List<Integer> brokers() {
            return this.brokers;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public UpdateMetadataCell setCellId(int v) {
            this.cellId = v;
            return this;
        }

        public UpdateMetadataCell setBrokers(List<Integer> v) {
            this.brokers = v;
            return this;
        }

        static {
            SCHEMA_8 = SCHEMA_7 = new Schema(new Field("cell_id", Type.INT32, "The unique id of the cell."), new Field("brokers", new CompactArrayOf(Type.INT32), "A list of brokers assigned to this cell."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{null, null, null, null, null, null, null, SCHEMA_7, SCHEMA_8};
        }
    }

    public static class Tag
    implements Message {
        String name;
        String value;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 6;
        public static final short HIGHEST_SUPPORTED_VERSION = 8;

        public Tag(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public Tag() {
            this.name = "";
            this.value = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 8;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Tag");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field value was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field value had invalid length " + length);
            }
            this.value = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 6) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of Tag");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.value);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Tag");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'value' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.value, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Tag)) {
                return false;
            }
            Tag other = (Tag)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.value == null ? 0 : this.value.hashCode());
            return hashCode;
        }

        @Override
        public Tag duplicate() {
            Tag _duplicate = new Tag();
            _duplicate.name = this.name;
            _duplicate.value = this.value;
            return _duplicate;
        }

        public String toString() {
            return "Tag(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", value=" + (this.value == null ? "null" : "'" + this.value.toString() + "'") + ")";
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Tag setName(String v) {
            this.name = v;
            return this;
        }

        public Tag setValue(String v) {
            this.value = v;
            return this;
        }

        static {
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = new Schema(new Field("name", Type.COMPACT_STRING, "The name of the tag."), new Field("value", Type.COMPACT_STRING, "The value of the tag."), Field.TaggedFieldsSection.of(new Object[0])));
            SCHEMAS = new Schema[]{null, null, null, null, null, null, SCHEMA_6, SCHEMA_7, SCHEMA_8};
        }
    }

    public static class UpdateMetadataEndpoint
    implements Message {
        int port;
        String host;
        String listener;
        short securityProtocol;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 8;

        public UpdateMetadataEndpoint(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public UpdateMetadataEndpoint() {
            this.port = 0;
            this.host = "";
            this.listener = "";
            this.securityProtocol = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 8;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of UpdateMetadataEndpoint");
            }
            this.port = _readable.readInt();
            int length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            if (_version >= 3) {
                length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field listener was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field listener had invalid length " + length);
                }
                this.listener = _readable.readString(length);
            } else {
                this.listener = "";
            }
            this.securityProtocol = _readable.readShort();
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of UpdateMetadataEndpoint");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.port);
            byte[] _stringBytes = _cache.getSerializedValue(this.host);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (_version >= 3) {
                _stringBytes = _cache.getSerializedValue(this.listener);
                if (_version >= 6) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeShort(this.securityProtocol);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of UpdateMetadataEndpoint");
            }
            _size.addBytes(4);
            byte[] _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            if (_version >= 6) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 3) {
                _stringBytes = this.listener.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'listener' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.listener, _stringBytes);
                if (_version >= 6) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 6) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdateMetadataEndpoint)) {
                return false;
            }
            UpdateMetadataEndpoint other = (UpdateMetadataEndpoint)obj;
            if (this.port != other.port) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.listener == null ? other.listener != null : !this.listener.equals(other.listener)) {
                return false;
            }
            if (this.securityProtocol != other.securityProtocol) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.port;
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + (this.listener == null ? 0 : this.listener.hashCode());
            hashCode = 31 * hashCode + this.securityProtocol;
            return hashCode;
        }

        @Override
        public UpdateMetadataEndpoint duplicate() {
            UpdateMetadataEndpoint _duplicate = new UpdateMetadataEndpoint();
            _duplicate.port = this.port;
            _duplicate.host = this.host;
            _duplicate.listener = this.listener;
            _duplicate.securityProtocol = this.securityProtocol;
            return _duplicate;
        }

        public String toString() {
            return "UpdateMetadataEndpoint(port=" + this.port + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", listener=" + (this.listener == null ? "null" : "'" + this.listener.toString() + "'") + ", securityProtocol=" + this.securityProtocol + ")";
        }

        public int port() {
            return this.port;
        }

        public String host() {
            return this.host;
        }

        public String listener() {
            return this.listener;
        }

        public short securityProtocol() {
            return this.securityProtocol;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public UpdateMetadataEndpoint setPort(int v) {
            this.port = v;
            return this;
        }

        public UpdateMetadataEndpoint setHost(String v) {
            this.host = v;
            return this;
        }

        public UpdateMetadataEndpoint setListener(String v) {
            this.listener = v;
            return this;
        }

        public UpdateMetadataEndpoint setSecurityProtocol(short v) {
            this.securityProtocol = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = new Schema(new Field("port", Type.INT32, "The port of this endpoint"), new Field("host", Type.STRING, "The hostname of this endpoint"), new Field("security_protocol", Type.INT16, "The security protocol type."));
            SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = new Schema(new Field("port", Type.INT32, "The port of this endpoint"), new Field("host", Type.STRING, "The hostname of this endpoint"), new Field("listener", Type.STRING, "The listener name."), new Field("security_protocol", Type.INT16, "The security protocol type.")));
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = new Schema(new Field("port", Type.INT32, "The port of this endpoint"), new Field("host", Type.COMPACT_STRING, "The hostname of this endpoint"), new Field("listener", Type.COMPACT_STRING, "The listener name."), new Field("security_protocol", Type.INT16, "The security protocol type."), Field.TaggedFieldsSection.of(new Object[0])));
            SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8};
        }
    }

    public static class UpdateMetadataBroker
    implements Message {
        int id;
        String v0Host;
        int v0Port;
        List<UpdateMetadataEndpoint> endpoints;
        String rack;
        List<Tag> tags;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("v0_host", Type.STRING, "The broker hostname."), new Field("v0_port", Type.INT32, "The broker port."));
        public static final Schema SCHEMA_1 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("endpoints", new ArrayOf(UpdateMetadataEndpoint.SCHEMA_1), "The broker endpoints."));
        public static final Schema SCHEMA_2 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("endpoints", new ArrayOf(UpdateMetadataEndpoint.SCHEMA_1), "The broker endpoints."), new Field("rack", Type.NULLABLE_STRING, "The rack which this broker belongs to."));
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 8;

        public UpdateMetadataBroker(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public UpdateMetadataBroker() {
            this.id = 0;
            this.v0Host = "";
            this.v0Port = 0;
            this.endpoints = new ArrayList<UpdateMetadataEndpoint>(0);
            this.rack = "";
            this.tags = new ArrayList<Tag>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 8;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int length;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of UpdateMetadataBroker");
            }
            this.id = _readable.readInt();
            if (_version <= 0) {
                length = _readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field v0Host was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field v0Host had invalid length " + length);
                }
                this.v0Host = _readable.readString(length);
            } else {
                this.v0Host = "";
            }
            this.v0Port = _version <= 0 ? _readable.readInt() : 0;
            if (_version >= 1) {
                int i;
                ArrayList<UpdateMetadataEndpoint> newCollection;
                int arrayLength;
                if (_version >= 6) {
                    arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        throw new RuntimeException("non-nullable field endpoints was serialized as null");
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(new UpdateMetadataEndpoint(_readable, _version, _context));
                    }
                    this.endpoints = newCollection;
                } else {
                    arrayLength = _readable.readInt();
                    if (arrayLength < 0) {
                        throw new RuntimeException("non-nullable field endpoints was serialized as null");
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    newCollection = new ArrayList<UpdateMetadataEndpoint>(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(new UpdateMetadataEndpoint(_readable, _version, _context));
                    }
                    this.endpoints = newCollection;
                }
            } else {
                this.endpoints = new ArrayList<UpdateMetadataEndpoint>(0);
            }
            if (_version >= 2) {
                length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
                if (length < 0) {
                    this.rack = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field rack had invalid length " + length);
                    }
                    this.rack = _readable.readString(length);
                }
            } else {
                this.rack = "";
            }
            this.tags = new ArrayList<Tag>(0);
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                block5: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        case 10000: {
                            int arrayLength = _readable.readUnsignedVarint() - 1;
                            if (arrayLength < 0) {
                                throw new RuntimeException("non-nullable field tags was serialized as null");
                            }
                            if (arrayLength > _readable.remaining()) {
                                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                            }
                            ArrayList<Tag> newCollection = new ArrayList<Tag>(arrayLength);
                            for (int i = 0; i < arrayLength; ++i) {
                                newCollection.add(new Tag(_readable, _version, _context));
                            }
                            this.tags = newCollection;
                            continue block5;
                        }
                        default: {
                            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        }
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeInt(this.id);
            if (_version <= 0) {
                _stringBytes = _cache.getSerializedValue(this.v0Host);
                _writable.writeShort((short)((byte[])_stringBytes).length);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            if (_version <= 0) {
                _writable.writeInt(this.v0Port);
            }
            if (_version >= 1) {
                UpdateMetadataEndpoint endpointsElement;
                if (_version >= 6) {
                    _writable.writeUnsignedVarint(this.endpoints.size() + 1);
                    _stringBytes = this.endpoints.iterator();
                    while (_stringBytes.hasNext()) {
                        endpointsElement = (UpdateMetadataEndpoint)_stringBytes.next();
                        endpointsElement.write(_writable, _cache, _version, _context);
                    }
                } else {
                    _writable.writeInt(this.endpoints.size());
                    _stringBytes = this.endpoints.iterator();
                    while (_stringBytes.hasNext()) {
                        endpointsElement = (UpdateMetadataEndpoint)_stringBytes.next();
                        endpointsElement.write(_writable, _cache, _version, _context);
                    }
                }
            }
            if (_version >= 2) {
                if (this.rack == null) {
                    if (_version >= 6) {
                        _writable.writeUnsignedVarint(0);
                    } else {
                        _writable.writeShort((short)-1);
                    }
                } else {
                    _stringBytes = _cache.getSerializedValue(this.rack);
                    if (_version >= 6) {
                        _writable.writeUnsignedVarint(((Object)_stringBytes).length + 1);
                    } else {
                        _writable.writeShort((short)((Object)_stringBytes).length);
                    }
                    _writable.writeByteArray((byte[])_stringBytes);
                }
            }
            if (_version >= 6 && !this.tags.isEmpty()) {
                ++_numTaggedFields;
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, 10000);
                if (!this.tags.isEmpty()) {
                    _writable.writeUnsignedVarint(10000);
                    _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.tags));
                    _writable.writeUnsignedVarint(this.tags.size() + 1);
                    for (Tag tagsElement : this.tags) {
                        tagsElement.write(_writable, _cache, _version, _context);
                    }
                }
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of UpdateMetadataBroker");
            }
            _size.addBytes(4);
            if (_version <= 0) {
                _stringBytes = this.v0Host.getBytes(StandardCharsets.UTF_8);
                if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                    throw new RuntimeException("'v0Host' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.v0Host, (byte[])_stringBytes);
                _size.addBytes(((byte[])_stringBytes).length + 2);
            }
            if (_version <= 0) {
                _size.addBytes(4);
            }
            if (_version >= 1) {
                if (_version >= 6) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.endpoints.size() + 1));
                } else {
                    _size.addBytes(4);
                }
                _stringBytes = this.endpoints.iterator();
                while (_stringBytes.hasNext()) {
                    UpdateMetadataEndpoint endpointsElement = (UpdateMetadataEndpoint)_stringBytes.next();
                    endpointsElement.addSize(_size, _cache, _version, _context);
                }
            }
            if (_version >= 2) {
                if (this.rack == null) {
                    if (_version >= 6) {
                        _size.addBytes(1);
                    } else {
                        _size.addBytes(2);
                    }
                } else {
                    _stringBytes = this.rack.getBytes(StandardCharsets.UTF_8);
                    if (((Object)_stringBytes).length > Short.MAX_VALUE) {
                        throw new RuntimeException("'rack' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(this.rack, (byte[])_stringBytes);
                    if (_version >= 6) {
                        _size.addBytes(((Object)_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((Object)_stringBytes).length + 1));
                    } else {
                        _size.addBytes(((Object)_stringBytes).length + 2);
                    }
                }
            }
            if (_version >= 6 && !this.tags.isEmpty()) {
                ++_numTaggedFields;
                _size.addBytes(2);
                int _sizeBeforeArray = _size.totalSize();
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.tags.size() + 1));
                for (Tag tagsElement : this.tags) {
                    tagsElement.addSize(_size, _cache, _version, _context);
                }
                int _arraySize = _size.totalSize() - _sizeBeforeArray;
                _cache.setArraySizeInBytes(this.tags, _arraySize);
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 6) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdateMetadataBroker)) {
                return false;
            }
            UpdateMetadataBroker other = (UpdateMetadataBroker)obj;
            if (this.id != other.id) {
                return false;
            }
            if (this.v0Host == null ? other.v0Host != null : !this.v0Host.equals(other.v0Host)) {
                return false;
            }
            if (this.v0Port != other.v0Port) {
                return false;
            }
            if (this.endpoints == null ? other.endpoints != null : !this.endpoints.equals(other.endpoints)) {
                return false;
            }
            if (this.rack == null ? other.rack != null : !this.rack.equals(other.rack)) {
                return false;
            }
            if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.id;
            hashCode = 31 * hashCode + (this.v0Host == null ? 0 : this.v0Host.hashCode());
            hashCode = 31 * hashCode + this.v0Port;
            hashCode = 31 * hashCode + (this.endpoints == null ? 0 : this.endpoints.hashCode());
            hashCode = 31 * hashCode + (this.rack == null ? 0 : this.rack.hashCode());
            hashCode = 31 * hashCode + (this.tags == null ? 0 : this.tags.hashCode());
            return hashCode;
        }

        @Override
        public UpdateMetadataBroker duplicate() {
            UpdateMetadataBroker _duplicate = new UpdateMetadataBroker();
            _duplicate.id = this.id;
            _duplicate.v0Host = this.v0Host;
            _duplicate.v0Port = this.v0Port;
            ArrayList<UpdateMetadataEndpoint> newEndpoints = new ArrayList<UpdateMetadataEndpoint>(this.endpoints.size());
            for (UpdateMetadataEndpoint _element : this.endpoints) {
                newEndpoints.add(_element.duplicate());
            }
            _duplicate.endpoints = newEndpoints;
            _duplicate.rack = this.rack == null ? null : this.rack;
            ArrayList<Tag> newTags = new ArrayList<Tag>(this.tags.size());
            for (Tag _element : this.tags) {
                newTags.add(_element.duplicate());
            }
            _duplicate.tags = newTags;
            return _duplicate;
        }

        public String toString() {
            return "UpdateMetadataBroker(id=" + this.id + ", v0Host=" + (this.v0Host == null ? "null" : "'" + this.v0Host.toString() + "'") + ", v0Port=" + this.v0Port + ", endpoints=" + MessageUtil.deepToString(this.endpoints.iterator()) + ", rack=" + (this.rack == null ? "null" : "'" + this.rack.toString() + "'") + ", tags=" + MessageUtil.deepToString(this.tags.iterator()) + ")";
        }

        public int id() {
            return this.id;
        }

        public String v0Host() {
            return this.v0Host;
        }

        public int v0Port() {
            return this.v0Port;
        }

        public List<UpdateMetadataEndpoint> endpoints() {
            return this.endpoints;
        }

        public String rack() {
            return this.rack;
        }

        public List<Tag> tags() {
            return this.tags;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public UpdateMetadataBroker setId(int v) {
            this.id = v;
            return this;
        }

        public UpdateMetadataBroker setV0Host(String v) {
            this.v0Host = v;
            return this;
        }

        public UpdateMetadataBroker setV0Port(int v) {
            this.v0Port = v;
            return this;
        }

        public UpdateMetadataBroker setEndpoints(List<UpdateMetadataEndpoint> v) {
            this.endpoints = v;
            return this;
        }

        public UpdateMetadataBroker setRack(String v) {
            this.rack = v;
            return this;
        }

        public UpdateMetadataBroker setTags(List<Tag> v) {
            this.tags = v;
            return this;
        }

        static {
            SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("endpoints", new ArrayOf(UpdateMetadataEndpoint.SCHEMA_3), "The broker endpoints."), new Field("rack", Type.NULLABLE_STRING, "The rack which this broker belongs to.")));
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("endpoints", new CompactArrayOf(UpdateMetadataEndpoint.SCHEMA_6), "The broker endpoints."), new Field("rack", Type.COMPACT_NULLABLE_STRING, "The rack which this broker belongs to."), Field.TaggedFieldsSection.of(10000, new Field("tags", new CompactArrayOf(Tag.SCHEMA_6), ""))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8};
        }
    }

    public static class MirrorTopicMetadata
    implements Message {
        Uuid linkId;
        String state;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 7;
        public static final short HIGHEST_SUPPORTED_VERSION = 8;

        public MirrorTopicMetadata(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public MirrorTopicMetadata() {
            this.linkId = Uuid.ZERO_UUID;
            this.state = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 5;
        }

        @Override
        public short highestSupportedVersion() {
            return 8;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MirrorTopicMetadata");
            }
            this.linkId = _readable.readUuid();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field state was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field state had invalid length " + length);
            }
            this.state = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 7) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MirrorTopicMetadata");
            }
            int _numTaggedFields = 0;
            _writable.writeUuid(this.linkId);
            byte[] _stringBytes = _cache.getSerializedValue(this.state);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MirrorTopicMetadata");
            }
            _size.addBytes(16);
            byte[] _stringBytes = this.state.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'state' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.state, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MirrorTopicMetadata)) {
                return false;
            }
            MirrorTopicMetadata other = (MirrorTopicMetadata)obj;
            if (!this.linkId.equals(other.linkId)) {
                return false;
            }
            if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.linkId.hashCode();
            hashCode = 31 * hashCode + (this.state == null ? 0 : this.state.hashCode());
            return hashCode;
        }

        @Override
        public MirrorTopicMetadata duplicate() {
            MirrorTopicMetadata _duplicate = new MirrorTopicMetadata();
            _duplicate.linkId = this.linkId;
            _duplicate.state = this.state;
            return _duplicate;
        }

        public String toString() {
            return "MirrorTopicMetadata(linkId=" + this.linkId.toString() + ", state=" + (this.state == null ? "null" : "'" + this.state.toString() + "'") + ")";
        }

        public Uuid linkId() {
            return this.linkId;
        }

        public String state() {
            return this.state;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MirrorTopicMetadata setLinkId(Uuid v) {
            this.linkId = v;
            return this;
        }

        public MirrorTopicMetadata setState(String v) {
            this.state = v;
            return this;
        }

        static {
            SCHEMA_8 = SCHEMA_7 = new Schema(new Field("link_id", Type.UUID, "The ID of the cluster link that the mirror topic uses"), new Field("state", Type.COMPACT_STRING, "The state of the mirror topic. The states could be one of Mirror, PausedMirror, FailedMirror, PendingStoppedMirror, and StoppedMirror"), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{null, null, null, null, null, null, null, SCHEMA_7, SCHEMA_8};
        }
    }

    public static class UpdateMetadataTopicState
    implements Message {
        String topicName;
        Uuid topicId;
        List<UpdateMetadataPartitionState> partitionStates;
        MirrorTopicMetadata mirrorTopicMetadata;
        String clusterLinkNameForMirrorTopic;
        long mirrorTopicStateLastUpdateTimeMs;
        Uuid sourceTopicIdForMirrorTopic;
        boolean linkLevelPauseForMirrorTopic;
        boolean topicLevelPauseForMirrorTopic;
        String mirrorTopicPreviousState;
        boolean mirrorTopicPromoted;
        List<Long> mirrorTopicStoppedLogEndOffsets;
        List<Long> mirrorTopicMirrorStartOffsets;
        short mirrorTopicError;
        String mirrorTopicNextState;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_5 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_states", new ArrayOf(UpdateMetadataPartitionState.SCHEMA_5), "The partition that we would like to update."));
        public static final Schema SCHEMA_6 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("partition_states", new CompactArrayOf(UpdateMetadataPartitionState.SCHEMA_6), "The partition that we would like to update."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_7 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("topic_id", Type.UUID, "The topic id."), new Field("partition_states", new CompactArrayOf(UpdateMetadataPartitionState.SCHEMA_6), "The partition that we would like to update."), Field.TaggedFieldsSection.of(10000, new Field("mirror_topic_metadata", MirrorTopicMetadata.SCHEMA_7, "The metadata of topic being mirrored by a cluster link. For regular topics, the field will be ignored or can set to default empty state.")));
        public static final Schema SCHEMA_8 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("topic_id", Type.UUID, "The topic id."), new Field("partition_states", new CompactArrayOf(UpdateMetadataPartitionState.SCHEMA_6), "The partition that we would like to update."), Field.TaggedFieldsSection.of(10000, new Field("mirror_topic_metadata", MirrorTopicMetadata.SCHEMA_7, "The metadata of topic being mirrored by a cluster link. For regular topics, the field will be ignored or can set to default empty state."), 10001, new Field("cluster_link_name_for_mirror_topic", Type.COMPACT_NULLABLE_STRING, "Cluster link name that mirror topic uses."), 10002, new Field("mirror_topic_state_last_update_time_ms", Type.INT64, "Last updated timestamp for the mirror state."), 10003, new Field("source_topic_id_for_mirror_topic", Type.UUID, "Source topic id if available, else zero UUID is used."), 10004, new Field("link_level_pause_for_mirror_topic", Type.BOOLEAN, "Applicable only for paused mirror. Specifies if the link is paused."), 10005, new Field("topic_level_pause_for_mirror_topic", Type.BOOLEAN, "Applicable only for paused mirror. Specifies if the specific topic is paused."), 10006, new Field("mirror_topic_previous_state", Type.COMPACT_NULLABLE_STRING, "Applicable only for paused mirror. Specifies if the previous state of the mirror was failed."), 10007, new Field("mirror_topic_promoted", Type.BOOLEAN, "Applicable only for pending stopped mirror. Specifies if the mirror was promoted or failed over."), 10008, new Field("mirror_topic_stopped_log_end_offsets", CompactArrayOf.nullable(Type.INT64), "Applicable only for stopped mirror. Specifies the list of log end offsets when the mirror was stopped."), 10009, new Field("mirror_topic_mirror_start_offsets", CompactArrayOf.nullable(Type.INT64), "List of earliest offsets to start mirroring from, ordered by partition. By default, mirroring starts from the first available offset."), 10010, new Field("mirror_topic_error", Type.INT16, "Mirror failure reason if the mirror is in failed state."), 10011, new Field("mirror_topic_next_state", Type.COMPACT_NULLABLE_STRING, "Applicable only for PendingSynchronizeMirror. Specifies if the next state of the remote mirror should be active or paused")));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, null, null, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8};
        public static final short LOWEST_SUPPORTED_VERSION = 5;
        public static final short HIGHEST_SUPPORTED_VERSION = 8;

        public UpdateMetadataTopicState(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public UpdateMetadataTopicState() {
            this.topicName = "";
            this.topicId = Uuid.ZERO_UUID;
            this.partitionStates = new ArrayList<UpdateMetadataPartitionState>(0);
            this.mirrorTopicMetadata = new MirrorTopicMetadata();
            this.clusterLinkNameForMirrorTopic = null;
            this.mirrorTopicStateLastUpdateTimeMs = 0L;
            this.sourceTopicIdForMirrorTopic = Uuid.ZERO_UUID;
            this.linkLevelPauseForMirrorTopic = false;
            this.topicLevelPauseForMirrorTopic = false;
            this.mirrorTopicPreviousState = null;
            this.mirrorTopicPromoted = false;
            this.mirrorTopicStoppedLogEndOffsets = null;
            this.mirrorTopicMirrorStartOffsets = null;
            this.mirrorTopicError = (short)-1;
            this.mirrorTopicNextState = null;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 8;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            ArrayList<UpdateMetadataPartitionState> newCollection;
            int arrayLength;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of UpdateMetadataTopicState");
            }
            int length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            this.topicId = _version >= 7 ? _readable.readUuid() : Uuid.ZERO_UUID;
            if (_version >= 6) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionStates was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new UpdateMetadataPartitionState(_readable, _version, _context));
                }
                this.partitionStates = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionStates was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<UpdateMetadataPartitionState>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new UpdateMetadataPartitionState(_readable, _version, _context));
                }
                this.partitionStates = newCollection;
            }
            this.mirrorTopicMetadata = new MirrorTopicMetadata();
            this.clusterLinkNameForMirrorTopic = null;
            this.mirrorTopicStateLastUpdateTimeMs = 0L;
            this.sourceTopicIdForMirrorTopic = Uuid.ZERO_UUID;
            this.linkLevelPauseForMirrorTopic = false;
            this.topicLevelPauseForMirrorTopic = false;
            this.mirrorTopicPreviousState = null;
            this.mirrorTopicPromoted = false;
            this.mirrorTopicStoppedLogEndOffsets = null;
            this.mirrorTopicMirrorStartOffsets = null;
            this.mirrorTopicError = (short)-1;
            this.mirrorTopicNextState = null;
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                block16: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        case 10000: {
                            if (_version >= 7) {
                                this.mirrorTopicMetadata = new MirrorTopicMetadata(_readable, _version, _context);
                                continue block16;
                            }
                            throw new RuntimeException("Tag 10000 is not valid for version " + _version);
                        }
                        case 10001: {
                            int length2;
                            if (_version >= 8) {
                                length2 = _readable.readUnsignedVarint() - 1;
                                if (length2 < 0) {
                                    this.clusterLinkNameForMirrorTopic = null;
                                    continue block16;
                                }
                                if (length2 > Short.MAX_VALUE) {
                                    throw new RuntimeException("string field clusterLinkNameForMirrorTopic had invalid length " + length2);
                                }
                                this.clusterLinkNameForMirrorTopic = _readable.readString(length2);
                                continue block16;
                            }
                            throw new RuntimeException("Tag 10001 is not valid for version " + _version);
                        }
                        case 10002: {
                            if (_version >= 8) {
                                this.mirrorTopicStateLastUpdateTimeMs = _readable.readLong();
                                continue block16;
                            }
                            throw new RuntimeException("Tag 10002 is not valid for version " + _version);
                        }
                        case 10003: {
                            if (_version >= 8) {
                                this.sourceTopicIdForMirrorTopic = _readable.readUuid();
                                continue block16;
                            }
                            throw new RuntimeException("Tag 10003 is not valid for version " + _version);
                        }
                        case 10004: {
                            if (_version >= 8) {
                                this.linkLevelPauseForMirrorTopic = _readable.readByte() != 0;
                                continue block16;
                            }
                            throw new RuntimeException("Tag 10004 is not valid for version " + _version);
                        }
                        case 10005: {
                            if (_version >= 8) {
                                this.topicLevelPauseForMirrorTopic = _readable.readByte() != 0;
                                continue block16;
                            }
                            throw new RuntimeException("Tag 10005 is not valid for version " + _version);
                        }
                        case 10006: {
                            int length2;
                            if (_version >= 8) {
                                length2 = _readable.readUnsignedVarint() - 1;
                                if (length2 < 0) {
                                    this.mirrorTopicPreviousState = null;
                                    continue block16;
                                }
                                if (length2 > Short.MAX_VALUE) {
                                    throw new RuntimeException("string field mirrorTopicPreviousState had invalid length " + length2);
                                }
                                this.mirrorTopicPreviousState = _readable.readString(length2);
                                continue block16;
                            }
                            throw new RuntimeException("Tag 10006 is not valid for version " + _version);
                        }
                        case 10007: {
                            if (_version >= 8) {
                                this.mirrorTopicPromoted = _readable.readByte() != 0;
                                continue block16;
                            }
                            throw new RuntimeException("Tag 10007 is not valid for version " + _version);
                        }
                        case 10008: {
                            int i2;
                            ArrayList<Long> newCollection2;
                            int arrayLength2;
                            if (_version >= 8) {
                                arrayLength2 = _readable.readUnsignedVarint() - 1;
                                if (arrayLength2 < 0) {
                                    this.mirrorTopicStoppedLogEndOffsets = null;
                                    continue block16;
                                }
                                if (arrayLength2 > _readable.remaining()) {
                                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                                }
                                newCollection2 = new ArrayList<Long>(arrayLength2);
                                for (i2 = 0; i2 < arrayLength2; ++i2) {
                                    newCollection2.add(_readable.readLong());
                                }
                                this.mirrorTopicStoppedLogEndOffsets = newCollection2;
                                continue block16;
                            }
                            throw new RuntimeException("Tag 10008 is not valid for version " + _version);
                        }
                        case 10009: {
                            int i2;
                            ArrayList<Long> newCollection2;
                            int arrayLength2;
                            if (_version >= 8) {
                                arrayLength2 = _readable.readUnsignedVarint() - 1;
                                if (arrayLength2 < 0) {
                                    this.mirrorTopicMirrorStartOffsets = null;
                                    continue block16;
                                }
                                if (arrayLength2 > _readable.remaining()) {
                                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                                }
                                newCollection2 = new ArrayList(arrayLength2);
                                for (i2 = 0; i2 < arrayLength2; ++i2) {
                                    newCollection2.add(_readable.readLong());
                                }
                                this.mirrorTopicMirrorStartOffsets = newCollection2;
                                continue block16;
                            }
                            throw new RuntimeException("Tag 10009 is not valid for version " + _version);
                        }
                        case 10010: {
                            if (_version >= 8) {
                                this.mirrorTopicError = _readable.readShort();
                                continue block16;
                            }
                            throw new RuntimeException("Tag 10010 is not valid for version " + _version);
                        }
                        case 10011: {
                            int length2;
                            if (_version >= 8) {
                                length2 = _readable.readUnsignedVarint() - 1;
                                if (length2 < 0) {
                                    this.mirrorTopicNextState = null;
                                    continue block16;
                                }
                                if (length2 > Short.MAX_VALUE) {
                                    throw new RuntimeException("string field mirrorTopicNextState had invalid length " + length2);
                                }
                                this.mirrorTopicNextState = _readable.readString(length2);
                                continue block16;
                            }
                            throw new RuntimeException("Tag 10011 is not valid for version " + _version);
                        }
                        default: {
                            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        }
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            UpdateMetadataPartitionState partitionStatesElement;
            if (_version < 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of UpdateMetadataTopicState");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topicName);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 7) {
                _writable.writeUuid(this.topicId);
            }
            if (_version >= 6) {
                _writable.writeUnsignedVarint(this.partitionStates.size() + 1);
                _stringBytes = this.partitionStates.iterator();
                while (_stringBytes.hasNext()) {
                    partitionStatesElement = (UpdateMetadataPartitionState)_stringBytes.next();
                    partitionStatesElement.write(_writable, _cache, _version, _context);
                }
            } else {
                _writable.writeInt(this.partitionStates.size());
                _stringBytes = this.partitionStates.iterator();
                while (_stringBytes.hasNext()) {
                    partitionStatesElement = (UpdateMetadataPartitionState)_stringBytes.next();
                    partitionStatesElement.write(_writable, _cache, _version, _context);
                }
            }
            if (_version >= 7 && !this.mirrorTopicMetadata.equals(new MirrorTopicMetadata())) {
                ++_numTaggedFields;
            }
            if (_version >= 8 && this.clusterLinkNameForMirrorTopic != null) {
                ++_numTaggedFields;
            }
            if (_version >= 8 && this.mirrorTopicStateLastUpdateTimeMs != 0L) {
                ++_numTaggedFields;
            }
            if (_version >= 8 && !this.sourceTopicIdForMirrorTopic.equals(Uuid.ZERO_UUID)) {
                ++_numTaggedFields;
            }
            if (_version >= 8 && this.linkLevelPauseForMirrorTopic) {
                ++_numTaggedFields;
            }
            if (_version >= 8 && this.topicLevelPauseForMirrorTopic) {
                ++_numTaggedFields;
            }
            if (_version >= 8 && this.mirrorTopicPreviousState != null) {
                ++_numTaggedFields;
            }
            if (_version >= 8 && this.mirrorTopicPromoted) {
                ++_numTaggedFields;
            }
            if (_version >= 8 && this.mirrorTopicStoppedLogEndOffsets != null) {
                ++_numTaggedFields;
            }
            if (_version >= 8 && this.mirrorTopicMirrorStartOffsets != null) {
                ++_numTaggedFields;
            }
            if (_version >= 8 && this.mirrorTopicError != -1) {
                ++_numTaggedFields;
            }
            if (_version >= 8 && this.mirrorTopicNextState != null) {
                ++_numTaggedFields;
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 6) {
                Object _stringBytes2;
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, 10000);
                if (_version >= 7 && !this.mirrorTopicMetadata.equals(new MirrorTopicMetadata())) {
                    _writable.writeUnsignedVarint(10000);
                    _writable.writeUnsignedVarint(this.mirrorTopicMetadata.size(_cache, _version, _context));
                    this.mirrorTopicMetadata.write(_writable, _cache, _version, _context);
                }
                if (_version >= 8 && this.clusterLinkNameForMirrorTopic != null) {
                    _writable.writeUnsignedVarint(10001);
                    _stringBytes2 = _cache.getSerializedValue(this.clusterLinkNameForMirrorTopic);
                    _writable.writeUnsignedVarint(((byte[])_stringBytes2).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes2).length + 1));
                    _writable.writeUnsignedVarint(((byte[])_stringBytes2).length + 1);
                    _writable.writeByteArray((byte[])_stringBytes2);
                }
                if (_version >= 8 && this.mirrorTopicStateLastUpdateTimeMs != 0L) {
                    _writable.writeUnsignedVarint(10002);
                    _writable.writeUnsignedVarint(8);
                    _writable.writeLong(this.mirrorTopicStateLastUpdateTimeMs);
                }
                if (_version >= 8 && !this.sourceTopicIdForMirrorTopic.equals(Uuid.ZERO_UUID)) {
                    _writable.writeUnsignedVarint(10003);
                    _writable.writeUnsignedVarint(16);
                    _writable.writeUuid(this.sourceTopicIdForMirrorTopic);
                }
                if (_version >= 8 && this.linkLevelPauseForMirrorTopic) {
                    _writable.writeUnsignedVarint(10004);
                    _writable.writeUnsignedVarint(1);
                    _writable.writeByte(this.linkLevelPauseForMirrorTopic ? (byte)1 : 0);
                }
                if (_version >= 8 && this.topicLevelPauseForMirrorTopic) {
                    _writable.writeUnsignedVarint(10005);
                    _writable.writeUnsignedVarint(1);
                    _writable.writeByte(this.topicLevelPauseForMirrorTopic ? (byte)1 : 0);
                }
                if (_version >= 8 && this.mirrorTopicPreviousState != null) {
                    _writable.writeUnsignedVarint(10006);
                    _stringBytes2 = _cache.getSerializedValue(this.mirrorTopicPreviousState);
                    _writable.writeUnsignedVarint(((byte[])_stringBytes2).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes2).length + 1));
                    _writable.writeUnsignedVarint(((byte[])_stringBytes2).length + 1);
                    _writable.writeByteArray((byte[])_stringBytes2);
                }
                if (_version >= 8 && this.mirrorTopicPromoted) {
                    _writable.writeUnsignedVarint(10007);
                    _writable.writeUnsignedVarint(1);
                    _writable.writeByte(this.mirrorTopicPromoted ? (byte)1 : 0);
                }
                if (_version >= 8 && this.mirrorTopicStoppedLogEndOffsets != null) {
                    _writable.writeUnsignedVarint(10008);
                    _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.mirrorTopicStoppedLogEndOffsets));
                    _writable.writeUnsignedVarint(this.mirrorTopicStoppedLogEndOffsets.size() + 1);
                    _stringBytes2 = this.mirrorTopicStoppedLogEndOffsets.iterator();
                    while (_stringBytes2.hasNext()) {
                        Long mirrorTopicStoppedLogEndOffsetsElement = (Long)_stringBytes2.next();
                        _writable.writeLong(mirrorTopicStoppedLogEndOffsetsElement);
                    }
                }
                if (_version >= 8 && this.mirrorTopicMirrorStartOffsets != null) {
                    _writable.writeUnsignedVarint(10009);
                    _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.mirrorTopicMirrorStartOffsets));
                    _writable.writeUnsignedVarint(this.mirrorTopicMirrorStartOffsets.size() + 1);
                    for (Long mirrorTopicMirrorStartOffsetsElement : this.mirrorTopicMirrorStartOffsets) {
                        _writable.writeLong(mirrorTopicMirrorStartOffsetsElement);
                    }
                }
                if (_version >= 8 && this.mirrorTopicError != -1) {
                    _writable.writeUnsignedVarint(10010);
                    _writable.writeUnsignedVarint(2);
                    _writable.writeShort(this.mirrorTopicError);
                }
                if (_version >= 8 && this.mirrorTopicNextState != null) {
                    _writable.writeUnsignedVarint(10011);
                    _stringBytes2 = _cache.getSerializedValue(this.mirrorTopicNextState);
                    _writable.writeUnsignedVarint(((byte[])_stringBytes2).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes2).length + 1));
                    _writable.writeUnsignedVarint(((Object)_stringBytes2).length + 1);
                    _writable.writeByteArray((byte[])_stringBytes2);
                }
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of UpdateMetadataTopicState");
            }
            Object _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topicName).getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topicName, (byte[])_stringBytes);
            if (_version >= 6) {
                _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
            } else {
                _size.addBytes(((byte[])_stringBytes).length + 2);
            }
            if (_version >= 7) {
                _size.addBytes(16);
            }
            if (_version >= 6) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitionStates.size() + 1));
            } else {
                _size.addBytes(4);
            }
            _stringBytes = this.partitionStates.iterator();
            while (_stringBytes.hasNext()) {
                UpdateMetadataPartitionState partitionStatesElement = (UpdateMetadataPartitionState)_stringBytes.next();
                partitionStatesElement.addSize(_size, _cache, _version, _context);
            }
            if (_version >= 7 && !this.mirrorTopicMetadata.equals(new MirrorTopicMetadata())) {
                ++_numTaggedFields;
                _size.addBytes(2);
                int _sizeBeforeStruct = _size.totalSize();
                this.mirrorTopicMetadata.addSize(_size, _cache, _version, _context);
                int _structSize = _size.totalSize() - _sizeBeforeStruct;
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_structSize));
            }
            if (_version >= 8 && this.clusterLinkNameForMirrorTopic != null) {
                ++_numTaggedFields;
                _size.addBytes(2);
                byte[] _stringBytes2 = this.clusterLinkNameForMirrorTopic.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes2.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'clusterLinkNameForMirrorTopic' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.clusterLinkNameForMirrorTopic, _stringBytes2);
                int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes2.length + 1);
                _size.addBytes(_stringBytes2.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize + _stringBytes2.length));
            }
            if (_version >= 8 && this.mirrorTopicStateLastUpdateTimeMs != 0L) {
                ++_numTaggedFields;
                _size.addBytes(2);
                _size.addBytes(1);
                _size.addBytes(8);
            }
            if (_version >= 8 && !this.sourceTopicIdForMirrorTopic.equals(Uuid.ZERO_UUID)) {
                ++_numTaggedFields;
                _size.addBytes(2);
                _size.addBytes(1);
                _size.addBytes(16);
            }
            if (_version >= 8 && this.linkLevelPauseForMirrorTopic) {
                ++_numTaggedFields;
                _size.addBytes(2);
                _size.addBytes(1);
                _size.addBytes(1);
            }
            if (_version >= 8 && this.topicLevelPauseForMirrorTopic) {
                ++_numTaggedFields;
                _size.addBytes(2);
                _size.addBytes(1);
                _size.addBytes(1);
            }
            if (_version >= 8 && this.mirrorTopicPreviousState != null) {
                ++_numTaggedFields;
                _size.addBytes(2);
                byte[] _stringBytes3 = this.mirrorTopicPreviousState.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes3.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'mirrorTopicPreviousState' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.mirrorTopicPreviousState, _stringBytes3);
                int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes3.length + 1);
                _size.addBytes(_stringBytes3.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize + _stringBytes3.length));
            }
            if (_version >= 8 && this.mirrorTopicPromoted) {
                ++_numTaggedFields;
                _size.addBytes(2);
                _size.addBytes(1);
                _size.addBytes(1);
            }
            if (_version >= 8 && this.mirrorTopicStoppedLogEndOffsets != null) {
                ++_numTaggedFields;
                _size.addBytes(2);
                int _sizeBeforeArray = _size.totalSize();
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.mirrorTopicStoppedLogEndOffsets.size() + 1));
                _size.addBytes(this.mirrorTopicStoppedLogEndOffsets.size() * 8);
                int _arraySize = _size.totalSize() - _sizeBeforeArray;
                _cache.setArraySizeInBytes(this.mirrorTopicStoppedLogEndOffsets, _arraySize);
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
            }
            if (_version >= 8 && this.mirrorTopicMirrorStartOffsets != null) {
                ++_numTaggedFields;
                _size.addBytes(2);
                int _sizeBeforeArray = _size.totalSize();
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.mirrorTopicMirrorStartOffsets.size() + 1));
                _size.addBytes(this.mirrorTopicMirrorStartOffsets.size() * 8);
                int _arraySize = _size.totalSize() - _sizeBeforeArray;
                _cache.setArraySizeInBytes(this.mirrorTopicMirrorStartOffsets, _arraySize);
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
            }
            if (_version >= 8 && this.mirrorTopicError != -1) {
                ++_numTaggedFields;
                _size.addBytes(2);
                _size.addBytes(1);
                _size.addBytes(2);
            }
            if (_version >= 8 && this.mirrorTopicNextState != null) {
                ++_numTaggedFields;
                _size.addBytes(2);
                byte[] _stringBytes4 = this.mirrorTopicNextState.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes4.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'mirrorTopicNextState' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.mirrorTopicNextState, _stringBytes4);
                int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes4.length + 1);
                _size.addBytes(_stringBytes4.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize + _stringBytes4.length));
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 6) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdateMetadataTopicState)) {
                return false;
            }
            UpdateMetadataTopicState other = (UpdateMetadataTopicState)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.partitionStates == null ? other.partitionStates != null : !this.partitionStates.equals(other.partitionStates)) {
                return false;
            }
            if (this.mirrorTopicMetadata == null ? other.mirrorTopicMetadata != null : !this.mirrorTopicMetadata.equals(other.mirrorTopicMetadata)) {
                return false;
            }
            if (this.clusterLinkNameForMirrorTopic == null ? other.clusterLinkNameForMirrorTopic != null : !this.clusterLinkNameForMirrorTopic.equals(other.clusterLinkNameForMirrorTopic)) {
                return false;
            }
            if (this.mirrorTopicStateLastUpdateTimeMs != other.mirrorTopicStateLastUpdateTimeMs) {
                return false;
            }
            if (!this.sourceTopicIdForMirrorTopic.equals(other.sourceTopicIdForMirrorTopic)) {
                return false;
            }
            if (this.linkLevelPauseForMirrorTopic != other.linkLevelPauseForMirrorTopic) {
                return false;
            }
            if (this.topicLevelPauseForMirrorTopic != other.topicLevelPauseForMirrorTopic) {
                return false;
            }
            if (this.mirrorTopicPreviousState == null ? other.mirrorTopicPreviousState != null : !this.mirrorTopicPreviousState.equals(other.mirrorTopicPreviousState)) {
                return false;
            }
            if (this.mirrorTopicPromoted != other.mirrorTopicPromoted) {
                return false;
            }
            if (this.mirrorTopicStoppedLogEndOffsets == null ? other.mirrorTopicStoppedLogEndOffsets != null : !this.mirrorTopicStoppedLogEndOffsets.equals(other.mirrorTopicStoppedLogEndOffsets)) {
                return false;
            }
            if (this.mirrorTopicMirrorStartOffsets == null ? other.mirrorTopicMirrorStartOffsets != null : !this.mirrorTopicMirrorStartOffsets.equals(other.mirrorTopicMirrorStartOffsets)) {
                return false;
            }
            if (this.mirrorTopicError != other.mirrorTopicError) {
                return false;
            }
            if (this.mirrorTopicNextState == null ? other.mirrorTopicNextState != null : !this.mirrorTopicNextState.equals(other.mirrorTopicNextState)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.partitionStates == null ? 0 : this.partitionStates.hashCode());
            hashCode = 31 * hashCode + (this.mirrorTopicMetadata == null ? 0 : this.mirrorTopicMetadata.hashCode());
            hashCode = 31 * hashCode + (this.clusterLinkNameForMirrorTopic == null ? 0 : this.clusterLinkNameForMirrorTopic.hashCode());
            hashCode = 31 * hashCode + ((int)(this.mirrorTopicStateLastUpdateTimeMs >> 32) ^ (int)this.mirrorTopicStateLastUpdateTimeMs);
            hashCode = 31 * hashCode + this.sourceTopicIdForMirrorTopic.hashCode();
            hashCode = 31 * hashCode + (this.linkLevelPauseForMirrorTopic ? 1231 : 1237);
            hashCode = 31 * hashCode + (this.topicLevelPauseForMirrorTopic ? 1231 : 1237);
            hashCode = 31 * hashCode + (this.mirrorTopicPreviousState == null ? 0 : this.mirrorTopicPreviousState.hashCode());
            hashCode = 31 * hashCode + (this.mirrorTopicPromoted ? 1231 : 1237);
            hashCode = 31 * hashCode + (this.mirrorTopicStoppedLogEndOffsets == null ? 0 : this.mirrorTopicStoppedLogEndOffsets.hashCode());
            hashCode = 31 * hashCode + (this.mirrorTopicMirrorStartOffsets == null ? 0 : this.mirrorTopicMirrorStartOffsets.hashCode());
            hashCode = 31 * hashCode + this.mirrorTopicError;
            hashCode = 31 * hashCode + (this.mirrorTopicNextState == null ? 0 : this.mirrorTopicNextState.hashCode());
            return hashCode;
        }

        @Override
        public UpdateMetadataTopicState duplicate() {
            UpdateMetadataTopicState _duplicate = new UpdateMetadataTopicState();
            _duplicate.topicName = this.topicName;
            _duplicate.topicId = this.topicId;
            ArrayList<UpdateMetadataPartitionState> newPartitionStates = new ArrayList<UpdateMetadataPartitionState>(this.partitionStates.size());
            for (UpdateMetadataPartitionState _element : this.partitionStates) {
                newPartitionStates.add(_element.duplicate());
            }
            _duplicate.partitionStates = newPartitionStates;
            _duplicate.mirrorTopicMetadata = this.mirrorTopicMetadata.duplicate();
            _duplicate.clusterLinkNameForMirrorTopic = this.clusterLinkNameForMirrorTopic == null ? null : this.clusterLinkNameForMirrorTopic;
            _duplicate.mirrorTopicStateLastUpdateTimeMs = this.mirrorTopicStateLastUpdateTimeMs;
            _duplicate.sourceTopicIdForMirrorTopic = this.sourceTopicIdForMirrorTopic;
            _duplicate.linkLevelPauseForMirrorTopic = this.linkLevelPauseForMirrorTopic;
            _duplicate.topicLevelPauseForMirrorTopic = this.topicLevelPauseForMirrorTopic;
            _duplicate.mirrorTopicPreviousState = this.mirrorTopicPreviousState == null ? null : this.mirrorTopicPreviousState;
            _duplicate.mirrorTopicPromoted = this.mirrorTopicPromoted;
            if (this.mirrorTopicStoppedLogEndOffsets == null) {
                _duplicate.mirrorTopicStoppedLogEndOffsets = null;
            } else {
                ArrayList<Long> newMirrorTopicStoppedLogEndOffsets = new ArrayList<Long>(this.mirrorTopicStoppedLogEndOffsets.size());
                for (Long _element : this.mirrorTopicStoppedLogEndOffsets) {
                    newMirrorTopicStoppedLogEndOffsets.add(_element);
                }
                _duplicate.mirrorTopicStoppedLogEndOffsets = newMirrorTopicStoppedLogEndOffsets;
            }
            if (this.mirrorTopicMirrorStartOffsets == null) {
                _duplicate.mirrorTopicMirrorStartOffsets = null;
            } else {
                ArrayList<Long> newMirrorTopicMirrorStartOffsets = new ArrayList<Long>(this.mirrorTopicMirrorStartOffsets.size());
                for (Long _element : this.mirrorTopicMirrorStartOffsets) {
                    newMirrorTopicMirrorStartOffsets.add(_element);
                }
                _duplicate.mirrorTopicMirrorStartOffsets = newMirrorTopicMirrorStartOffsets;
            }
            _duplicate.mirrorTopicError = this.mirrorTopicError;
            _duplicate.mirrorTopicNextState = this.mirrorTopicNextState == null ? null : this.mirrorTopicNextState;
            return _duplicate;
        }

        public String toString() {
            return "UpdateMetadataTopicState(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", topicId=" + this.topicId.toString() + ", partitionStates=" + MessageUtil.deepToString(this.partitionStates.iterator()) + ", mirrorTopicMetadata=" + this.mirrorTopicMetadata.toString() + ", clusterLinkNameForMirrorTopic=" + (this.clusterLinkNameForMirrorTopic == null ? "null" : "'" + this.clusterLinkNameForMirrorTopic.toString() + "'") + ", mirrorTopicStateLastUpdateTimeMs=" + this.mirrorTopicStateLastUpdateTimeMs + ", sourceTopicIdForMirrorTopic=" + this.sourceTopicIdForMirrorTopic.toString() + ", linkLevelPauseForMirrorTopic=" + (this.linkLevelPauseForMirrorTopic ? "true" : "false") + ", topicLevelPauseForMirrorTopic=" + (this.topicLevelPauseForMirrorTopic ? "true" : "false") + ", mirrorTopicPreviousState=" + (this.mirrorTopicPreviousState == null ? "null" : "'" + this.mirrorTopicPreviousState.toString() + "'") + ", mirrorTopicPromoted=" + (this.mirrorTopicPromoted ? "true" : "false") + ", mirrorTopicStoppedLogEndOffsets=" + (this.mirrorTopicStoppedLogEndOffsets == null ? "null" : MessageUtil.deepToString(this.mirrorTopicStoppedLogEndOffsets.iterator())) + ", mirrorTopicMirrorStartOffsets=" + (this.mirrorTopicMirrorStartOffsets == null ? "null" : MessageUtil.deepToString(this.mirrorTopicMirrorStartOffsets.iterator())) + ", mirrorTopicError=" + this.mirrorTopicError + ", mirrorTopicNextState=" + (this.mirrorTopicNextState == null ? "null" : "'" + this.mirrorTopicNextState.toString() + "'") + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public List<UpdateMetadataPartitionState> partitionStates() {
            return this.partitionStates;
        }

        public MirrorTopicMetadata mirrorTopicMetadata() {
            return this.mirrorTopicMetadata;
        }

        public String clusterLinkNameForMirrorTopic() {
            return this.clusterLinkNameForMirrorTopic;
        }

        public long mirrorTopicStateLastUpdateTimeMs() {
            return this.mirrorTopicStateLastUpdateTimeMs;
        }

        public Uuid sourceTopicIdForMirrorTopic() {
            return this.sourceTopicIdForMirrorTopic;
        }

        public boolean linkLevelPauseForMirrorTopic() {
            return this.linkLevelPauseForMirrorTopic;
        }

        public boolean topicLevelPauseForMirrorTopic() {
            return this.topicLevelPauseForMirrorTopic;
        }

        public String mirrorTopicPreviousState() {
            return this.mirrorTopicPreviousState;
        }

        public boolean mirrorTopicPromoted() {
            return this.mirrorTopicPromoted;
        }

        public List<Long> mirrorTopicStoppedLogEndOffsets() {
            return this.mirrorTopicStoppedLogEndOffsets;
        }

        public List<Long> mirrorTopicMirrorStartOffsets() {
            return this.mirrorTopicMirrorStartOffsets;
        }

        public short mirrorTopicError() {
            return this.mirrorTopicError;
        }

        public String mirrorTopicNextState() {
            return this.mirrorTopicNextState;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public UpdateMetadataTopicState setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public UpdateMetadataTopicState setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public UpdateMetadataTopicState setPartitionStates(List<UpdateMetadataPartitionState> v) {
            this.partitionStates = v;
            return this;
        }

        public UpdateMetadataTopicState setMirrorTopicMetadata(MirrorTopicMetadata v) {
            this.mirrorTopicMetadata = v;
            return this;
        }

        public UpdateMetadataTopicState setClusterLinkNameForMirrorTopic(String v) {
            this.clusterLinkNameForMirrorTopic = v;
            return this;
        }

        public UpdateMetadataTopicState setMirrorTopicStateLastUpdateTimeMs(long v) {
            this.mirrorTopicStateLastUpdateTimeMs = v;
            return this;
        }

        public UpdateMetadataTopicState setSourceTopicIdForMirrorTopic(Uuid v) {
            this.sourceTopicIdForMirrorTopic = v;
            return this;
        }

        public UpdateMetadataTopicState setLinkLevelPauseForMirrorTopic(boolean v) {
            this.linkLevelPauseForMirrorTopic = v;
            return this;
        }

        public UpdateMetadataTopicState setTopicLevelPauseForMirrorTopic(boolean v) {
            this.topicLevelPauseForMirrorTopic = v;
            return this;
        }

        public UpdateMetadataTopicState setMirrorTopicPreviousState(String v) {
            this.mirrorTopicPreviousState = v;
            return this;
        }

        public UpdateMetadataTopicState setMirrorTopicPromoted(boolean v) {
            this.mirrorTopicPromoted = v;
            return this;
        }

        public UpdateMetadataTopicState setMirrorTopicStoppedLogEndOffsets(List<Long> v) {
            this.mirrorTopicStoppedLogEndOffsets = v;
            return this;
        }

        public UpdateMetadataTopicState setMirrorTopicMirrorStartOffsets(List<Long> v) {
            this.mirrorTopicMirrorStartOffsets = v;
            return this;
        }

        public UpdateMetadataTopicState setMirrorTopicError(short v) {
            this.mirrorTopicError = v;
            return this;
        }

        public UpdateMetadataTopicState setMirrorTopicNextState(String v) {
            this.mirrorTopicNextState = v;
            return this;
        }
    }

    public static class UpdateMetadataBrokerHealthState
    implements Message {
        int brokerId;
        List<Byte> degradedComponents;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 7;
        public static final short HIGHEST_SUPPORTED_VERSION = 8;

        public UpdateMetadataBrokerHealthState(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public UpdateMetadataBrokerHealthState() {
            this.brokerId = 0;
            this.degradedComponents = new ArrayList<Byte>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 8;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of UpdateMetadataBrokerHealthState");
            }
            this.brokerId = _readable.readInt();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field degradedComponents was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Byte> newCollection = new ArrayList<Byte>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readByte());
            }
            this.degradedComponents = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 7) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of UpdateMetadataBrokerHealthState");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            _writable.writeUnsignedVarint(this.degradedComponents.size() + 1);
            for (Byte degradedComponentsElement : this.degradedComponents) {
                _writable.writeByte(degradedComponentsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of UpdateMetadataBrokerHealthState");
            }
            _size.addBytes(4);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.degradedComponents.size() + 1));
            _size.addBytes(this.degradedComponents.size() * 1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdateMetadataBrokerHealthState)) {
                return false;
            }
            UpdateMetadataBrokerHealthState other = (UpdateMetadataBrokerHealthState)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            if (this.degradedComponents == null ? other.degradedComponents != null : !this.degradedComponents.equals(other.degradedComponents)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            hashCode = 31 * hashCode + (this.degradedComponents == null ? 0 : this.degradedComponents.hashCode());
            return hashCode;
        }

        @Override
        public UpdateMetadataBrokerHealthState duplicate() {
            UpdateMetadataBrokerHealthState _duplicate = new UpdateMetadataBrokerHealthState();
            _duplicate.brokerId = this.brokerId;
            ArrayList<Byte> newDegradedComponents = new ArrayList<Byte>(this.degradedComponents.size());
            for (Byte _element : this.degradedComponents) {
                newDegradedComponents.add(_element);
            }
            _duplicate.degradedComponents = newDegradedComponents;
            return _duplicate;
        }

        public String toString() {
            return "UpdateMetadataBrokerHealthState(brokerId=" + this.brokerId + ", degradedComponents=" + MessageUtil.deepToString(this.degradedComponents.iterator()) + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        public List<Byte> degradedComponents() {
            return this.degradedComponents;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public UpdateMetadataBrokerHealthState setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        public UpdateMetadataBrokerHealthState setDegradedComponents(List<Byte> v) {
            this.degradedComponents = v;
            return this;
        }

        static {
            SCHEMA_8 = SCHEMA_7 = new Schema(new Field("broker_id", Type.INT32, "An integer representing the broker whose health state we want to update."), new Field("degraded_components", new CompactArrayOf(Type.INT8), "A list of integers representing the components that are currently degraded for this broker. One of GENERAL (0), STORAGE (1), or NETWORK (2)."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{null, null, null, null, null, null, null, SCHEMA_7, SCHEMA_8};
        }
    }
}

