/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class UnAssignBrokersFromCellRequestData
implements ApiMessage {
    int cellId;
    List<Integer> brokerIds;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("cell_id", Type.INT32, "The cell ID."), new Field("broker_ids", new CompactArrayOf(Type.INT32), "List of brokerIds that needs to be un-assigned from the given cell."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public UnAssignBrokersFromCellRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public UnAssignBrokersFromCellRequestData() {
        this.cellId = 0;
        this.brokerIds = new ArrayList<Integer>(0);
    }

    @Override
    public short apiKey() {
        return 10034;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.cellId = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field brokerIds was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.brokerIds = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.cellId);
        _writable.writeUnsignedVarint(this.brokerIds.size() + 1);
        for (Integer brokerIdsElement : this.brokerIds) {
            _writable.writeInt(brokerIdsElement);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.brokerIds.size() + 1));
        _size.addBytes(this.brokerIds.size() * 4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UnAssignBrokersFromCellRequestData)) {
            return false;
        }
        UnAssignBrokersFromCellRequestData other = (UnAssignBrokersFromCellRequestData)obj;
        if (this.cellId != other.cellId) {
            return false;
        }
        if (this.brokerIds == null ? other.brokerIds != null : !this.brokerIds.equals(other.brokerIds)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.cellId;
        hashCode = 31 * hashCode + (this.brokerIds == null ? 0 : this.brokerIds.hashCode());
        return hashCode;
    }

    @Override
    public UnAssignBrokersFromCellRequestData duplicate() {
        UnAssignBrokersFromCellRequestData _duplicate = new UnAssignBrokersFromCellRequestData();
        _duplicate.cellId = this.cellId;
        ArrayList<Integer> newBrokerIds = new ArrayList<Integer>(this.brokerIds.size());
        for (Integer _element : this.brokerIds) {
            newBrokerIds.add(_element);
        }
        _duplicate.brokerIds = newBrokerIds;
        return _duplicate;
    }

    public String toString() {
        return "UnAssignBrokersFromCellRequestData(cellId=" + this.cellId + ", brokerIds=" + MessageUtil.deepToString(this.brokerIds.iterator()) + ")";
    }

    public int cellId() {
        return this.cellId;
    }

    public List<Integer> brokerIds() {
        return this.brokerIds;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public UnAssignBrokersFromCellRequestData setCellId(int v) {
        this.cellId = v;
        return this;
    }

    public UnAssignBrokersFromCellRequestData setBrokerIds(List<Integer> v) {
        this.brokerIds = v;
        return this;
    }
}

