/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class EnvelopeRequestData
implements ApiMessage {
    ByteBuffer requestData;
    byte[] requestPrincipal;
    byte[] clientHostAddress;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("request_data", Type.COMPACT_BYTES, "The embedded request header and data."), new Field("request_principal", Type.COMPACT_NULLABLE_BYTES, "Value of the initial client principal when the request is redirected by a broker."), new Field("client_host_address", Type.COMPACT_BYTES, "The original client's address in bytes."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public EnvelopeRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public EnvelopeRequestData() {
        this.requestData = ByteUtils.EMPTY_BUF;
        this.requestPrincipal = Bytes.EMPTY;
        this.clientHostAddress = Bytes.EMPTY;
    }

    @Override
    public short apiKey() {
        return 58;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        byte[] newBytes;
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field requestData was serialized as null");
        }
        this.requestData = _readable.readByteBuffer(length);
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.requestPrincipal = null;
        } else {
            newBytes = _readable.readArray(length);
            this.requestPrincipal = newBytes;
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field clientHostAddress was serialized as null");
        }
        newBytes = _readable.readArray(length);
        this.clientHostAddress = newBytes;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.requestData.remaining() + 1);
        _writable.writeByteBuffer(this.requestData);
        if (this.requestPrincipal == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.requestPrincipal.length + 1);
            _writable.writeByteArray(this.requestPrincipal);
        }
        _writable.writeUnsignedVarint(this.clientHostAddress.length + 1);
        _writable.writeByteArray(this.clientHostAddress);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addZeroCopyBytes(this.requestData.remaining());
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.requestData.remaining() + 1));
        if (this.requestPrincipal == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(this.requestPrincipal.length);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.requestPrincipal.length + 1));
        }
        _size.addBytes(this.clientHostAddress.length);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.clientHostAddress.length + 1));
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EnvelopeRequestData)) {
            return false;
        }
        EnvelopeRequestData other = (EnvelopeRequestData)obj;
        if (!Objects.equals(this.requestData, other.requestData)) {
            return false;
        }
        if (!Arrays.equals(this.requestPrincipal, other.requestPrincipal)) {
            return false;
        }
        if (!Arrays.equals(this.clientHostAddress, other.clientHostAddress)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + Objects.hashCode(this.requestData);
        hashCode = 31 * hashCode + Arrays.hashCode(this.requestPrincipal);
        hashCode = 31 * hashCode + Arrays.hashCode(this.clientHostAddress);
        return hashCode;
    }

    @Override
    public EnvelopeRequestData duplicate() {
        EnvelopeRequestData _duplicate = new EnvelopeRequestData();
        _duplicate.requestData = this.requestData.duplicate();
        _duplicate.requestPrincipal = (byte[])(this.requestPrincipal == null ? null : MessageUtil.duplicate(this.requestPrincipal));
        _duplicate.clientHostAddress = MessageUtil.duplicate(this.clientHostAddress);
        return _duplicate;
    }

    public String toString() {
        return "EnvelopeRequestData(requestData=" + this.requestData + ", requestPrincipal=" + Arrays.toString(this.requestPrincipal) + ", clientHostAddress=" + Arrays.toString(this.clientHostAddress) + ")";
    }

    public ByteBuffer requestData() {
        return this.requestData;
    }

    public byte[] requestPrincipal() {
        return this.requestPrincipal;
    }

    public byte[] clientHostAddress() {
        return this.clientHostAddress;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public EnvelopeRequestData setRequestData(ByteBuffer v) {
        this.requestData = v;
        return this;
    }

    public EnvelopeRequestData setRequestPrincipal(byte[] v) {
        this.requestPrincipal = v;
        return this;
    }

    public EnvelopeRequestData setClientHostAddress(byte[] v) {
        this.clientHostAddress = v;
        return this;
    }
}

