/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.DescribeClusterLinksResponseData;
import org.apache.kafka.common.protocol.MessageUtil;

public class DescribeClusterLinksResponseDataJsonConverter {
    public static DescribeClusterLinksResponseData read(JsonNode _node, short _version) {
        DescribeClusterLinksResponseData _object = new DescribeClusterLinksResponseData();
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            throw new RuntimeException("DescribeClusterLinksResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
        }
        _object.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "DescribeClusterLinksResponseData");
        JsonNode _errorCodeNode = _node.get("errorCode");
        if (_errorCodeNode == null) {
            throw new RuntimeException("DescribeClusterLinksResponseData: unable to locate field 'errorCode', which is mandatory in version " + _version);
        }
        _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "DescribeClusterLinksResponseData");
        JsonNode _errorMessageNode = _node.get("errorMessage");
        if (_errorMessageNode == null) {
            throw new RuntimeException("DescribeClusterLinksResponseData: unable to locate field 'errorMessage', which is mandatory in version " + _version);
        }
        if (_errorMessageNode.isNull()) {
            _object.errorMessage = null;
        } else {
            if (!_errorMessageNode.isTextual()) {
                throw new RuntimeException("DescribeClusterLinksResponseData expected a string type, but got " + _node.getNodeType());
            }
            _object.errorMessage = _errorMessageNode.asText();
        }
        JsonNode _entriesNode = _node.get("entries");
        if (_entriesNode == null) {
            throw new RuntimeException("DescribeClusterLinksResponseData: unable to locate field 'entries', which is mandatory in version " + _version);
        }
        if (_entriesNode.isNull()) {
            _object.entries = null;
        } else {
            if (!_entriesNode.isArray()) {
                throw new RuntimeException("DescribeClusterLinksResponseData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<DescribeClusterLinksResponseData.EntryData> _collection = new ArrayList<DescribeClusterLinksResponseData.EntryData>(_entriesNode.size());
            _object.entries = _collection;
            for (JsonNode _element : _entriesNode) {
                _collection.add(EntryDataJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }

    public static JsonNode write(DescribeClusterLinksResponseData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("throttleTimeMs", (JsonNode)new IntNode(_object.throttleTimeMs));
        _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
        if (_object.errorMessage == null) {
            _node.set("errorMessage", (JsonNode)NullNode.instance);
        } else {
            _node.set("errorMessage", (JsonNode)new TextNode(_object.errorMessage));
        }
        if (_object.entries == null) {
            _node.set("entries", (JsonNode)NullNode.instance);
        } else {
            ArrayNode _entriesArray = new ArrayNode(JsonNodeFactory.instance);
            for (DescribeClusterLinksResponseData.EntryData _element : _object.entries) {
                _entriesArray.add(EntryDataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("entries", (JsonNode)_entriesArray);
        }
        return _node;
    }

    public static JsonNode write(DescribeClusterLinksResponseData _object, short _version) {
        return DescribeClusterLinksResponseDataJsonConverter.write(_object, _version, true);
    }

    public static class EntryDataJsonConverter {
        public static DescribeClusterLinksResponseData.EntryData read(JsonNode _node, short _version) {
            DescribeClusterLinksResponseData.EntryData _object = new DescribeClusterLinksResponseData.EntryData();
            JsonNode _linkNameNode = _node.get("linkName");
            if (_linkNameNode == null) {
                throw new RuntimeException("EntryData: unable to locate field 'linkName', which is mandatory in version " + _version);
            }
            if (!_linkNameNode.isTextual()) {
                throw new RuntimeException("EntryData expected a string type, but got " + _node.getNodeType());
            }
            _object.linkName = _linkNameNode.asText();
            JsonNode _linkIdNode = _node.get("linkId");
            if (_linkIdNode == null) {
                throw new RuntimeException("EntryData: unable to locate field 'linkId', which is mandatory in version " + _version);
            }
            if (!_linkIdNode.isTextual()) {
                throw new RuntimeException("EntryData expected a JSON string type, but got " + _node.getNodeType());
            }
            _object.linkId = Uuid.fromString(_linkIdNode.asText());
            JsonNode _remoteClusterIdNode = _node.get("remoteClusterId");
            if (_remoteClusterIdNode == null) {
                throw new RuntimeException("EntryData: unable to locate field 'remoteClusterId', which is mandatory in version " + _version);
            }
            if (_remoteClusterIdNode.isNull()) {
                _object.remoteClusterId = null;
            } else {
                if (!_remoteClusterIdNode.isTextual()) {
                    throw new RuntimeException("EntryData expected a string type, but got " + _node.getNodeType());
                }
                _object.remoteClusterId = _remoteClusterIdNode.asText();
            }
            JsonNode _localClusterIdNode = _node.get("localClusterId");
            if (_localClusterIdNode == null) {
                throw new RuntimeException("EntryData: unable to locate field 'localClusterId', which is mandatory in version " + _version);
            }
            if (!_localClusterIdNode.isTextual()) {
                throw new RuntimeException("EntryData expected a string type, but got " + _node.getNodeType());
            }
            _object.localClusterId = _localClusterIdNode.asText();
            JsonNode _topicsNode = _node.get("topics");
            if (_topicsNode == null) {
                throw new RuntimeException("EntryData: unable to locate field 'topics', which is mandatory in version " + _version);
            }
            if (_topicsNode.isNull()) {
                _object.topics = null;
            } else {
                if (!_topicsNode.isArray()) {
                    throw new RuntimeException("EntryData expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<String> _collection = new ArrayList<String>(_topicsNode.size());
                _object.topics = _collection;
                for (JsonNode _element : _topicsNode) {
                    if (!_element.isTextual()) {
                        throw new RuntimeException("EntryData element expected a string type, but got " + _node.getNodeType());
                    }
                    _collection.add(_element.asText());
                }
            }
            JsonNode _linkModeNode = _node.get("linkMode");
            if (_linkModeNode == null) {
                throw new RuntimeException("EntryData: unable to locate field 'linkMode', which is mandatory in version " + _version);
            }
            _object.linkMode = MessageUtil.jsonNodeToShort(_linkModeNode, "EntryData");
            JsonNode _connectionModeNode = _node.get("connectionMode");
            if (_connectionModeNode == null) {
                throw new RuntimeException("EntryData: unable to locate field 'connectionMode', which is mandatory in version " + _version);
            }
            _object.connectionMode = MessageUtil.jsonNodeToShort(_connectionModeNode, "EntryData");
            JsonNode _linkStateNode = _node.get("linkState");
            if (_linkStateNode == null) {
                throw new RuntimeException("EntryData: unable to locate field 'linkState', which is mandatory in version " + _version);
            }
            _object.linkState = MessageUtil.jsonNodeToShort(_linkStateNode, "EntryData");
            JsonNode _linkCoordinatorIdNode = _node.get("linkCoordinatorId");
            if (_linkCoordinatorIdNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("EntryData: unable to locate field 'linkCoordinatorId', which is mandatory in version " + _version);
                }
                _object.linkCoordinatorId = -1;
            } else {
                _object.linkCoordinatorId = MessageUtil.jsonNodeToInt(_linkCoordinatorIdNode, "EntryData");
            }
            JsonNode _linkCoordinatorHostNode = _node.get("linkCoordinatorHost");
            if (_linkCoordinatorHostNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("EntryData: unable to locate field 'linkCoordinatorHost', which is mandatory in version " + _version);
                }
                _object.linkCoordinatorHost = "";
            } else if (_linkCoordinatorHostNode.isNull()) {
                _object.linkCoordinatorHost = null;
            } else {
                if (!_linkCoordinatorHostNode.isTextual()) {
                    throw new RuntimeException("EntryData expected a string type, but got " + _node.getNodeType());
                }
                _object.linkCoordinatorHost = _linkCoordinatorHostNode.asText();
            }
            JsonNode _linkCoordinatorPortNode = _node.get("linkCoordinatorPort");
            if (_linkCoordinatorPortNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("EntryData: unable to locate field 'linkCoordinatorPort', which is mandatory in version " + _version);
                }
                _object.linkCoordinatorPort = -1;
            } else {
                _object.linkCoordinatorPort = MessageUtil.jsonNodeToInt(_linkCoordinatorPortNode, "EntryData");
            }
            JsonNode _linkErrorCodeNode = _node.get("linkErrorCode");
            if (_linkErrorCodeNode == null) {
                if (_version >= 2) {
                    throw new RuntimeException("EntryData: unable to locate field 'linkErrorCode', which is mandatory in version " + _version);
                }
                _object.linkErrorCode = 0;
            } else {
                _object.linkErrorCode = MessageUtil.jsonNodeToShort(_linkErrorCodeNode, "EntryData");
            }
            JsonNode _linkErrorMessageNode = _node.get("linkErrorMessage");
            if (_linkErrorMessageNode == null) {
                if (_version >= 2) {
                    throw new RuntimeException("EntryData: unable to locate field 'linkErrorMessage', which is mandatory in version " + _version);
                }
                _object.linkErrorMessage = null;
            } else if (_linkErrorMessageNode.isNull()) {
                _object.linkErrorMessage = null;
            } else {
                if (!_linkErrorMessageNode.isTextual()) {
                    throw new RuntimeException("EntryData expected a string type, but got " + _node.getNodeType());
                }
                _object.linkErrorMessage = _linkErrorMessageNode.asText();
            }
            JsonNode _remoteLinkStateNode = _node.get("remoteLinkState");
            if (_remoteLinkStateNode == null) {
                if (_version >= 3) {
                    throw new RuntimeException("EntryData: unable to locate field 'remoteLinkState', which is mandatory in version " + _version);
                }
                _object.remoteLinkState = (short)-1;
            } else {
                _object.remoteLinkState = MessageUtil.jsonNodeToShort(_remoteLinkStateNode, "EntryData");
            }
            JsonNode _remoteLinkErrorCodeNode = _node.get("remoteLinkErrorCode");
            if (_remoteLinkErrorCodeNode == null) {
                if (_version >= 3) {
                    throw new RuntimeException("EntryData: unable to locate field 'remoteLinkErrorCode', which is mandatory in version " + _version);
                }
                _object.remoteLinkErrorCode = 0;
            } else {
                _object.remoteLinkErrorCode = MessageUtil.jsonNodeToShort(_remoteLinkErrorCodeNode, "EntryData");
            }
            JsonNode _remoteLinkErrorMessageNode = _node.get("remoteLinkErrorMessage");
            if (_remoteLinkErrorMessageNode == null) {
                if (_version >= 3) {
                    throw new RuntimeException("EntryData: unable to locate field 'remoteLinkErrorMessage', which is mandatory in version " + _version);
                }
                _object.remoteLinkErrorMessage = null;
            } else if (_remoteLinkErrorMessageNode.isNull()) {
                _object.remoteLinkErrorMessage = null;
            } else {
                if (!_remoteLinkErrorMessageNode.isTextual()) {
                    throw new RuntimeException("EntryData expected a string type, but got " + _node.getNodeType());
                }
                _object.remoteLinkErrorMessage = _remoteLinkErrorMessageNode.asText();
            }
            JsonNode _remoteLinkStateTimeMsNode = _node.get("remoteLinkStateTimeMs");
            if (_remoteLinkStateTimeMsNode == null) {
                if (_version >= 3) {
                    throw new RuntimeException("EntryData: unable to locate field 'remoteLinkStateTimeMs', which is mandatory in version " + _version);
                }
                _object.remoteLinkStateTimeMs = -1L;
            } else {
                _object.remoteLinkStateTimeMs = MessageUtil.jsonNodeToLong(_remoteLinkStateTimeMsNode, "EntryData");
            }
            return _object;
        }

        public static JsonNode write(DescribeClusterLinksResponseData.EntryData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("linkName", (JsonNode)new TextNode(_object.linkName));
            _node.set("linkId", (JsonNode)new TextNode(_object.linkId.toString()));
            if (_object.remoteClusterId == null) {
                _node.set("remoteClusterId", (JsonNode)NullNode.instance);
            } else {
                _node.set("remoteClusterId", (JsonNode)new TextNode(_object.remoteClusterId));
            }
            _node.set("localClusterId", (JsonNode)new TextNode(_object.localClusterId));
            if (_object.topics == null) {
                _node.set("topics", (JsonNode)NullNode.instance);
            } else {
                ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
                for (String _element : _object.topics) {
                    _topicsArray.add((JsonNode)new TextNode(_element));
                }
                _node.set("topics", (JsonNode)_topicsArray);
            }
            _node.set("linkMode", (JsonNode)new ShortNode(_object.linkMode));
            _node.set("connectionMode", (JsonNode)new ShortNode(_object.connectionMode));
            _node.set("linkState", (JsonNode)new ShortNode(_object.linkState));
            if (_version >= 1) {
                _node.set("linkCoordinatorId", (JsonNode)new IntNode(_object.linkCoordinatorId));
            }
            if (_version >= 1) {
                if (_object.linkCoordinatorHost == null) {
                    _node.set("linkCoordinatorHost", (JsonNode)NullNode.instance);
                } else {
                    _node.set("linkCoordinatorHost", (JsonNode)new TextNode(_object.linkCoordinatorHost));
                }
            }
            if (_version >= 1) {
                _node.set("linkCoordinatorPort", (JsonNode)new IntNode(_object.linkCoordinatorPort));
            }
            if (_version >= 2) {
                _node.set("linkErrorCode", (JsonNode)new ShortNode(_object.linkErrorCode));
            }
            if (_version >= 2) {
                if (_object.linkErrorMessage == null) {
                    _node.set("linkErrorMessage", (JsonNode)NullNode.instance);
                } else {
                    _node.set("linkErrorMessage", (JsonNode)new TextNode(_object.linkErrorMessage));
                }
            }
            if (_version >= 3) {
                _node.set("remoteLinkState", (JsonNode)new ShortNode(_object.remoteLinkState));
            }
            if (_version >= 3) {
                _node.set("remoteLinkErrorCode", (JsonNode)new ShortNode(_object.remoteLinkErrorCode));
            }
            if (_version >= 3) {
                if (_object.remoteLinkErrorMessage == null) {
                    _node.set("remoteLinkErrorMessage", (JsonNode)NullNode.instance);
                } else {
                    _node.set("remoteLinkErrorMessage", (JsonNode)new TextNode(_object.remoteLinkErrorMessage));
                }
            }
            if (_version >= 3) {
                _node.set("remoteLinkStateTimeMs", (JsonNode)new LongNode(_object.remoteLinkStateTimeMs));
            }
            return _node;
        }

        public static JsonNode write(DescribeClusterLinksResponseData.EntryData _object, short _version) {
            return EntryDataJsonConverter.write(_object, _version, true);
        }
    }
}

